/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.history.item.recognizer.processors;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.bpm.metadata.history.model.ChangedFile;
import oracle.bpm.metadata.history.model.ChangedItem;
import oracle.bpm.metadata.history.model.LogicalArtifactType;
import oracle.bpm.util.FileUtils;
import org.jetbrains.annotations.NotNull;

public class LogicalArtifactProcessor {
    protected LogicalArtifactType logicalArtifactType;

    public LogicalArtifactProcessor(@NotNull LogicalArtifactType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/item/recognizer/processors/LogicalArtifactProcessor.<init> must not be null");
        }
        this.logicalArtifactType = type;
    }

    public boolean process(@NotNull ChangedFile changedFile, @NotNull List<ChangedItem> changedItems, @NotNull Collection<ChangedFile> filesNotYetProcessed) {
        if (changedFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/item/recognizer/processors/LogicalArtifactProcessor.process must not be null");
        }
        if (changedItems == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/history/item/recognizer/processors/LogicalArtifactProcessor.process must not be null");
        }
        if (filesNotYetProcessed == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/history/item/recognizer/processors/LogicalArtifactProcessor.process must not be null");
        }
        if (this.isRecognized(changedFile.getCanonicalPath())) {
            ChangedItem newChangedItem = this.createChangedItem(changedFile);
            changedItems.add(newChangedItem);
            filesNotYetProcessed.remove(changedFile);
            String filename = this.getFileName(changedFile.getCanonicalPath());
            this.removeRelatedFiles(filename, filesNotYetProcessed);
            return true;
        }
        return false;
    }

    protected void removeRelatedFiles(@NotNull String fileNameWithoutExtension, @NotNull Collection<ChangedFile> filesNotYetProcessed) {
        if (fileNameWithoutExtension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/item/recognizer/processors/LogicalArtifactProcessor.removeRelatedFiles must not be null");
        }
        if (filesNotYetProcessed == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/history/item/recognizer/processors/LogicalArtifactProcessor.removeRelatedFiles must not be null");
        }
        ArrayList<String> filesToBeRemoved = new ArrayList<String>();
        for (String ending : this.logicalArtifactType.getIgnoreFilesEndings()) {
            filesToBeRemoved.add(fileNameWithoutExtension + ending);
        }
        ArrayList<ChangedFile> filesNotYetProcessedCopy = new ArrayList<ChangedFile>(filesNotYetProcessed);
        block1: for (ChangedFile changedFile : filesNotYetProcessedCopy) {
            for (String fileName : filesToBeRemoved) {
                if (!changedFile.getFileName().equals(fileName)) continue;
                filesNotYetProcessed.remove(changedFile);
                continue block1;
            }
        }
    }

    private boolean isRecognized(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/item/recognizer/processors/LogicalArtifactProcessor.isRecognized must not be null");
        }
        Pattern pattern = Pattern.compile(this.logicalArtifactType.getRecognitionRegex());
        Matcher matcher = pattern.matcher(path);
        return matcher.matches();
    }

    private String getFileName(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/item/recognizer/processors/LogicalArtifactProcessor.getFileName must not be null");
        }
        return FileUtils.getName((File)new File(path));
    }

    private ChangedItem createChangedItem(@NotNull ChangedFile changedFile) {
        if (changedFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/item/recognizer/processors/LogicalArtifactProcessor.createChangedItem must not be null");
        }
        return new ChangedItem(changedFile.getChangeAction(), changedFile.getCanonicalPath(), this.logicalArtifactType);
    }
}

