/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.entity;

import java.util.Calendar;
import javax.xml.bind.DatatypeConverter;
import oracle.bpm.lang.Cast;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.artifact.jaxb.MetadataType;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.impl.MdProjectImpl;
import oracle.bpm.metadata.persistence.MdPersistence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployedProject
extends MdProjectImpl<DeployedProject> {
    private String compositeDN;
    private Calendar creationTimestamp;
    private String state;
    private String version;

    protected DeployedProject(@NotNull MdPersistence persistence, @NotNull String location, @Nullable MetadataType metadata) {
        if (persistence == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/entity/DeployedProject.<init> must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/entity/DeployedProject.<init> must not be null");
        }
        super(persistence, location, metadata);
        this.compositeDN = null;
        this.creationTimestamp = null;
        this.state = null;
        this.version = null;
    }

    @Override
    public Calendar getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public void setCreationTimestamp(@NotNull String timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/entity/DeployedProject.setCreationTimestamp must not be null");
        }
        this.creationTimestamp = DatatypeConverter.parseDateTime((String)timestamp);
    }

    public String getCompositeDN() {
        return this.compositeDN;
    }

    public void setCompositeDN(@NotNull String compositeDN) {
        if (compositeDN == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/entity/DeployedProject.setCompositeDN must not be null");
        }
        this.compositeDN = compositeDN;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/entity/DeployedProject.setVersion must not be null");
        }
        this.version = version;
    }

    public String getState() {
        return this.state;
    }

    public void setState(@NotNull String state) {
        if (state == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/entity/DeployedProject.setState must not be null");
        }
        this.state = state;
    }

    @Override
    public LocalRef<DeployedProject> getLocalRef() {
        return new LocalRef<DeployedProject>(this.getName(), this);
    }

    @Override
    public boolean isTemplate() {
        return false;
    }

    @Override
    public boolean isPublicShare() {
        return false;
    }

    public boolean isPlayer() {
        return this.compositeDN.startsWith("Player/");
    }

    @Override
    protected <T extends MdProject> Class<T> getProjectType() {
        return (Class)Cast.force(DeployedProject.class);
    }
}

