/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.MdTreeNode;
import oracle.bpm.metadata.MdTreeNodeVisitor;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.ProjectFolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MdTree {
    private MdTreeNode<ProjectArtifact> root = new MdTreeNode<ProjectFolder>(ProjectFolder.create("/"));

    public void insert(@NotNull ProjectFolder folder) {
        if (folder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/MdTree.insert must not be null");
        }
        LocalRef<ProjectFolder> parentFolder = folder.getParentFolder();
        this.insertElement(folder, parentFolder);
    }

    public void insert(@NotNull MdProject project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/MdTree.insert must not be null");
        }
        LocalRef<ProjectFolder> parentFolder = project.getParentFolder();
        this.insertElement(project, parentFolder);
    }

    public MdTreeNode<ProjectArtifact> getRootNode() {
        return this.root;
    }

    public <T extends ProjectArtifact> Collection<LocalRef<T>> toCollection(final boolean skipFolders) {
        final ArrayList<LocalRef<T>> ret = new ArrayList<LocalRef<T>>();
        MdTreeNode<ProjectArtifact> mdTreeNode = this.getRootNode();
        MdTreeNodeVisitor<ProjectArtifact> visitor = new MdTreeNodeVisitor<ProjectArtifact>(){

            @Override
            public void visit(@NotNull MdTreeNode<ProjectArtifact> node) {
                ProjectArtifact projectArtifact = node.getObject();
                if (projectArtifact.isMdProject()) {
                    LocalRef ref = projectArtifact.getLocalRef();
                    ret.add(ref);
                } else {
                    List<MdTreeNode<ProjectArtifact>> children;
                    if (!skipFolders) {
                        ret.add(projectArtifact.getLocalRef());
                    }
                    if (!(children = node.getChildren()).isEmpty()) {
                        for (MdTreeNode<ProjectArtifact> child : children) {
                            this.visit(child);
                        }
                    }
                }
            }
        };
        visitor.visit(mdTreeNode);
        return ret;
    }

    private void insertElement(@NotNull ProjectArtifact project, @Nullable LocalRef<ProjectFolder> parentFolder) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/MdTree.insertElement must not be null");
        }
        if (parentFolder != null) {
            this.doInsert(this.root, project, parentFolder.get());
        } else {
            this.root.addChild(MdTreeNode.create(project));
        }
    }

    private MdTreeNode<ProjectArtifact> doInsert(@NotNull MdTreeNode<ProjectArtifact> startNode, @NotNull ProjectArtifact projectArtifact, @NotNull ProjectFolder parentFolder) {
        MdTreeNode<ProjectArtifact> newNode;
        if (startNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/MdTree.doInsert must not be null");
        }
        if (projectArtifact == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/MdTree.doInsert must not be null");
        }
        if (parentFolder == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/MdTree.doInsert must not be null");
        }
        MdTreeNode<ProjectArtifact> mdTreeNode = startNode.find(parentFolder);
        if (mdTreeNode != null) {
            newNode = mdTreeNode.find(projectArtifact);
            if (newNode == null) {
                newNode = MdTreeNode.create(projectArtifact);
                mdTreeNode.addChild(newNode);
            }
        } else {
            LocalRef<ProjectFolder> localRef = parentFolder.getParentFolder();
            if (localRef != null) {
                MdTreeNode<ProjectArtifact> node = this.doInsert(startNode, parentFolder, localRef.get());
                newNode = node.find(projectArtifact);
                if (newNode == null) {
                    MdTreeNode<ProjectArtifact> mdTreeNode1 = MdTreeNode.create(projectArtifact);
                    node.addChild(mdTreeNode1);
                    newNode = mdTreeNode1;
                }
            } else {
                newNode = startNode.find(projectArtifact);
                if (newNode == null) {
                    newNode = MdTreeNode.create(projectArtifact);
                    startNode.addChild(newNode);
                }
            }
        }
        return newNode;
    }
}

