/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io.fs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.io.fs.MdsProjectRepository;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.project.io.fs.FileProjectWriter;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import org.jetbrains.annotations.NotNull;

public class MdsProjectWriter
extends FileProjectWriter {
    private final Map<String, ProjectObject> createdProjectObjectCache;
    private final Map<String, ProjectObject> deletedProjectObjectCache;

    public MdsProjectWriter(@NotNull MdsProjectRepository repository, @NotNull Project project, @NotNull ProjectFileSystem fileSystem) {
        if (repository == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MdsProjectWriter.<init> must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/MdsProjectWriter.<init> must not be null");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/io/fs/MdsProjectWriter.<init> must not be null");
        }
        super((ProjectRepository)repository, project, fileSystem);
        this.createdProjectObjectCache = new ConcurrentHashMap<String, ProjectObject>();
        this.deletedProjectObjectCache = new ConcurrentHashMap<String, ProjectObject>();
    }

    public void write(ProjectObject ... object) throws ProjectException {
        for (ProjectObject projectObject : object) {
            this.createdProjectObjectCache.put(this.getKey(projectObject), projectObject);
            this.deletedProjectObjectCache.remove(this.getKey(projectObject));
        }
    }

    public void delete(ProjectObject ... object) throws ProjectException {
        for (ProjectObject projectObject : object) {
            if (this.createdProjectObjectCache.containsKey(this.getKey(projectObject))) {
                this.createdProjectObjectCache.remove(this.getKey(projectObject));
                continue;
            }
            this.deletedProjectObjectCache.put(this.getKey(projectObject), projectObject);
        }
    }

    public void write(ProjectObject object, OutputStream outputStream) throws IOException, ProjectException {
        super.write(object, outputStream);
    }

    public void flushChanges() throws ProjectException {
        for (ProjectObject projectObject : this.deletedProjectObjectCache.values()) {
            super.delete(new ProjectObject[]{projectObject});
        }
        for (ProjectObject projectObject : this.createdProjectObjectCache.values()) {
            super.write(new ProjectObject[]{projectObject});
        }
        this.cleanEvents();
    }

    public void cleanEvents() {
        this.createdProjectObjectCache.clear();
        this.deletedProjectObjectCache.clear();
    }

    protected void postObjectAdded(ProjectObject object) {
        if (object instanceof Adaptable && ((Adaptable)object).as(VFile.class) == null) {
            this.createdProjectObjectCache.put(this.getKey(object), object);
            this.deletedProjectObjectCache.remove(this.getKey(object));
        }
    }

    protected void postObjectRemoved(ProjectObject object) {
        if (this.createdProjectObjectCache.containsKey(this.getKey(object))) {
            this.createdProjectObjectCache.remove(this.getKey(object));
        } else {
            this.deletedProjectObjectCache.put(this.getKey(object), object);
        }
    }

    private String getKey(ProjectObject projectObject) {
        if (projectObject instanceof Process || projectObject instanceof FolderContainer) {
            return projectObject.getPath().toString();
        }
        return projectObject.getId();
    }
}

