/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io.fs;

import java.io.IOException;
import oracle.bpm.extensionpoint.metadata.ProjectRepositoryMetadata;
import oracle.bpm.io.fs.CopyOnWriteFS;
import oracle.bpm.io.fs.MdsProjectRepository;
import oracle.bpm.io.fs.MemoryVFileSystem;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.mds.MdsFileSystem;
import oracle.bpm.metadata.artifact.jaxb.CowFilesystem;
import oracle.bpm.metadata.artifact.jaxb.Filesystem;
import oracle.bpm.metadata.artifact.jaxb.ProjectType;
import oracle.bpm.metadata.impl.MetadataArtifactHelper;
import oracle.bpm.project.io.fs.FileProjectLoader;
import oracle.bpm.project.io.fs.FileProjectWriter;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.mds.core.MDSInstance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ProjectRepositoryMetadata(type="mds")
public class MdsDraftProjectRepository
extends MdsProjectRepository {
    public MdsDraftProjectRepository(@NotNull MDSInstance instance, @NotNull String rootPath) {
        if (instance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MdsDraftProjectRepository.<init> must not be null");
        }
        if (rootPath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/MdsDraftProjectRepository.<init> must not be null");
        }
        super(instance, rootPath);
    }

    @Override
    protected ProjectLoader createLoader(@NotNull Project project, @NotNull ProjectFileSystem fileSystem) throws ProjectException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MdsDraftProjectRepository.createLoader must not be null");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/MdsDraftProjectRepository.createLoader must not be null");
        }
        return new FileProjectLoader((ProjectRepository)this, project, fileSystem);
    }

    @Override
    protected ProjectWriter createWriter(@NotNull Project project, @NotNull ProjectFileSystem fileSystem) throws ProjectException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MdsDraftProjectRepository.createWriter must not be null");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/MdsDraftProjectRepository.createWriter must not be null");
        }
        return new FileProjectWriter((ProjectRepository)this, project, fileSystem);
    }

    @Override
    protected VFileSystem createVFileSystem(@NotNull MDSInstance mdsInstance, @NotNull String mountPoint, @Nullable String mdsLabel) throws IOException {
        if (mdsInstance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MdsDraftProjectRepository.createVFileSystem must not be null");
        }
        if (mountPoint == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/MdsDraftProjectRepository.createVFileSystem must not be null");
        }
        String publicSharedLocation = MetadataArtifactHelper.getRelativePathFrom(ProjectType.PUBLIC_SHARED) + "/";
        MdsFileSystem readPublicSharedFS = new MdsFileSystem(mdsInstance, publicSharedLocation + mountPoint, mdsLabel);
        MdsFileSystem readDraftFS = new MdsFileSystem(mdsInstance, mountPoint, mdsLabel);
        return new CopyOnWriteFS((VFileSystem)new CopyOnWriteFS((VFileSystem)readPublicSharedFS, (VFileSystem)readDraftFS), (VFileSystem)new MemoryVFileSystem());
    }

    @Override
    protected void flushProjectWriterChanges(@NotNull Project project) throws ProjectException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MdsDraftProjectRepository.flushProjectWriterChanges must not be null");
        }
    }

    @Override
    protected VFileSystem convertToVFileSystem(@NotNull MDSInstance mdsInstance, @NotNull Filesystem filesystem, @Nullable String mdsLabel) throws IOException {
        if (mdsInstance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MdsDraftProjectRepository.convertToVFileSystem must not be null");
        }
        if (filesystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/MdsDraftProjectRepository.convertToVFileSystem must not be null");
        }
        CowFilesystem cowFilesystem = filesystem.getCowFilesystem();
        MdsFileSystem readPublicShared = new MdsFileSystem(mdsInstance, cowFilesystem.getRead().getSimpleFilesystem(), mdsLabel);
        MdsFileSystem readDraft = new MdsFileSystem(mdsInstance, cowFilesystem.getWrite().getSimpleFilesystem(), mdsLabel);
        return new CopyOnWriteFS((VFileSystem)new CopyOnWriteFS((VFileSystem)readPublicShared, (VFileSystem)readDraft), (VFileSystem)new MemoryVFileSystem());
    }
}

