/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpeltxn.validation;

import java.util.Set;
import oracle.bpa.common.context.BpaContext;
import oracle.bpm.bpa.bpmn.util.BoundaryFinder;
import oracle.bpm.fusion.builder.BuildProblems;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.compile.CheckOptions;
import oracle.bpm.project.compile.process.ProcessChecker;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.exception.ModelException;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.ExclusiveGateway;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.GatewayDirection;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SendTask;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeUtils;
import oracle.ide.Context;

public class BpmnBpelProcessChecker
extends ProcessChecker {
    public BpmnBpelProcessChecker(Process content) {
        super(content, new CheckOptions());
    }

    public BpmnBpelProcessChecker(Process content, CheckOptions options) {
        super(content, options);
        assert (options != null) : "Process Checker options cannot be null";
    }

    public static void main(String[] args) throws Exception {
        ProcessContent testProcess = new ProcessContent(null, (ComponentCatalog)TypeUtils.getDefaultCatalog());
        testProcess.setId("TestProcess");
        Lane lane = ModelUtils.findOrCreateAutomaticLane((Process)testProcess);
        lane.setSize(450);
        testProcess.addChild((ProjectObject)lane);
        StartEvent stEvent = testProcess.createStartEvent(EventTriggerType.MESSAGE);
        stEvent.setId("startEvent");
        stEvent.setOperationName("initiate");
        testProcess.addChild((ProjectObject)stEvent);
        ExclusiveGateway switchOpen = testProcess.createExclusiveGateway();
        switchOpen.setId("switchOpen");
        switchOpen.setDirection(GatewayDirection.DIVERGING);
        testProcess.addChild((ProjectObject)switchOpen);
        SequenceFlow seqFlow1 = testProcess.createSequenceFlow((FlowNode)stEvent, (FlowNode)switchOpen);
        testProcess.addChild((ProjectObject)seqFlow1);
        Activity sendActivity1 = testProcess.createActivity();
        SendTask sendTask1 = sendActivity1.toSendTask();
        sendTask1.setId("ActivityBranch1");
        sendTask1.setOperationName("initiateOp1");
        testProcess.addChild((ProjectObject)sendTask1);
        SequenceFlow sequenceFlow2 = testProcess.createSequenceFlow((FlowNode)switchOpen, (FlowNode)sendActivity1);
        testProcess.addChild((ProjectObject)sequenceFlow2);
        Activity sendActivity2 = testProcess.createActivity();
        SendTask sendTask2 = sendActivity2.toSendTask();
        sendTask2.setId("ActivityBranch2");
        sendTask2.setOperationName("initiateOp2");
        testProcess.addChild((ProjectObject)sendTask2);
        SequenceFlow sequenceFlow3 = testProcess.createSequenceFlow((FlowNode)switchOpen, (FlowNode)sendActivity2);
        testProcess.addChild((ProjectObject)sequenceFlow3);
        ExclusiveGateway switchClose = testProcess.createExclusiveGateway();
        switchClose.setId("switchClose");
        switchClose.setDirection(GatewayDirection.CONVERGING);
        testProcess.addChild((ProjectObject)switchClose);
        SequenceFlow sequenceFlow4 = testProcess.createSequenceFlow((FlowNode)sendActivity1, (FlowNode)switchClose);
        testProcess.addChild((ProjectObject)sequenceFlow4);
        SequenceFlow sequenceFlow5 = testProcess.createSequenceFlow((FlowNode)sendActivity2, (FlowNode)switchClose);
        testProcess.addChild((ProjectObject)sequenceFlow5);
        EndEvent endEvent = testProcess.createEndEvent(EventTriggerType.MESSAGE);
        endEvent.setId("endEvent");
        endEvent.setOperationName("callback");
        testProcess.addChild((ProjectObject)endEvent);
        SequenceFlow sequenceFlow6 = testProcess.createSequenceFlow((FlowNode)switchClose, (FlowNode)endEvent);
        testProcess.addChild((ProjectObject)sequenceFlow6);
        SequenceFlow sequenceFlow7 = testProcess.createSequenceFlow((FlowNode)sendActivity1, (FlowNode)sendActivity2);
        testProcess.addChild((ProjectObject)sequenceFlow7);
        BpmnBpelProcessChecker checker = new BpmnBpelProcessChecker((Process)testProcess, new CheckOptions());
        ProjectMessageListener listener = new ProjectMessageListener(){

            public void reportError(ProjectObject object, ProjectException exception) {
                System.out.println("Error : " + object.getId() + exception.getMessage());
            }

            public void reportWarning(ProjectObject object, ProjectException exception) {
                System.out.println("Warning : " + object.getId() + exception.getMessage());
            }
        };
        checker.setListener(listener);
        checker.validateProcess();
    }

    public void validateProcess() throws ProjectException {
        super.check();
        BoundaryFinder boundaryFinder = new BoundaryFinder(new BpaContext());
        try {
            boundaryFinder.parse((NodeContainer)this.getProcessContent());
        }
        catch (Exception exc) {
            // empty catch block
        }
        Set<FlowNode> crossEdgeNodes = boundaryFinder.getCrossEdgeNodes();
        for (FlowNode node : crossEdgeNodes) {
            this.reportError((ProjectObject)node, new ModelException((ProjectObject)node));
        }
    }

    public boolean checkBpmnToBpel(Context context) throws ProjectException {
        BpmnBpelValidationListener listener = new BpmnBpelValidationListener(this.getProcessContent().getProject());
        this.setListener(listener);
        this.validateProcess();
        boolean isValid = false;
        if (listener.getProblems().getErrors().isEmpty()) {
            isValid = true;
        }
        listener.flushErrors();
        return isValid;
    }

    public static class BpmnBpelValidationListener
    implements ProjectMessageListener {
        private BuildProblems problems;

        public BpmnBpelValidationListener(Project project) {
            this.problems = new BuildProblems(project);
        }

        public void reportError(ProjectObject object, ProjectException exception) {
            System.out.println("Error : " + object.getId() + exception.getMessage());
            this.problems.onError(exception);
        }

        public void reportWarning(ProjectObject object, ProjectException exception) {
            System.out.println("Warning : " + object.getId() + exception.getMessage());
            this.problems.onWarning(exception);
        }

        public void flushErrors() {
            this.problems.flushErrors();
        }

        public BuildProblems getProblems() {
            return this.problems;
        }
    }
}

