/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpa.writer;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.bpa.bpmn.model.Activity;
import oracle.bpa.bpmn.model.Constants;
import oracle.bpa.bpmn.model.ICollection;
import oracle.bpa.bpmn.model.Node;
import oracle.bpa.bpmn.model.SubProcess;
import oracle.bpa.bpmn.util.Decoration;
import oracle.bpa.common.context.BpaContext;
import oracle.bpa.common.exception.BpaException;
import oracle.bpa.common.exception.BpaNoBizException;
import oracle.bpa.common.log.BpaDiagnosticService;
import oracle.bpa.export.bpmn.BpelExportFactory;
import oracle.bpa.export.bpmn.iface.IBpelExport;
import oracle.bpa.export.bpmn.iface.IBpelProcessExport;
import oracle.bpa.writer.AbstractWriter;
import oracle.bpa.writer.WriterUtil;
import oracle.bpm.bpa.bpmn.util.BPMNGraph;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.Literals;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.ActivityImpl;
import oracle.bpm.project.catalog.composite.CompositeAccessorFactory;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.interfaces.ProcessWsdlWriter;
import oracle.bpm.project.io.serializers.model.ProcessModelFormat;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.algorithms.KoreanLayoutAlgorithm;
import oracle.bpm.project.model.catalog.BusinessRule;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import oracle.bpm.project.model.processes.conversation.ServiceCallConversationDefinition;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.model.processes.conversational.ServiceCallConversationalDefinition;
import oracle.bpm.project.model.processes.notification.IMNotificationDefinition;
import oracle.bpm.project.model.processes.notification.MailNotificationAttachment;
import oracle.bpm.project.model.processes.notification.MailNotificationDefinition;
import oracle.bpm.project.model.processes.notification.NotificationDefinition;
import oracle.bpm.project.model.processes.notification.NotificationTask;
import oracle.bpm.project.model.processes.notification.NotificationType;
import oracle.bpm.project.model.processes.notification.SMSNotificationDefinition;
import oracle.bpm.project.model.processes.notification.UserNotificationDefinition;
import oracle.bpm.project.model.processes.notification.VoiceNotificationDefinition;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.process.notification.MailNotificationAttachmentImpl;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.Identifier;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class BPMNWriter
extends AbstractWriter {
    private Map<String, Node> bpaNodesCache = new HashMap<String, Node>();
    private File bpmnProjectFolder;
    private static Map<String, Document> additionalDocumentsMap = new HashMap<String, Document>();

    public BPMNWriter(Map<String, Object> argumentsMap) {
        this();
        this.setBpmnProcess((NodeContainer)argumentsMap.get("bpmnProcess"));
        this.setBpaProcess((ICollection)argumentsMap.get("bpaProcess"));
        this.setSubProcessExport((Boolean)argumentsMap.get("isSubProcessExport"));
        this.setContext((BpaContext)argumentsMap.get("bpaContext"));
        this.setArgumentsMap(argumentsMap);
        this.setGraph(new BPMNGraph(this.getBpaProcess(), this.getBpmnProcess()));
        this.getGraph().parse();
        this.populateBpaNodeCache();
        this.log(BpaDiagnosticService.INFORMATION, "Creating object of - " + this.getWriterName());
    }

    public BPMNWriter(boolean isSubProcessExport, NodeContainer bpmnProcess, ICollection bpaProcess, BpaContext context) {
        this();
        this.setBpmnProcess(bpmnProcess);
        this.setBpaProcess(bpaProcess);
        this.setSubProcessExport(isSubProcessExport);
        this.setContext(context);
        this.setGraph(new BPMNGraph(bpaProcess, bpmnProcess));
        this.getGraph().parse();
        this.populateBpaNodeCache();
        this.log(BpaDiagnosticService.INFORMATION, "Creating object of - " + this.getWriterName());
    }

    BPMNWriter() {
    }

    public Object parse() throws BpaException, BpaNoBizException {
        try {
            this.writeDataAndServiceRefs();
            this.setDecoration(new Decoration());
            this.setExporter(BpelExportFactory.getBpelExportInstance());
            if (Logger.getLogger("com.idsscheer.aris.server.BpelExport") != null) {
                this.getExporter().exportStarting(this.getBpaProcess().getName() + "_composite", (Document)this.getDecoration().getDocument(), AbstractWriter.getLogger(), Logger.getLogger("com.idsscheer.aris.server.BpelExport").getLevel(), this.getContext());
            } else {
                this.getExporter().exportStarting(this.getBpaProcess().getName() + "_composite", (Document)this.getDecoration().getDocument(), AbstractWriter.getLogger(), BpaDiagnosticService.DEBUG, this.getContext());
            }
            ((oracle.bpa.bpmn.model.Process)this.getBpaProcess()).put((Object)Constants.ExtensionAttributes.AT_MAIN_PROCESS, (Object)true);
            this.setProcessExporter(this.getExporter().getProcessExport((AbstractWriter)this, (Document)this.getDecoration().getDocument()));
            StartEvent start = ModelUtils.getStartEvent((NodeContainer)this.getBpmnProcess());
            XMLElement processXml = (XMLElement)this.getDecoration().getDocument().createElement("process");
            processXml.setAttribute(AbstractWriter.Name, this.getBpmnProcess().getName());
            this.getDecoration().getDocument().appendChild((org.w3c.dom.Node)processXml);
            Element processAnnotations = this.getProcessExporter().processExporting().getXMLNotation();
            processXml.appendChild((org.w3c.dom.Node)processAnnotations);
            this.generate((FlowNode)start, processXml, false);
            this.setProcessAction(this.getProcessExporter().processExported());
            WriterUtil.populateXML((AbstractWriter)this, (XMLElement)processXml);
            this.setAction(this.getExporter().exportFinished());
            Map additionalDocsMap = this.getAction().getAdditionalDocuments();
            this.identifyTaskFiles(additionalDocsMap);
            additionalDocumentsMap.putAll(additionalDocsMap);
        }
        catch (BpaException bpae) {
            throw bpae;
        }
        catch (BpaNoBizException bpane) {
            throw bpane;
        }
        catch (Exception e) {
            throw new BpaNoBizException(5, (Throwable)e);
        }
        return this.getDecoration();
    }

    public Object parseIndependentSubProcess(XMLDocument document, IBpelExport exporter, IBpelProcessExport processExporter) throws BpaException, BpaNoBizException {
        try {
            this.writeDataAndServiceRefs();
            ((oracle.bpa.bpmn.model.Process)this.getBpaProcess()).put((Object)Constants.ExtensionAttributes.AT_MAIN_PROCESS, (Object)false);
            this.setExporter(exporter);
            this.setDecoration(new Decoration());
            this.setProcessExporter(this.getExporter().getProcessExport((AbstractWriter)this, (Document)this.getDecoration().getDocument()));
            StartEvent start = ModelUtils.getStartEvent((NodeContainer)this.getBpmnProcess());
            XMLElement processXml = (XMLElement)this.getDecoration().getDocument().createElement("process");
            processXml.setAttribute(AbstractWriter.Name, this.getBpmnProcess().getName());
            this.getDecoration().getDocument().appendChild((org.w3c.dom.Node)processXml);
            Element processAnnotations = this.getProcessExporter().processExporting().getXMLNotation();
            processXml.appendChild((org.w3c.dom.Node)processAnnotations);
            this.generate((FlowNode)start, processXml, false);
            this.setProcessAction(this.getProcessExporter().processExported());
            WriterUtil.populateXML((AbstractWriter)this, (XMLElement)processXml);
            this.setAction(this.getExporter().exportFinished());
            Map additionalDocsMap = this.getAction().getAdditionalDocuments();
            this.identifyTaskFiles(additionalDocsMap);
            additionalDocumentsMap.putAll(additionalDocsMap);
        }
        catch (BpaException bpae) {
            throw bpae;
        }
        catch (BpaNoBizException bpane) {
            throw bpane;
        }
        catch (Exception e) {
            throw new BpaNoBizException(5, (Throwable)e);
        }
        return this.getDecoration();
    }

    public Object parse(XMLDocument document, IBpelExport exporter, IBpelProcessExport processExporter) throws BpaException, BpaNoBizException {
        XMLElement returnVal = null;
        try {
            this.setExporter(exporter);
            this.setProcessExporter(processExporter);
            this.setDecoration(new Decoration(document));
            if (this.getBpaProcess() instanceof SubProcess) {
                if (((SubProcess)this.getBpaProcess()).getSubProcessType() == Constants.SubProcessType.Embedded) {
                    XMLElement scope = (XMLElement)this.getDecoration().getDocument().createElement("scope");
                    scope.setAttribute(Name, this.getBpaProcess().getName());
                    scope.appendChild((org.w3c.dom.Node)this.getProcessExporter().elementExporting((Node)((Activity)this.getBpaProcess()), "Scope").getXMLNotation());
                    returnVal = scope;
                    this.setGraph(new BPMNGraph(this.getBpaProcess(), this.getBpmnProcess()));
                    this.getGraph().parse();
                    if (this.getBpaProcess().getObjects().size() > 0) {
                        this.getProcessExporter().setProcessContext(this.getGraph());
                        Node startNode = this.getGraph().getStart();
                        if (startNode == null) {
                            throw new BpaException(19006, this.getContext(), "Subprocess " + this.getBpaProcess().getName() + " doesn't contain start node");
                        }
                        FlowNode start = this.getBpmnProcess().findNode(WriterUtil.convertToValidBpmId((String)this.getGraph().getStart().getObjectId()));
                        this.log(BpaDiagnosticService.INFORMATION, "start node is : " + start.getName());
                        this.generate(start, scope, false);
                    }
                } else {
                    ((SubProcess)this.getBpaProcess()).setAttr(Constants.Attribute.TaskType, (Object)Constants.TaskType.Send);
                    returnVal = (XMLElement)processExporter.elementExporting((Node)((SubProcess)this.getBpaProcess()), "Invoke").getXMLNotation();
                    this.setBpaProcess((ICollection)((SubProcess)this.getBpaProcess()).getProcessRef());
                    if (this.isSubProcessExport() && this.getBpaProcess().getObjects().size() > 0) {
                        this.writeDataAndServiceRefs();
                        ((oracle.bpa.bpmn.model.Process)this.getBpaProcess()).put((Object)Constants.ExtensionAttributes.AT_MAIN_PROCESS, (Object)false);
                        this.setProcessExporter(exporter.getProcessExport(this.getBpaProcess(), (Document)this.getDecoration().getDocument()));
                        if (this.getProcessExporter() == null) {
                            return returnVal;
                        }
                        FlowNode start = this.getBpmnProcess().findNode(WriterUtil.convertToValidBpmId((String)this.getGraph().getStart().getObjectId()));
                        this.log(BpaDiagnosticService.INFORMATION, "start node is : " + start.getName());
                        XMLElement processXml = (XMLElement)this.getDecoration().getDocument().createElement("process");
                        processXml.setAttribute(Name, this.getBpaProcess().getName());
                        this.getDecoration().getDocument().appendChild((org.w3c.dom.Node)processXml);
                        Element processAnnotations = this.getProcessExporter().processExporting().getXMLNotation();
                        processXml.appendChild((org.w3c.dom.Node)processAnnotations);
                        this.generate(start, processXml, false);
                        this.setProcessAction(this.getProcessExporter().processExported());
                        additionalDocumentsMap.putAll(this.getAction().getAdditionalDocuments());
                        WriterUtil.populateXML((AbstractWriter)this, (XMLElement)processXml);
                    }
                }
            } else {
                this.writeDataAndServiceRefs();
                ((oracle.bpa.bpmn.model.Process)this.getBpaProcess()).put((Object)Constants.ExtensionAttributes.AT_MAIN_PROCESS, (Object)false);
                this.setProcessExporter(exporter.getProcessExport(this.getBpaProcess(), (Document)this.getDecoration().getDocument()));
                if (this.getProcessExporter() == null) {
                    return returnVal;
                }
                FlowNode start = this.getBpmnProcess().findNode(WriterUtil.convertToValidBpmId((String)this.getGraph().getStart().getObjectId()));
                this.log(BpaDiagnosticService.INFORMATION, "start node is : " + start.getName());
                XMLElement processXml = (XMLElement)this.getDecoration().getDocument().createElement("process");
                processXml.setAttribute(Name, this.getBpaProcess().getName());
                this.getDecoration().getDocument().appendChild((org.w3c.dom.Node)processXml);
                Element processAnnotations = this.getProcessExporter().processExporting().getXMLNotation();
                processXml.appendChild((org.w3c.dom.Node)processAnnotations);
                this.generate(start, processXml, false);
                this.setProcessAction(this.getProcessExporter().processExported());
                WriterUtil.populateXML((AbstractWriter)this, (XMLElement)processXml);
            }
        }
        catch (BpaException bpae) {
            throw bpae;
        }
        catch (BpaNoBizException bpane) {
            throw bpane;
        }
        catch (Exception e) {
            throw new BpaNoBizException(5, (Throwable)e);
        }
        return returnVal;
    }

    public Node getBpaNodeForBpmActivity(String objectId) throws BpaNoBizException {
        if (!this.bpaNodesCache.containsKey(objectId)) {
            throw new BpaNoBizException(5, "No Bpa node found in cache for BPM flow node - " + objectId);
        }
        return this.bpaNodesCache.get(objectId);
    }

    public void writeDataAndServiceRefs() throws BpaNoBizException {
        List dataServiceRefs = ((oracle.bpa.bpmn.model.Process)this.getBpaProcess()).getDataAndServiceRefs();
        if (dataServiceRefs != null) {
            ListIterator it = dataServiceRefs.listIterator();
            while (it.hasNext()) {
                byte[] docRef = (byte[])it.next();
                ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(docRef));
                ZipEntry en = null;
                try {
                    while ((en = zis.getNextEntry()) != null) {
                        File serviceDataFile = null;
                        File XSDFolderFile = null;
                        if (en.getName().contains(".xsd")) {
                            File xsdFolder = new File(this.getContext().getOutFolder(), "xsd");
                            if (!xsdFolder.isDirectory()) {
                                xsdFolder.mkdir();
                            }
                            XSDFolderFile = new File(xsdFolder.getAbsolutePath(), en.getName());
                        }
                        serviceDataFile = new File(this.getContext().getOutFolder(), en.getName());
                        BufferedOutputStream bStream = new BufferedOutputStream(new FileOutputStream(serviceDataFile));
                        BufferedOutputStream xsdFolderStream = null;
                        if (XSDFolderFile != null) {
                            xsdFolderStream = new BufferedOutputStream(new FileOutputStream(XSDFolderFile));
                        }
                        int c = zis.read();
                        while (c != -1) {
                            bStream.write(c);
                            if (xsdFolderStream != null) {
                                xsdFolderStream.write(c);
                            }
                            c = zis.read();
                        }
                        bStream.close();
                        if (xsdFolderStream != null) {
                            xsdFolderStream.close();
                        }
                        zis.closeEntry();
                    }
                    zis.close();
                }
                catch (Exception exc) {
                    throw new BpaNoBizException(5, (Throwable)exc);
                }
            }
        }
    }

    public void save() throws BpaNoBizException {
        try {
            WriterUtil.saveAdditionalDocuments(additionalDocumentsMap, (ZipOutputStream)this.getZipStream());
            this.bpmnProjectFolder = new File(this.getContext().getOutFolder());
            this.unzipToFolder();
            this.copyAnnotations();
            ProcessWsdlWriter.write((Process)((Process)this.getBpmnProcess()));
            this.syncCatalogObjects(this.getBpaProcess(), this.getBpmnProcess());
            KoreanLayoutAlgorithm.layoutModel((NodeContainer)this.getBpmnProcess(), (int)1, (boolean)false);
            this.generateBpmn(this.bpmnProjectFolder);
            ProcessWsdlWriter.write((Process)((Process)this.getBpmnProcess()));
            CompositeAccessorFactory.createCompositeUpdater((Process)((Process)this.getBpmnProcess())).updateComposite();
            Project project = ((Process)this.getBpmnProcess()).getProject();
            project.getWriter().write(new ProjectObject[]{this.getBpmnProcess()});
            ByteArrayOutputStream byteOutStream = this.writeProjectFolderToZip();
            this.setByteArrayOutputStream(byteOutStream);
            additionalDocumentsMap.clear();
        }
        catch (Exception e) {
            throw new BpaNoBizException(5, (Throwable)e);
        }
    }

    public XMLElement handleSubProcess(Node node) throws BpaException, BpaNoBizException {
        FlowNode flowNode = this.getBpmnProcess().findNode(WriterUtil.convertToValidBpmId((String)node.getObjectId()));
        if (((SubProcess)node).getSubProcessType().equals((Object)Constants.SubProcessType.Independent)) {
            return this.handleIndependentSubProcess(node, flowNode);
        }
        Subprocess bpmSubProcess = (Subprocess)flowNode;
        SubProcess bpaSubProcess = (SubProcess)node;
        BPMNWriter bpmnWriter = new BPMNWriter(this.isSubProcessExport(), (NodeContainer)bpmSubProcess, (ICollection)bpaSubProcess, this.getContext());
        XMLElement element = (XMLElement)bpmnWriter.parse(this.getDecoration().getDocument(), this.getExporter(), this.getProcessExporter());
        this.getProcessExporter().setProcessContext(this.getGraph());
        return element;
    }

    public void unzipToFolder() throws BpaNoBizException {
        byte[] byteArray = this.getByteArrayOutputStream().toByteArray();
        ZipInputStream inStream = new ZipInputStream(new ByteArrayInputStream(byteArray));
        try {
            ZipEntry entry;
            while ((entry = inStream.getNextEntry()) != null) {
                int count;
                BufferedOutputStream outStream;
                if (entry.getName().contains(File.separator)) {
                    String fileEntry;
                    String dirEntry = entry.getName().substring(0, entry.getName().indexOf(File.separator));
                    File dir = new File(this.bpmnProjectFolder.getPath(), dirEntry);
                    if (!dir.exists()) {
                        dir.mkdir();
                    }
                    if ((fileEntry = entry.getName().substring(entry.getName().indexOf(File.separator) + 1, entry.getName().length())).contains(File.separator)) {
                        dirEntry = fileEntry.substring(0, fileEntry.indexOf(File.separator));
                        if (!(dir = new File(dir.getPath(), dirEntry)).exists()) {
                            dir.mkdir();
                        }
                        if ((fileEntry = fileEntry.substring(fileEntry.indexOf(File.separator) + 1, fileEntry.length())).contains(".rules")) {
                            this.getRulesFiles().add(fileEntry);
                        }
                    }
                    if (entry.getName().contains(this.getBpmnProcess().getName() + ".xsd")) continue;
                    outStream = new BufferedOutputStream(new FileOutputStream(new File(dir.getAbsolutePath(), fileEntry)));
                } else {
                    String entryName = entry.getName();
                    if (entryName.contains(this.getBpmnProcess().getName() + ".xsd") || entryName.equals(this.getBpmnProcess().getName() + ".wsdl")) continue;
                    outStream = new BufferedOutputStream(new FileOutputStream(this.bpmnProjectFolder.getPath() + File.separator + entry.getName()));
                }
                while ((count = inStream.read()) != -1) {
                    outStream.write(count);
                }
                outStream.flush();
                outStream.close();
            }
            inStream.close();
        }
        catch (Exception e) {
            throw new BpaNoBizException(5, (Throwable)e);
        }
    }

    public void generateJdevProject() throws BpaNoBizException {
        try {
            int data;
            int soaLength = (Integer)this.getArgumentsMap().get("soalength");
            byte[] bytes = (byte[])this.getArgumentsMap().get("bytes");
            int bpmLength = (Integer)this.getArgumentsMap().get("bpmLength");
            File fileObj = (File)this.getArgumentsMap().get("fileObj");
            String fileName = (String)this.getArgumentsMap().get("fileName");
            ByteArrayInputStream byte_stream = new ByteArrayInputStream(bytes, soaLength, bpmLength);
            File file = new File(fileObj, fileName);
            FileOutputStream fos = new FileOutputStream(file);
            while ((data = byte_stream.read()) != -1) {
                fos.write(data);
            }
            byte_stream.close();
            fos.close();
        }
        catch (Exception e) {
            throw new BpaNoBizException(5, (Throwable)e);
        }
    }

    private XMLElement handleIndependentSubProcess(Node node, FlowNode flowNode) throws BpaException, BpaNoBizException {
        Process subProcessNodeContainer = ((ActivityImpl)flowNode).getCalledElement();
        oracle.bpa.bpmn.model.Process subProcessICollection = ((SubProcess)node).getProcessRef();
        BPMNWriter bpmnWriter = new BPMNWriter(this.isSubProcessExport(), (NodeContainer)subProcessNodeContainer, (ICollection)subProcessICollection, this.getContext());
        bpmnWriter.parseIndependentSubProcess(this.getDecoration().getDocument(), this.getExporter(), this.getProcessExporter());
        this.getTaskFiles().addAll(bpmnWriter.getTaskFiles());
        return null;
    }

    private void populateBpaNodeCache() {
        try {
            if (this.getBpaProcess() == null) {
                throw new Exception("BPA meta model does not contain activities");
            }
            List bpaProcessNodes = this.getBpaProcess().getObjects();
            for (int count = 0; count < bpaProcessNodes.size(); ++count) {
                Node activityNode = (Node)bpaProcessNodes.get(count);
                this.bpaNodesCache.put(WriterUtil.convertToValidBpmId((String)activityNode.getObjectId()), activityNode);
            }
        }
        catch (Exception e) {
            this.log(BpaDiagnosticService.INFORMATION, e.getMessage());
        }
    }

    private Node generate(FlowNode node, XMLElement container, boolean exclude) throws BpaException, BpaNoBizException {
        Node generatedNode = null;
        Node bpaNode = this.getBpaNodeForBpmActivity(node.getId());
        WriterUtil.transform((Node)bpaNode, (XMLElement)container, (AbstractWriter)this);
        bpaNode.setAttr(Constants.Attribute.Visited, (Object)true);
        Sequence outgoingSequenceFlow = node.getOutgoingSequenceFlows();
        Object[] sequenceArray = outgoingSequenceFlow.toArray();
        int totalOutGoingFlowNodes = sequenceArray.length;
        if (totalOutGoingFlowNodes == 0) {
            return generatedNode;
        }
        if (totalOutGoingFlowNodes == 1 && !((Boolean)bpaNode.getAttr(Constants.Attribute.Visited)).booleanValue()) {
            generatedNode = this.generate(((SequenceFlow)outgoingSequenceFlow.iterator().next()).getTarget(), container, exclude);
        }
        for (SequenceFlow flow : node.getOutgoingSequenceFlows()) {
            FlowNode target = flow.getTarget();
            Node bpaTarget = this.getBpaNodeForBpmActivity(target.getId());
            if (bpaTarget.getAttr(Constants.Attribute.Visited) != null && ((Boolean)bpaTarget.getAttr(Constants.Attribute.Visited)).booleanValue()) continue;
            generatedNode = this.generate(target, container, exclude);
        }
        return generatedNode;
    }

    private void generateBpmn(File bpmProjectFolder) throws BpaNoBizException {
        try {
            FileOutputStream fos = new FileOutputStream(new File(bpmProjectFolder, "processes/" + this.getUnderscoreString(this.getContext().getProjectName()) + ".bpmn"));
            ProcessModelFormat modelFormat = new ProcessModelFormat();
            modelFormat.writeXml((Process)this.getBpmnProcess(), (Writer)new OutputStreamWriter((OutputStream)fos, Literals.DEFAULT_ENCODING));
            fos.close();
            for (FlowNode subProcessFlowNode : this.getBpmnProcess().getFlowNodes()) {
                if (!subProcessFlowNode.getBpmnType().equals((Object)BpmnType.CALL_ACTIVITY)) continue;
                Process calledProcess = ((ActivityImpl)subProcessFlowNode).getCalledElement();
                ProcessWsdlWriter.write((Process)calledProcess);
                FileOutputStream subProcessFOS = new FileOutputStream(new File(bpmProjectFolder, "processes/" + calledProcess.getDefaultLabel() + ".bpmn"));
                modelFormat.writeXml(calledProcess, (Writer)new OutputStreamWriter((OutputStream)subProcessFOS, Literals.DEFAULT_ENCODING));
                subProcessFOS.close();
            }
        }
        catch (Exception e) {
            throw new BpaNoBizException(5, (Throwable)e);
        }
    }

    private void copyAnnotations() {
        for (Node bpelnode : this.getBpaProcess().getObjects()) {
            FlowNode bpmnode = this.getBpmnProcess().findNode(WriterUtil.convertToValidBpmId((String)bpelnode.getObjectId()));
            Map annot = this.getAnnotation(bpelnode);
            if (annot == null) continue;
            for (String key : annot.keySet()) {
                String val = (String)annot.get(key);
                if (key.equals("") || val.equals("")) continue;
                bpmnode.addAnnotation(key, val, true);
            }
        }
        ((Process)this.getBpmnProcess()).addAnnotation("isBPA", "true", true);
    }

    private void syncCatalogObjects(ICollection bpaProcess, NodeContainer bpmnProcess) {
        try {
            if (!this.getBpaProcess().getClass().equals(SubProcess.class)) {
                this.getBpmnProcess().getProject().getComponentCatalog().sync();
                if (!this.getTaskFiles().isEmpty()) {
                    List<String> taskFiles = this.removeDuplicateObjects(this.getTaskFiles());
                    this.getTaskFiles().clear();
                    this.getTaskFiles().addAll(taskFiles);
                    for (int i = 0; i < this.getTaskFiles().size(); ++i) {
                        String taskName = ((String)this.getTaskFiles().get(i)).substring(0, ((String)this.getTaskFiles().get(i)).indexOf("."));
                        String modifiedTaskName = taskName.replace('_', ' ');
                        String typeName = "HumanTasks." + taskName;
                        CatalogObject humanTaskCatObj = this.getBpmnProcess().getProject().findCatalogObject(typeName);
                        if (humanTaskCatObj == null) continue;
                        HumanTask humanTask = humanTaskCatObj.asHumanTask();
                        for (FlowNode processNode : this.getBpmnProcess().getFlowNodes()) {
                            if (processNode.getBpmnType().equals((Object)BpmnType.SUBPROCESS)) {
                                Subprocess subProcess = (Subprocess)processNode.asAnyNode(Subprocess.class);
                                for (FlowNode subProcessFlowNode : subProcess.getFlowNodes()) {
                                    if (!subProcessFlowNode.getBpmnType().equals((Object)BpmnType.USER_TASK) || !subProcessFlowNode.getDefaultLabel().equals(modifiedTaskName)) continue;
                                    ActivityImpl subProcessActivityObj = (ActivityImpl)subProcessFlowNode.asAnyNode(ActivityImpl.class);
                                    subProcessActivityObj.toUserTask().setHumanTask(humanTask);
                                }
                            }
                            if (processNode.getBpmnType().equals((Object)BpmnType.CALL_ACTIVITY)) {
                                ActivityImpl callActivity = (ActivityImpl)processNode;
                                Process calledproc = callActivity.getCalledElement();
                                for (FlowNode callActivityNode : calledproc.getFlowNodes()) {
                                    if (!callActivityNode.getBpmnType().equals((Object)BpmnType.USER_TASK) || !callActivityNode.getDefaultLabel().equals(modifiedTaskName)) continue;
                                    ActivityImpl callActivityObj = (ActivityImpl)callActivityNode;
                                    callActivityObj.toUserTask().setHumanTask(humanTask);
                                }
                            }
                            if (!processNode.getBpmnType().equals((Object)BpmnType.USER_TASK) || !processNode.getDefaultLabel().equals(modifiedTaskName)) continue;
                            UserTask userTaskActivityObj = (UserTask)processNode;
                            userTaskActivityObj.toUserTask().setHumanTask(humanTask);
                        }
                    }
                }
            }
            Iterator bpaNodeItr = bpaProcess.getObjects().iterator();
            while (bpaNodeItr.hasNext()) {
                String repositoryName;
                String serviceXmlString;
                Process bpmProcess = null;
                Node bpaNode = (Node)bpaNodeItr.next();
                FlowNode bpmnFlowNode = bpmnProcess.findNode(WriterUtil.convertToValidBpmId((String)bpaNode.getObjectId()));
                if (bpaNode.getClass().equals(SubProcess.class) && !((SubProcess)bpaNode).getSubProcessType().equals((Object)Constants.SubProcessType.Independent)) {
                    this.syncCatalogObjects((ICollection)((SubProcess)bpaNode), (NodeContainer)bpmnFlowNode);
                }
                if (bpmnFlowNode.getRawClass().equals(NotificationTask.class)) {
                    this.handleNotificationActivity(bpmnFlowNode, bpaNode);
                }
                if ((serviceXmlString = (String)bpaNode.getAttr(Constants.ExtensionAttributes.AT_BPEL_SERVICE)) != null) {
                    String outputDataXmlString;
                    Map<String, String> serviceDetails = this.getServiceDetails(serviceXmlString);
                    ArrayList<String> dataObjectNameList = new ArrayList<String>();
                    String inputDataXmlString = (String)bpaNode.getAttr(Constants.ExtensionAttributes.AT_BPEL_DATA_IN);
                    if (inputDataXmlString != null) {
                        this.getAndAddDataObjectNameToList(dataObjectNameList, inputDataXmlString);
                    }
                    if ((outputDataXmlString = (String)bpaNode.getAttr(Constants.ExtensionAttributes.AT_BPEL_DATA_OUT)) != null) {
                        this.getAndAddDataObjectNameToList(dataObjectNameList, outputDataXmlString);
                    }
                    if (bpaNode.getClass().equals(SubProcess.class)) {
                        FlowNode flowNode = this.getBpmnProcess().findNode(WriterUtil.convertToValidBpmId((String)bpaNode.getObjectId()));
                        if (flowNode.getBpmnType().equals((Object)BpmnType.CALL_ACTIVITY)) {
                            CallActivity callActivityObj = (CallActivity)flowNode.asAnyNode(CallActivity.class);
                            bpmProcess = callActivityObj.getCalledElement();
                        }
                    } else {
                        bpmProcess = (Process)this.getBpmnProcess();
                    }
                    ActivityImpl bpmnActivityNode = (ActivityImpl)bpmnFlowNode;
                    if (bpmnActivityNode.getRawClass().equals(NotificationTask.class)) {
                        this.handleNotificationActivity((FlowNode)bpmnActivityNode, bpaNode);
                    }
                    if (bpmnActivityNode != null && serviceDetails.get("serviceName") != null) {
                        CatalogObject serviceObj;
                        String serviceName = serviceDetails.get("serviceName");
                        serviceName = serviceName.replaceAll(Pattern.quote("+"), "_");
                        String serviceTypeName = "Services.Externals." + serviceName;
                        if (serviceDetails.get("wsdlName") != null && (serviceObj = bpmProcess.getProject().findCatalogObject(serviceTypeName)) != null) {
                            CatalogMember operationObj = serviceObj.findMember(serviceDetails.get("operationName"));
                            Conversation conversationObj = this.getBpmnProcess().createDefaultConversation(ConversationType.SERVICE_CALL);
                            this.getBpmnProcess().addConversation(conversationObj);
                            ServiceCallConversationDefinition conversationDefintionObj = (ServiceCallConversationDefinition)conversationObj.getConversationDefinition().as(ServiceCallConversationDefinition.class);
                            conversationDefintionObj.setService(serviceObj.asServiceObject());
                            Conversational conversationalObj = (Conversational)bpmnActivityNode.asAnyNode(Conversational.class);
                            conversationalObj.setConversation(conversationObj);
                            conversationalObj.setParticipant(serviceObj);
                            ServiceCallConversationalDefinition serviceConversationDefintionObj = (ServiceCallConversationalDefinition)conversationalObj.getConversationalDefinition().as(ServiceCallConversationalDefinition.class);
                            serviceConversationDefintionObj.setOperation(operationObj);
                        }
                        for (int count = 0; count < dataObjectNameList.size(); ++count) {
                            CatalogObject catalogTypeObj;
                            DataObject dataObj;
                            TypeRef typeRefObj;
                            String dataName = (String)dataObjectNameList.get(count);
                            if (dataName == null || (typeRefObj = this.getBpmnProcess().getProject().getComponentCatalog().find(dataName)) == null || (dataObj = bpmProcess.createDeclaration(dataName, (CatalogType)(catalogTypeObj = this.getBpmnProcess().getProject().createCatalogObject(typeRefObj)))) == null) continue;
                            bpmProcess.addChild((ProjectObject)dataObj);
                        }
                    }
                }
                if ((repositoryName = (String)bpaNode.getAttr(Constants.ExtensionAttributes.AT_REPOSITORY)) == null || repositoryName.equals("")) continue;
                String rulesetName = (String)bpaNode.getAttr(Constants.ExtensionAttributes.AT_CATALOG);
                FlowNode bpmnNode = bpmProcess.findNode(WriterUtil.convertToValidBpmId((String)bpaNode.getObjectId()));
                String rulesTypeName = "Rules." + repositoryName;
                CatalogObject businessRuleCatObj = bpmProcess.getProject().findCatalogObject(rulesTypeName);
                BusinessRule businessRule = null;
                if (businessRuleCatObj != null) {
                    businessRule = businessRuleCatObj.asBusinessRule();
                }
                CatalogMember decisionFunction = null;
                if (businessRule != null && rulesetName != null && !rulesetName.equals("")) {
                    decisionFunction = businessRule.findMember(rulesetName);
                }
                ActivityImpl bpmnActivity = (ActivityImpl)bpmnNode.asAnyNode(ActivityImpl.class);
                bpmnActivity.toBusinessRuleTask().setBusinessRule(businessRule);
                if (decisionFunction == null) continue;
                bpmnActivity.setFunction(decisionFunction);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getAndAddDataObjectNameToList(List<String> dataNodeList, String xmlDataString) throws BpaNoBizException {
        String dataObjectName = null;
        DocumentBuilderFactory datadbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder datadb = datadbf.newDocumentBuilder();
            InputSource dataIs = new InputSource();
            dataIs.setCharacterStream(new StringReader(xmlDataString));
            Document datadoc = datadb.parse(dataIs);
            NodeList dataNodeLst = datadoc.getElementsByTagName("data");
            for (int dataNodeCount = 0; dataNodeCount < dataNodeLst.getLength(); ++dataNodeCount) {
                Element data = (Element)dataNodeLst.item(dataNodeCount);
                String xsdName = null;
                String nameSpaceName = null;
                if (data.getElementsByTagName("belongsTo").item(0) != null) {
                    xsdName = data.getElementsByTagName("belongsTo").item(0).getFirstChild().getNodeValue();
                }
                if (data.getElementsByTagName("namespace").item(0) != null) {
                    nameSpaceName = data.getElementsByTagName("namespace").item(0).getFirstChild().getNodeValue();
                }
                if (data.getElementsByTagName("name").item(0) == null) continue;
                dataObjectName = data.getElementsByTagName("name").item(0).getFirstChild().getNodeValue();
                if (xsdName == null || nameSpaceName == null) continue;
                dataNodeList.add(dataObjectName);
            }
        }
        catch (Exception e) {
            throw new BpaNoBizException(5, (Throwable)e);
        }
        return dataObjectName;
    }

    private Map<String, String> getServiceDetails(String serviceXml) throws BpaNoBizException {
        HashMap<String, String> serviceDetails = new HashMap<String, String>();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(serviceXml));
            Document doc = documentBuilder.parse(is);
            Element serviceNode = (Element)doc.getElementsByTagName("service").item(0);
            if (serviceNode.getElementsByTagName("belongsTo").item(0) != null) {
                serviceDetails.put("wsdlName", serviceNode.getElementsByTagName("belongsTo").item(0).getFirstChild().getNodeValue());
            }
            if (serviceNode.getElementsByTagName("operation").item(0) != null) {
                String operationName = serviceNode.getElementsByTagName("operation").item(0).getFirstChild().getNodeValue();
                serviceDetails.put("operationName", Identifier.method(operationName));
            }
            if (serviceNode.getElementsByTagName("name").item(0) != null) {
                serviceDetails.put("serviceName", serviceNode.getElementsByTagName("name").item(0).getFirstChild().getNodeValue());
            }
        }
        catch (Exception e) {
            throw new BpaNoBizException(5, (Throwable)e);
        }
        return serviceDetails;
    }

    private ByteArrayOutputStream writeProjectFolderToZip() throws BpaNoBizException {
        ByteArrayOutputStream byteOut = null;
        try {
            byteOut = new ByteArrayOutputStream();
            ZipOutputStream zipOut = new ZipOutputStream(byteOut);
            String baseName = this.bpmnProjectFolder.getAbsolutePath();
            this.addFilesToZip(this.bpmnProjectFolder, zipOut, baseName);
            zipOut.close();
        }
        catch (Exception e) {
            throw new BpaNoBizException(5, (Throwable)e);
        }
        return byteOut;
    }

    private void addFilesToZip(File folder, ZipOutputStream zipOut, String baseName) throws BpaNoBizException {
        try {
            byte[] buffer = new byte[1024];
            File[] files = folder.listFiles();
            for (int i = 0; i < files.length; ++i) {
                int length;
                File file = files[i];
                if (file.isDirectory()) {
                    this.addFilesToZip(file, zipOut, baseName);
                    continue;
                }
                File originalProcessFile = new File(this.bpmnProjectFolder.getAbsolutePath(), File.separator + this.getBpmnProcess().getName() + ".bpmn");
                if (file.equals(originalProcessFile) || file.getName().endsWith(".bpmn") && file.getParent().equals(this.bpmnProjectFolder.getAbsolutePath())) continue;
                String name = file.getAbsolutePath().substring(baseName.length() + 1);
                ZipEntry zipEntry = new ZipEntry(name);
                zipOut.putNextEntry(zipEntry);
                FileInputStream fin = new FileInputStream(file);
                while ((length = fin.read(buffer)) > 0) {
                    zipOut.write(buffer, 0, length);
                }
                zipOut.closeEntry();
                fin.close();
            }
        }
        catch (Exception e) {
            throw new BpaNoBizException(5, (Throwable)e);
        }
    }

    private String getUnderscoreString(String label) {
        if (label == null) {
            return "";
        }
        label = label.replace(" ", "_");
        label = label.replace("(", "_");
        return (label = label.replace(")", "_")).length() > 81 ? label.substring(0, 81) : label;
    }

    private String replaceWhiteSpaces(String name) {
        return name.replace(" ", "_");
    }

    private void identifyTaskFiles(Map<String, Document> additionalDocs) {
        if (!additionalDocs.isEmpty()) {
            Set<String> files = additionalDocs.keySet();
            for (String fileName : files) {
                if (!fileName.contains(".task")) continue;
                this.getTaskFiles().add(fileName);
            }
        }
    }

    private List<String> removeDuplicateObjects(List<String> listObj) {
        HashSet<String> setObj = new HashSet<String>(listObj);
        return new ArrayList<String>(setObj);
    }

    private void handleNotificationActivity(FlowNode flowNode, Node bpaNode) {
        ActivityImpl activityObj = (ActivityImpl)flowNode;
        String notificationType = bpaNode.getAttr(Constants.ExtensionAttributes.AT_CHANNEL).toString();
        NotificationDefinition notificationDefinitionObj = activityObj.getNotificationDefinition();
        String receiver = bpaNode.getAttr(Constants.ExtensionAttributes.AT_RECEIVER).toString();
        String subject = bpaNode.getAttr(Constants.ExtensionAttributes.AT_SUBJ).toString();
        String body = bpaNode.getAttr(Constants.ExtensionAttributes.AT_TXT).toString();
        Expression receiverExpression = ExpressionHelper.createTextExpression((String)receiver);
        Expression subjectExpression = ExpressionHelper.createTextExpression((String)subject);
        Expression bodyExpression = ExpressionHelper.createTextExpression((String)body);
        Expression mimeExpression = ExpressionHelper.createTextExpression((String)"text/html");
        NotificationType type = null;
        if (notificationType != null) {
            if ("Email".equals(notificationType)) {
                type = NotificationType.MAIL;
                MailNotificationDefinition mailNotificationDefObj = (MailNotificationDefinition)notificationDefinitionObj.as(MailNotificationDefinition.class);
                mailNotificationDefObj.setTo(receiverExpression);
                mailNotificationDefObj.setSubject(subjectExpression);
                mailNotificationDefObj.setBody(bodyExpression);
                Object attachment = bpaNode.getAttr(Constants.ExtensionAttributes.AT_ORACLE_NOTIFICATION_ATTACHMENT);
                if (attachment != null) {
                    Expression attachmentExpression = ExpressionHelper.createTextExpression((String)attachment.toString());
                    MailNotificationAttachmentImpl mailAttachmentObj = new MailNotificationAttachmentImpl(attachmentExpression, mimeExpression, attachmentExpression, attachmentExpression);
                    mailNotificationDefObj.addAttachment((MailNotificationAttachment)mailAttachmentObj);
                }
            } else if ("SMS".equals(notificationType)) {
                type = NotificationType.SMS;
                activityObj.setNotificationType(type);
                notificationDefinitionObj = activityObj.createNotificationDefinition(type);
                SMSNotificationDefinition smsNotificationDefObj = (SMSNotificationDefinition)notificationDefinitionObj.as(SMSNotificationDefinition.class);
                smsNotificationDefObj.setTo(receiverExpression);
                smsNotificationDefObj.setSubject(subjectExpression);
                smsNotificationDefObj.setBody(bodyExpression);
            } else if ("Voice".equals(notificationType)) {
                type = NotificationType.VOICE;
                activityObj.setNotificationType(type);
                notificationDefinitionObj = activityObj.createNotificationDefinition(type);
                VoiceNotificationDefinition voiceNotificationDefObj = (VoiceNotificationDefinition)notificationDefinitionObj.as(VoiceNotificationDefinition.class);
                voiceNotificationDefObj.setTo(receiverExpression);
                voiceNotificationDefObj.setBody(bodyExpression);
                voiceNotificationDefObj.setMimeType(mimeExpression);
            } else if ("Instant Message".equals(notificationType)) {
                type = NotificationType.IM;
                activityObj.setNotificationType(type);
                notificationDefinitionObj = activityObj.createNotificationDefinition(type);
                IMNotificationDefinition imNotificationDefObj = (IMNotificationDefinition)notificationDefinitionObj.as(IMNotificationDefinition.class);
                imNotificationDefObj.setTo(receiverExpression);
                imNotificationDefObj.setBody(bodyExpression);
            } else if ("User Notification".equals(notificationType)) {
                type = NotificationType.USER;
                activityObj.setNotificationType(type);
                notificationDefinitionObj = activityObj.createNotificationDefinition(type);
                UserNotificationDefinition userNotificationDefObj = (UserNotificationDefinition)notificationDefinitionObj.as(UserNotificationDefinition.class);
                userNotificationDefObj.setTo(receiverExpression);
                userNotificationDefObj.setSubject(subjectExpression);
                userNotificationDefObj.setMessage(bodyExpression);
            }
        }
    }
}

