/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpa.util.xmlwrapper;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import oracle.bpa.common.context.BpaContext;
import oracle.bpa.common.exception.BpaException;
import oracle.bpa.common.exception.BpaRuntimeException;
import oracle.bpa.util.xmlwrapper.AttributeType;
import oracle.bpa.util.xmlwrapper.OracleExtensionElement;
import oracle.bpa.util.xmlwrapper.XMLWrapper;
import oracle.bpm.bpa.util.xmlwrapper.AttributeTypeImpl;
import oracle.bpm.bpa.util.xmlwrapper.OracleExtensionElementImpl;
import oracle.bpm.bpa.util.xmlwrapper.SubTypeImpl;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLWrapperImpl
implements XMLWrapper {
    BpaContext bpaContext;
    private HashMap mappings = new HashMap();
    private List oracleExtensionElements;
    private HashMap procAttrMappings = new HashMap();
    private List sensorAttributeTypes = new ArrayList();
    private HashMap sensorMappings;

    private XMLWrapperImpl(BpaContext context) {
        this.oracleExtensionElements = new ArrayList();
        this.sensorMappings = new HashMap();
        this.bpaContext = context;
    }

    public static XMLWrapperImpl getInstance(BpaContext context) {
        return new XMLWrapperImpl(context);
    }

    public void parseConfigFile(InputStream file) throws BpaException {
        InputStream inputStream = file;
        try {
            String value;
            CharacterData cd;
            Node enumerationValue;
            String enumValName;
            Element enumVal;
            CharacterData cd2;
            Node typeName;
            DOMParser domParser = new DOMParser();
            domParser.parse(inputStream);
            XMLDocument doc = domParser.getDocument();
            NodeList procAttrNodes = doc.getElementsByTagName("ProcessAttributeType");
            for (int x = 0; x < procAttrNodes.getLength(); ++x) {
                XMLElement procAttribute = (XMLElement)procAttrNodes.item(x);
                this.addToProcAttrMappings(procAttribute.getAttribute("mapsTo"), procAttribute.getTextContent().trim());
            }
            NodeList nodeList = doc.getElementsByTagName("OracleExtension");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                OracleExtensionElementImpl oracleExtension = new OracleExtensionElementImpl();
                Element element = (Element)nodeList.item(i);
                NodeList attributeList = element.getElementsByTagName("AttributeType");
                for (int j = 0; j < attributeList.getLength(); ++j) {
                    Element attributeType = (Element)attributeList.item(j);
                    AttributeTypeImpl attribute = new AttributeTypeImpl();
                    String mapsTo = attributeType.getAttribute("mapsto");
                    attribute.setMapping(mapsTo);
                    typeName = attributeType.getFirstChild();
                    if (typeName instanceof CharacterData) {
                        cd2 = (CharacterData)typeName;
                        attribute.setTypeName(cd2.getData().trim());
                        oracleExtension.addToAttributeMappings(mapsTo, cd2.getData().trim());
                        oracleExtension.addToReverseAttributeMappings(cd2.getData().trim(), mapsTo);
                    }
                    if (!attributeType.getAttribute("mandatory").equals("")) {
                        attribute.setMandatory();
                    }
                    if (!attributeType.getAttribute("multiplevals").equals("")) {
                        attribute.setMultiValued();
                    }
                    if (!attributeType.getAttribute("composite").equals("")) {
                        attribute.setHasSubTypes();
                        NodeList subTypesList = attributeType.getElementsByTagName("SubType");
                        for (int m = 0; m < subTypesList.getLength(); ++m) {
                            Element subTypeElement = (Element)subTypesList.item(m);
                            SubTypeImpl subType = new SubTypeImpl();
                            subType.setName(subTypeElement.getAttribute("name"));
                            if (!subTypeElement.getAttribute("multiplevals").equals("")) {
                                subType.setMultiValued();
                            }
                            if (!subTypeElement.getAttribute("enum").equals("")) {
                                NodeList enumTags = subTypeElement.getElementsByTagName("Enumeration");
                                NodeList enumerationValues = ((Element)enumTags.item(0)).getElementsByTagName("value");
                                for (int n = 0; n < enumerationValues.getLength(); ++n) {
                                    Element enumVal2 = (Element)enumerationValues.item(n);
                                    String enumValName2 = enumVal2.getAttribute("mapsto");
                                    Node enumerationValue2 = enumVal2.getFirstChild();
                                    if (!(enumerationValue2 instanceof CharacterData)) continue;
                                    CharacterData cd3 = (CharacterData)enumerationValue2;
                                    String value2 = cd3.getData().trim();
                                    subType.addToEnumerationValues(enumValName2, value2);
                                }
                                String defaultVal = ((Element)enumTags.item(0)).getAttribute("default");
                                if (!defaultVal.equals("")) {
                                    subType.setEnumerated(defaultVal);
                                } else {
                                    subType.setEnumerated();
                                }
                            }
                            attribute.addToSubTypes(subType);
                        }
                    }
                    if (!attributeType.getAttribute("enum").equals("")) {
                        NodeList enumTags = attributeType.getElementsByTagName("Enumeration");
                        NodeList enumerationValues = ((Element)enumTags.item(0)).getElementsByTagName("value");
                        for (int n = 0; n < enumerationValues.getLength(); ++n) {
                            enumVal = (Element)enumerationValues.item(n);
                            enumValName = enumVal.getAttribute("mapsto");
                            enumerationValue = enumVal.getFirstChild();
                            if (!(enumerationValue instanceof CharacterData)) continue;
                            cd = (CharacterData)enumerationValue;
                            value = cd.getData().trim();
                            attribute.addToEnumerationValues(enumValName, value);
                        }
                        String defaultVal = ((Element)enumTags.item(0)).getAttribute("default");
                        if (!defaultVal.equals("")) {
                            attribute.setEnumerated(defaultVal);
                        } else {
                            attribute.setEnumerated();
                        }
                    }
                    oracleExtension.addToAttributeTypeList(attribute);
                }
                this.addToOracleExtensionElements(oracleExtension);
                this.mappings.put(element.getAttribute("Name"), oracleExtension);
            }
            NodeList sensorAttributes = doc.getElementsByTagName("SensorAttributes");
            if (sensorAttributes != null && sensorAttributes.getLength() != 0) {
                NodeList sensorAttributeList = ((Element)sensorAttributes.item(0)).getElementsByTagName("AttributeType");
                HashMap<String, String> reverseSensorMappings = new HashMap<String, String>();
                HashMap<String, AttributeTypeImpl> sensorTypeMappings = new HashMap<String, AttributeTypeImpl>();
                HashMap<String, String> sensorAttrMappings = new HashMap<String, String>();
                for (int k = 0; k < sensorAttributeList.getLength(); ++k) {
                    Element sensorAttr = (Element)sensorAttributeList.item(k);
                    AttributeTypeImpl sensorAttributeType = new AttributeTypeImpl();
                    sensorAttributeType.setMapping(sensorAttr.getAttribute("mapsto"));
                    typeName = sensorAttr.getFirstChild();
                    if (typeName instanceof CharacterData) {
                        cd2 = (CharacterData)typeName;
                        sensorAttributeType.setTypeName(cd2.getData().trim());
                        sensorAttrMappings.put(sensorAttr.getAttribute("mapsto"), cd2.getData().trim());
                        reverseSensorMappings.put(cd2.getData().trim(), sensorAttr.getAttribute("mapsto"));
                    }
                    if (sensorAttr.getAttribute("enum").equals("true")) {
                        sensorAttributeType.setEnumerated();
                        NodeList enumeration = sensorAttr.getElementsByTagName("Enumeration");
                        if (enumeration.getLength() > 0) {
                            NodeList enumerationValues = ((Element)enumeration.item(0)).getElementsByTagName("value");
                            for (int n = 0; n < enumerationValues.getLength(); ++n) {
                                enumVal = (Element)enumerationValues.item(n);
                                enumValName = enumVal.getAttribute("mapsto");
                                enumerationValue = enumVal.getFirstChild();
                                if (!(enumerationValue instanceof CharacterData)) continue;
                                cd = (CharacterData)enumerationValue;
                                value = cd.getData().trim();
                                sensorAttributeType.addToEnumerationValues(enumValName, value);
                            }
                        }
                        sensorTypeMappings.put(sensorAttr.getAttribute("mapsto"), sensorAttributeType);
                    }
                    if (sensorAttr.getAttribute("mandatory").equals("true")) {
                        sensorAttributeType.setMandatory();
                    }
                    this.addToSensorAttributeTypes(sensorAttributeType);
                }
                this.sensorMappings.put("SensorTypeMap", sensorTypeMappings);
                this.sensorMappings.put("SensorAttrMap", sensorAttrMappings);
                this.sensorMappings.put("ReverseSensorAttrMap", reverseSensorMappings);
            }
        }
        catch (SAXException e) {
            throw new BpaException("XMLWrapperImpl", "parseConfigFile()", 23002, (Throwable)e, this.bpaContext);
        }
        catch (IOException exc) {
            throw new BpaException("XMLWrapperImpl", "parseConfigFile()", 23001, (Throwable)exc, this.bpaContext);
        }
        catch (Throwable t) {
            throw new BpaRuntimeException("XMLWrapperImpl", "parseConfigFile()", 23003, t, this.bpaContext);
        }
    }

    public Map<String, String> getAttributeMappings(String SymbolName) {
        ListIterator l = this.oracleExtensionElements.listIterator();
        while (l.hasNext()) {
            OracleExtensionElement element = (OracleExtensionElement)l.next();
            if (!SymbolName.equals(element.getSymbolName())) continue;
            return element.getAttributeMappings();
        }
        return null;
    }

    public Map<String, String> getReverseAttributeMappings(String SymbolName) {
        ListIterator l = this.oracleExtensionElements.listIterator();
        while (l.hasNext()) {
            OracleExtensionElement element = (OracleExtensionElement)l.next();
            if (!SymbolName.equals(element.getSymbolName())) continue;
            return element.getReverseAttributeMappings();
        }
        return null;
    }

    public List getSensorAttributeTypes() {
        return this.sensorAttributeTypes;
    }

    public OracleExtensionElement getOracleExtensionElement(String symbolName) {
        ListIterator l = this.oracleExtensionElements.listIterator();
        while (l.hasNext()) {
            OracleExtensionElement oracleExtension = (OracleExtensionElement)l.next();
            if (!oracleExtension.getSymbolName().equals(symbolName)) continue;
            return oracleExtension;
        }
        return null;
    }

    public List getOracleExtensionElements() {
        return this.oracleExtensionElements;
    }

    public HashMap getSymbolMappings() {
        return this.mappings;
    }

    public HashMap getProcessAttributeMappings() {
        return this.procAttrMappings;
    }

    public HashMap getSensorMappings() {
        return this.sensorMappings;
    }

    private void addToOracleExtensionElements(OracleExtensionElementImpl oracleExtension) {
        this.oracleExtensionElements.add(oracleExtension);
    }

    private void addToSensorAttributeTypes(AttributeType sensorAttribute) {
        this.sensorAttributeTypes.add(sensorAttribute);
    }

    private void addToProcAttrMappings(String mapsTo, String typeName) {
        this.procAttrMappings.put(mapsTo, typeName);
    }
}

