/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpa.util.xmlwrapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import oracle.bpa.util.xmlwrapper.AttributeType;
import oracle.bpa.util.xmlwrapper.OracleExtensionElement;

public class OracleExtensionElementImpl
implements OracleExtensionElement {
    private Map<String, String> attributeMappings;
    private List attributeTypeList = new ArrayList();
    private Map<String, String> reverseAttributeMappings;
    private String symbolName;

    public OracleExtensionElementImpl() {
        this.attributeMappings = new HashMap<String, String>();
        this.reverseAttributeMappings = new HashMap<String, String>();
    }

    public void addToAttributeTypeList(AttributeType attr) {
        this.attributeTypeList.add(attr);
    }

    public void addToAttributeMappings(String mapsTo, String typeName) {
        this.attributeMappings.put(mapsTo, typeName);
    }

    public void addToReverseAttributeMappings(String typeName, String mapsTo) {
        this.reverseAttributeMappings.put(typeName, mapsTo);
    }

    public Map<String, String> getAttributeMappings() {
        return this.attributeMappings;
    }

    public Map<String, String> getReverseAttributeMappings() {
        return this.reverseAttributeMappings;
    }

    public AttributeType getAttributeTypeByType(String attributeTypeName) {
        ListIterator l = this.attributeTypeList.listIterator();
        while (l.hasNext()) {
            AttributeType attr = (AttributeType)l.next();
            if (!attr.getTypeName().equals(attributeTypeName)) continue;
            return attr;
        }
        return null;
    }

    public AttributeType getAttributeTypeByName(String attributeName) {
        ListIterator l = this.attributeTypeList.listIterator();
        while (l.hasNext()) {
            AttributeType attr = (AttributeType)l.next();
            if (!attr.getMapping().equals(attributeName)) continue;
            return attr;
        }
        return null;
    }

    public void setSymbolName(String name) {
        this.symbolName = name;
    }

    public String getSymbolName() {
        return this.symbolName;
    }
}

