/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpa.merge;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LaneUtils;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.ServiceTask;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeUtils;

public class BPMNSync {
    private static Process m_mergedProcess;
    private static Process m_analystProcess;
    private static HashMap m_nodesAddedFromServer;
    private static HashMap m_flowsAddedFromServer;
    private static HashMap m_flowsModifiedFromServer;
    private static HashMap m_nodesLabelChangedFromServer;
    private static HashMap m_nodesDescChangedFromServer;
    private static HashMap m_nodesLaneChangedFromServer;
    private static HashMap m_nodesAddedInStudio;
    private static String m_itDirectory;
    private static String m_analystDirectory;
    private static String m_outputDirectory;

    public BPMNSync(Process itProcess, Process analystProcess, Process mergedProcess) {
        this.init(itProcess, analystProcess, mergedProcess);
    }

    public BPMNSync(Process itProcess, Process analystProcess, Process mergedProcess, String itDirectory, String analystDirectory, String outputDirectory) {
        this(itProcess, analystProcess, mergedProcess, itDirectory, analystDirectory, outputDirectory, null);
    }

    public BPMNSync(Process itProcess, Process analystProcess, Process mergedProcess, String itDirectory, String analystDirectory, String outputDirectory, File logFile) {
        File outputFile;
        if (logFile != null) {
            if (logFile.exists()) {
                logFile.delete();
            }
            try {
                logFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        m_itDirectory = itDirectory;
        m_analystDirectory = analystDirectory;
        m_outputDirectory = outputDirectory;
        if (outputDirectory != null && !(outputFile = new File(outputDirectory)).exists()) {
            outputFile.mkdirs();
        }
        this.init(itProcess, analystProcess, mergedProcess);
    }

    public static void printAMap(Map mapToPrint) {
        Set guidSet = mapToPrint.keySet();
        for (String key : guidSet) {
            ProjectObject value = (ProjectObject)mapToPrint.get(key);
            System.out.println("pair: " + key + ", " + value.getId());
        }
    }

    public static void main(String[] args) {
        Process mergedProc = null;
        try {
            ProcessContent itProc = new ProcessContent(null, (ComponentCatalog)TypeUtils.getDefaultCatalog());
            itProc.setId("ProcessA");
            StartEvent s = itProc.createStartEvent(EventTriggerType.MESSAGE);
            s.setId("start1");
            itProc.addChild((ProjectObject)s);
            EndEvent e = itProc.createEndEvent(EventTriggerType.MESSAGE);
            e.setId("end1");
            itProc.addChild((ProjectObject)e);
            Activity act1 = itProc.createActivity();
            ServiceTask st1 = act1.toServiceTask();
            st1.setId("Task1");
            st1.setDefaultLabel("Service Task 1");
            itProc.addChild((ProjectObject)st1);
            SequenceFlow s1 = itProc.createSequenceFlow((FlowNode)s, (FlowNode)st1);
            s1.setId("Flow1");
            itProc.addChild((ProjectObject)s1);
            SequenceFlow s2 = itProc.createSequenceFlow((FlowNode)st1, (FlowNode)e);
            s2.setId("Flow2");
            itProc.addChild((ProjectObject)s2);
            ProcessContent bpaProc = new ProcessContent(null, (ComponentCatalog)TypeUtils.getDefaultCatalog());
            bpaProc.setId("ProcessA");
            StartEvent sNew = bpaProc.createStartEvent(EventTriggerType.MESSAGE);
            sNew.setId("start1");
            bpaProc.addChild((ProjectObject)sNew);
            EndEvent eNew = bpaProc.createEndEvent(EventTriggerType.MESSAGE);
            eNew.setId("end1");
            bpaProc.addChild((ProjectObject)eNew);
            Activity actNew = bpaProc.createActivity();
            ServiceTask stNew = actNew.toServiceTask();
            stNew.setId("Task1");
            stNew.setDefaultLabel("Service Task One");
            bpaProc.addChild((ProjectObject)stNew);
            Activity act2 = bpaProc.createActivity();
            ServiceTask st2 = act2.toServiceTask();
            st2.setId("Task2");
            st2.setDefaultLabel("Service Task 2");
            bpaProc.addChild((ProjectObject)st2);
            SequenceFlow sflow1 = itProc.createSequenceFlow((FlowNode)sNew, (FlowNode)stNew);
            sflow1.setId("Flow1");
            bpaProc.addChild((ProjectObject)sflow1);
            SequenceFlow s3 = bpaProc.createSequenceFlow((FlowNode)stNew, (FlowNode)st2);
            s3.setId("Flow3");
            bpaProc.addChild((ProjectObject)s3);
            SequenceFlow s4 = bpaProc.createSequenceFlow((FlowNode)st2, (FlowNode)eNew);
            s4.setId("Flow4");
            bpaProc.addChild((ProjectObject)s4);
            BPMNSync bpmnSync = new BPMNSync((Process)itProc, (Process)bpaProc, mergedProc, null, null, null, null);
            System.out.println(" Main2 Nowidentifyingdifferences...........");
            mergedProc = bpmnSync.merge(false);
            System.out.println(" The nodes added to the process are :");
            BPMNSync.printAMap(bpmnSync.getNodesAddedFromServer());
            System.out.println(" The flows added to the process are :");
            BPMNSync.printAMap(bpmnSync.getFlowsAddedFromServer());
            System.out.println(" The nodes modified in the process are :");
            BPMNSync.printAMap(bpmnSync.getNodesLabelChangedFromServer());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Process merge(boolean overwrite) throws Exception {
        this.identifyDiffsAndMergeModels(overwrite);
        if (m_outputDirectory != null) {
            this.printBpmn();
        }
        return m_mergedProcess;
    }

    public HashMap getNodesAddedInStudio() {
        return m_nodesAddedInStudio;
    }

    public HashMap getNodesAddedFromServer() {
        return m_nodesAddedFromServer;
    }

    public HashMap getNodesLaneChangedFromServer() {
        return m_nodesLaneChangedFromServer;
    }

    public HashMap getNodesLabelChangedFromServer() {
        return m_nodesLabelChangedFromServer;
    }

    public HashMap getNodesDescChangedFromServer() {
        return m_nodesDescChangedFromServer;
    }

    public HashMap getFlowsAddedFromServer() {
        return m_flowsAddedFromServer;
    }

    public HashMap getFlowsModifiedInServer() {
        return m_flowsModifiedFromServer;
    }

    public Process getMergedBpmn() {
        return m_mergedProcess;
    }

    public Process getAnalystBpmn() {
        return m_analystProcess;
    }

    private void init(Process itProcess, Process analystProcess, Process mergedProcess) {
        this.initMaps();
        m_mergedProcess = mergedProcess;
        m_analystProcess = (Process)analystProcess.copy();
        m_mergedProcess = (Process)itProcess.copy();
    }

    private void identifyDiffsAndMergeModels(boolean overwrite) {
        String flowId;
        for (FlowNode n : m_mergedProcess.getFlowNodes()) {
            String nodeId = n.getId();
            FlowNode bpaNode = m_analystProcess.findNode(nodeId);
            if (bpaNode != null) continue;
            m_nodesAddedInStudio.put(nodeId, n);
        }
        for (FlowNode analystNode : m_analystProcess.getFlowNodes()) {
            String analystNodeId = analystNode.getId();
            FlowNode mergedNode = m_mergedProcess.findNode(analystNodeId);
            if (mergedNode == null) {
                this.insertNode(analystNode, overwrite);
                continue;
            }
            this.updateNode(analystNode, mergedNode, overwrite);
        }
        for (SequenceFlow s : m_analystProcess.getSequenceFlows()) {
            flowId = s.getId();
            SequenceFlow mergedFlow = m_mergedProcess.findSequenceFlow(flowId);
            if (mergedFlow == null) {
                FlowNode mergedSourceNode = m_mergedProcess.findNode(s.getSource().getId());
                FlowNode mergedTargetNode = m_mergedProcess.findNode(s.getTarget().getId());
                if (overwrite) {
                    mergedFlow = m_mergedProcess.createSequenceFlow(mergedSourceNode, mergedTargetNode);
                    mergedFlow.setId(flowId);
                    if (s.isConditionalFlow()) {
                        mergedFlow.toConditionalFlow().getCondition();
                        mergedFlow.asConditionalFlow().setCondition(s.asConditionalFlow().getCondition());
                    }
                }
                try {
                    if (overwrite) {
                        m_mergedProcess.addChild((ProjectObject)mergedFlow);
                        continue;
                    }
                    m_flowsAddedFromServer.put(flowId, s);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            boolean flowChanged = false;
            if (s.getDefaultLabel() != null && !s.getDefaultLabel().equals(mergedFlow.getDefaultLabel())) {
                if (overwrite) {
                    mergedFlow.setDefaultLabel(s.getDefaultLabel());
                }
                flowChanged = true;
            }
            if (s.isConditionalFlow() && s.asConditionalFlow().getCondition() != null) {
                String serverFlowCondition = s.asConditionalFlow().getCondition().getExpressionValue();
                String localFlowCondition = null;
                if (mergedFlow.toConditionalFlow().getCondition() != null) {
                    localFlowCondition = mergedFlow.asConditionalFlow().getCondition().getExpressionValue();
                }
                if (serverFlowCondition != null && !serverFlowCondition.equals(localFlowCondition)) {
                    if (overwrite) {
                        String mergedFlowLabel = mergedFlow.getDefaultLabel();
                        if (mergedFlowLabel != null) {
                            mergedFlow.asConditionalFlow().setDefaultLabel(mergedFlowLabel + "(condition changed: see Description)");
                            mergedFlow.setDefaultDescription(serverFlowCondition);
                        } else {
                            mergedFlow.asConditionalFlow().setDefaultLabel("(condition changed: see Description)");
                            mergedFlow.setDefaultDescription(serverFlowCondition);
                        }
                    }
                    flowChanged = true;
                }
            }
            if (!flowChanged || overwrite) continue;
            m_flowsModifiedFromServer.put(flowId, s);
        }
        for (SequenceFlow s : m_mergedProcess.getSequenceFlows()) {
            FlowNode analystTarget;
            FlowNode analystSource;
            flowId = s.getId();
            SequenceFlow analystFlow = m_analystProcess.findSequenceFlow(flowId);
            if (analystFlow != null) {
                analystSource = m_analystProcess.findNode(s.getSource().getId());
                analystTarget = m_analystProcess.findNode(s.getTarget().getId());
                FlowNode oldSource = m_mergedProcess.findNode(analystFlow.getSource().getId());
                FlowNode oldTarget = m_mergedProcess.findNode(analystFlow.getTarget().getId());
                if (analystSource != null && analystTarget != null) {
                    if (oldSource != null && !oldSource.getId().equals(analystSource.getId()) && overwrite) {
                        s.setSource(oldSource);
                    }
                    if (oldTarget != null && !oldTarget.getId().equals(analystTarget.getId()) && overwrite) {
                        s.setTarget(oldTarget);
                    }
                }
            }
            if (analystFlow != null) continue;
            analystSource = m_analystProcess.findNode(s.getSource().getId());
            analystTarget = m_analystProcess.findNode(s.getTarget().getId());
            if (analystSource == null || analystTarget == null) continue;
            try {
                if (!overwrite) continue;
                m_mergedProcess.removeChild((ProjectObject)s);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void insertNode(FlowNode node, boolean overwrite) {
        Subprocess m_subproc;
        if (node.getBpmnType().equals((Object)BpmnType.SUBPROCESS) && (m_subproc = (Subprocess)node) != null) {
            System.out.println("subproc found during merge");
            for (FlowNode subNode : m_subproc.getFlowNodes()) {
                if (overwrite) continue;
                m_nodesAddedFromServer.put(subNode.getId(), subNode);
            }
        }
        try {
            Lane mergedLane;
            if (overwrite) {
                Subprocess m_subproc1;
                Subprocess m_subproc2;
                ArrayList<FlowNode> subProcNodeList = new ArrayList<FlowNode>();
                if (node.getBpmnType().equals((Object)BpmnType.SUBPROCESS) && (m_subproc2 = (Subprocess)node) != null) {
                    for (FlowNode subNode : m_subproc2.getFlowNodes()) {
                        System.out.println("removed subproc node " + subNode.getId());
                        subProcNodeList.add(subNode);
                    }
                }
                m_analystProcess.removeChild((ProjectObject)node);
                m_mergedProcess.addChild((ProjectObject)node);
                if (node.getBpmnType().equals((Object)BpmnType.SUBPROCESS) && (m_subproc1 = (Subprocess)node) != null) {
                    for (FlowNode subNode : subProcNodeList) {
                        System.out.println("added subproc node " + subNode.getId());
                    }
                }
            } else {
                m_nodesAddedFromServer.put(node.getId(), node);
            }
            Lane newLane = node.getLane();
            if (newLane != null && (mergedLane = m_mergedProcess.findLane(newLane.getId())) == null) {
                if (!overwrite) {
                    m_nodesLaneChangedFromServer.put(node.getId(), node);
                } else {
                    mergedLane = m_mergedProcess.createLane(newLane.getName());
                    mergedLane.setId(newLane.getName());
                    mergedLane.setSize(newLane.getSize());
                    mergedLane.setOffset(newLane.getOffset());
                    m_mergedProcess.addChild((ProjectObject)mergedLane);
                    LaneUtils.setLaneForFlowNode((Lane)mergedLane, (FlowNode)node);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateNode(FlowNode analystNode, FlowNode mergedNode, boolean overwrite) {
        if (mergedNode.getBpmnType().equals((Object)BpmnType.SUBPROCESS)) {
            Subprocess subProc = (Subprocess)mergedNode;
            if (analystNode.getBpmnType().equals((Object)BpmnType.SUBPROCESS)) {
                String flowId;
                Subprocess remoteSubProc = (Subprocess)analystNode;
                for (FlowNode fn : remoteSubProc.getFlowNodes()) {
                    FlowNode remoteFn = subProc.findNode(fn.getId());
                    if (remoteFn == null) {
                        if (overwrite) {
                            try {
                                remoteSubProc.removeChild((ProjectObject)fn);
                                subProc.addChild((ProjectObject)fn);
                            }
                            catch (Exception e) {}
                            continue;
                        }
                        m_nodesAddedFromServer.put(fn.getId(), fn);
                        continue;
                    }
                    if (fn.getDefaultLabel() != null && !fn.getDefaultLabel().equals(remoteFn.getDefaultLabel())) {
                        if (overwrite) {
                            remoteFn.setDefaultLabel(fn.getDefaultLabel());
                        } else {
                            m_nodesLabelChangedFromServer.put(fn.getId(), fn);
                        }
                    }
                    if (this.isIdentical(fn.getDefaultDescription(), remoteFn.getDefaultDescription())) continue;
                    if (overwrite) {
                        remoteFn.setDefaultDescription(fn.getDefaultDescription());
                        continue;
                    }
                    m_nodesDescChangedFromServer.put(fn.getId(), fn);
                }
                for (SequenceFlow s : remoteSubProc.getSequenceFlows()) {
                    flowId = s.getId();
                    SequenceFlow mergedFlow = subProc.findSequenceFlow(flowId);
                    if (mergedFlow == null) {
                        FlowNode mergedSourceNode = subProc.findNode(s.getSource().getId());
                        FlowNode mergedTargetNode = subProc.findNode(s.getTarget().getId());
                        if (overwrite) {
                            mergedFlow = subProc.createSequenceFlow(mergedSourceNode, mergedTargetNode);
                            mergedFlow.setId(flowId);
                            if (s.isConditionalFlow()) {
                                mergedFlow.toConditionalFlow().getCondition();
                                mergedFlow.asConditionalFlow().setCondition(s.asConditionalFlow().getCondition());
                            }
                        }
                        try {
                            if (overwrite) {
                                subProc.addChild((ProjectObject)mergedFlow);
                                continue;
                            }
                            m_flowsAddedFromServer.put(flowId, s);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    boolean flowChanged = false;
                    if (s.getDefaultLabel() != null && !s.getDefaultLabel().equals(mergedFlow.getDefaultLabel())) {
                        if (overwrite) {
                            mergedFlow.setDefaultLabel(s.getDefaultLabel());
                        }
                        flowChanged = true;
                    }
                    if (s.isConditionalFlow() && s.asConditionalFlow().getCondition() != null) {
                        String serverFlowCondition = s.asConditionalFlow().getCondition().getExpressionValue();
                        String localFlowCondition = null;
                        if (mergedFlow.toConditionalFlow().getCondition() != null) {
                            localFlowCondition = mergedFlow.asConditionalFlow().getCondition().getExpressionValue();
                        }
                        if (serverFlowCondition != null && !serverFlowCondition.equals(localFlowCondition)) {
                            if (overwrite) {
                                String mergedFlowLabel = mergedFlow.getDefaultLabel();
                                if (mergedFlowLabel != null) {
                                    mergedFlow.asConditionalFlow().setDefaultLabel(mergedFlowLabel + "(condition changed: see Description)");
                                    mergedFlow.setDefaultDescription(serverFlowCondition);
                                } else {
                                    mergedFlow.asConditionalFlow().setDefaultLabel("(condition changed: see Description)");
                                    mergedFlow.setDefaultDescription(serverFlowCondition);
                                }
                            }
                            flowChanged = true;
                        }
                    }
                    if (!flowChanged || overwrite) continue;
                    m_flowsModifiedFromServer.put(flowId, s);
                }
                for (SequenceFlow s : subProc.getSequenceFlows()) {
                    FlowNode analystTarget;
                    FlowNode analystSource;
                    flowId = s.getId();
                    SequenceFlow analystFlow = remoteSubProc.findSequenceFlow(flowId);
                    if (analystFlow != null) {
                        analystSource = remoteSubProc.findNode(s.getSource().getId());
                        analystTarget = remoteSubProc.findNode(s.getTarget().getId());
                        FlowNode oldSource = subProc.findNode(analystFlow.getSource().getId());
                        FlowNode oldTarget = subProc.findNode(analystFlow.getTarget().getId());
                        if (analystSource != null && analystTarget != null) {
                            if (oldSource != null && !oldSource.getId().equals(analystSource.getId()) && overwrite) {
                                s.setSource(oldSource);
                            }
                            if (oldTarget != null && !oldTarget.getId().equals(analystTarget.getId()) && overwrite) {
                                s.setTarget(oldTarget);
                            }
                        }
                    }
                    if (analystFlow != null) continue;
                    analystSource = remoteSubProc.findNode(s.getSource().getId());
                    analystTarget = remoteSubProc.findNode(s.getTarget().getId());
                    if (analystSource == null || analystTarget == null) continue;
                    try {
                        if (!overwrite) continue;
                        subProc.removeChild((ProjectObject)s);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (mergedNode.getLane() != null && analystNode.getLane() != null && !mergedNode.getLane().getName().equals(analystNode.getLane().getName())) {
            String analystLaneId = analystNode.getLane().getId();
            Lane analystLane = analystNode.getLane();
            Lane mergedLane = null;
            for (Lane l : m_mergedProcess.getChildrenByType(Lane.class)) {
                if (!l.getId().equals(analystLaneId)) continue;
                mergedLane = l;
                if (!overwrite) break;
                mergedNode.setLane(mergedLane);
                LaneUtils.setLaneForFlowNode((Lane)mergedLane, (FlowNode)mergedNode);
                break;
            }
            if (mergedLane == null) {
                if (overwrite) {
                    mergedLane = m_mergedProcess.createLane(analystLaneId);
                    mergedLane.setId(analystLaneId);
                    try {
                        m_mergedProcess.addChild((ProjectObject)mergedLane);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (mergedLane != null) {
                        mergedNode.setLane(mergedLane);
                        LaneUtils.setLaneForFlowNode((Lane)mergedLane, (FlowNode)mergedNode);
                    }
                } else {
                    m_nodesLaneChangedFromServer.put(mergedNode.getId(), mergedNode);
                }
            }
        }
        if (overwrite) {
            mergedNode.setX(analystNode.getX());
            mergedNode.setY(analystNode.getY());
        }
        if (analystNode.getDefaultLabel() != null && !analystNode.getDefaultLabel().equals(mergedNode.getDefaultLabel())) {
            if (overwrite) {
                mergedNode.setDefaultLabel(analystNode.getDefaultLabel());
            } else {
                System.out.println("label is " + analystNode.getDefaultLabel());
                m_nodesLabelChangedFromServer.put(analystNode.getId(), analystNode);
            }
        }
        if (!this.isIdentical(analystNode.getDefaultDescription(), mergedNode.getDefaultDescription()) && overwrite) {
            mergedNode.setDefaultDescription(analystNode.getDefaultDescription());
        }
    }

    private void printBpmn() {
    }

    private boolean isIdentical(String local, String remote) {
        if (local == remote) {
            return true;
        }
        if (local != null) {
            return local.equals(remote);
        }
        return false;
    }

    private void initMaps() {
        m_nodesAddedFromServer = new HashMap();
        m_flowsAddedFromServer = new HashMap();
        m_flowsModifiedFromServer = new HashMap();
        m_nodesLabelChangedFromServer = new HashMap();
        m_nodesDescChangedFromServer = new HashMap();
        m_nodesLaneChangedFromServer = new HashMap();
        m_nodesAddedInStudio = new HashMap();
    }
}

