/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpa.export.bpmn.impl;

import java.util.Arrays;
import oracle.bpa.export.pluginwrapper.BpaBpelAttribute;
import oracle.bpa.export.pluginwrapper.BpaBpelProcess;
import oracle.bpm.bpa.export.bpmn.impl.BpmnAttribute;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ThrowEvent;

public class BpmnProcess
implements BpaBpelProcess {
    private Process process;

    public BpmnProcess(Process process) {
        this.process = process;
    }

    public String getName() {
        return this.process.getDefaultLabel();
    }

    public String getGUID() {
        return this.process.getId();
    }

    public String getFilter() {
        return null;
    }

    public BpaBpelAttribute getAttribute(String type) {
        if (type == null) {
            return null;
        }
        if (type.equals("Id") && this.process.getId() != null) {
            return new BpmnAttribute(type, this.process.getId());
        }
        if (type.equals("Name") && this.process.getDefaultLabel() != null) {
            return new BpmnAttribute(type, this.process.getDefaultLabel());
        }
        if (type.equals("Description") && this.process.getDefaultDescription() != null) {
            return new BpmnAttribute(type, this.process.getDefaultDescription());
        }
        if (type.equals("MainProcessFlag")) {
            return new BpmnAttribute(type, "true");
        }
        if (type.equals("ProcessType")) {
            String processType = null;
            Sequence events = this.process.getEvents();
            for (Event event : events) {
                if (event.isEnd() && event.getEventTriggerType().equals((Object)EventTriggerType.NONE)) {
                    processType = "Synchronous";
                    break;
                }
                if (!event.isEnd() || !((ThrowEvent)event).isSync()) continue;
                processType = "Synchronous";
                break;
            }
            if (processType == null) {
                processType = "ASynchronous";
            }
            return new BpmnAttribute(type, processType);
        }
        if (type.equals("Lanes") && !this.process.getLanes().isEmpty()) {
            return new BpmnAttribute(type, Arrays.toString(this.process.getLanes().toArray()));
        }
        if (type.equals("SequenceFlows") && !this.process.getSequenceFlows().isEmpty()) {
            return new BpmnAttribute(type, Arrays.toString(this.process.getSequenceFlows().toArray()));
        }
        return null;
    }
}

