/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpa.export.bpmn.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import oracle.bpa.bpmn.model.Node;
import oracle.bpa.export.pluginwrapper.BpaBpelAttribute;
import oracle.bpa.export.pluginwrapper.BpaBpelObject;
import oracle.bpm.bpa.bpmn.util.BoundaryFinder;
import oracle.bpm.bpa.bpmn.util.Graph;
import oracle.bpm.bpa.export.bpmn.impl.BpmnAttribute;
import oracle.bpm.bpa.export.bpmn.impl.BpmnConnection;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.catalog.type.utils.CatalogMemberUtils;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.interfaces.OperationReferenceImpl;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.ParticipantEnabled;
import oracle.bpm.project.model.processes.ParticipantReference;
import oracle.bpm.project.model.processes.ReceiveTask;
import oracle.bpm.project.model.processes.SendTask;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.ThrowEvent;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.conversational.Conversational;

public class BpmnObject
implements BpaBpelObject {
    boolean automated = false;
    boolean endActivity = false;
    boolean eventScope = false;
    boolean indepSubp = false;
    FlowNode node;
    BoundaryFinder processBoundaryFinder;
    Graph processGraph;
    boolean startActivity = false;
    boolean subpScope = false;
    String type = null;
    public static String GATEWAY = "Gateway";

    public BpmnObject(FlowNode node, Graph graph, BoundaryFinder boundaryFinder) {
        this.node = node;
        this.processGraph = graph;
        this.processBoundaryFinder = boundaryFinder;
    }

    public List getConnectedObjects(String objectType) {
        ArrayList<BpmnObject> connectedObjects = new ArrayList<BpmnObject>();
        BpmnType objType = BpmnType.valueOf((String)objectType);
        Sequence<SequenceFlow> incomingSequenceFlow = this.processGraph.getIncomingSequenceFlows(this.node);
        for (SequenceFlow conn : incomingSequenceFlow) {
            String srcId = conn.getSource().getId();
            FlowNode srcNode = this.processGraph.getNode(srcId);
            if (!srcNode.getBpmnType().equals((Object)objType)) continue;
            connectedObjects.add(new BpmnObject(srcNode, this.processGraph, this.processBoundaryFinder));
        }
        Sequence<SequenceFlow> outcomingSequenceFlow = this.processGraph.getOutgoingSequenceFlows(this.node);
        for (SequenceFlow conn : outcomingSequenceFlow) {
            String tgtId = conn.getTarget().getId();
            FlowNode tgtNode = this.processGraph.getNode(tgtId);
            if (!tgtNode.getBpmnType().equals((Object)objType)) continue;
            connectedObjects.add(new BpmnObject(tgtNode, this.processGraph, this.processBoundaryFinder));
        }
        return connectedObjects;
    }

    public List getAllIncomingConnections() {
        ArrayList<BpmnConnection> incomingConnections = new ArrayList<BpmnConnection>();
        Sequence<SequenceFlow> incomingSequenceFlow = this.processGraph.getIncomingSequenceFlows(this.node);
        for (SequenceFlow conn : incomingSequenceFlow) {
            incomingConnections.add(new BpmnConnection(conn, this.processGraph, this.processBoundaryFinder));
        }
        return incomingConnections;
    }

    public List getAllOutgoingConnections() {
        ArrayList<BpmnConnection> outgoingConnections = new ArrayList<BpmnConnection>();
        Sequence<SequenceFlow> outgoingSequenceFlow = this.processGraph.getOutgoingSequenceFlows(this.node);
        for (SequenceFlow conn : outgoingSequenceFlow) {
            outgoingConnections.add(new BpmnConnection(conn, this.processGraph, this.processBoundaryFinder));
        }
        return outgoingConnections;
    }

    public boolean isStartActivity() {
        return this.startActivity;
    }

    public boolean isEndActivity() {
        return this.endActivity;
    }

    public boolean isAutomated() {
        return this.automated;
    }

    public boolean isEventScope() {
        return this.eventScope;
    }

    public void setStartActivity() {
        this.startActivity = true;
    }

    public void setEndActivity() {
        this.endActivity = true;
    }

    public void setAutomated() {
        this.automated = true;
    }

    public void setEventScope() {
        this.eventScope = true;
    }

    public void setSubprocessScope() {
        this.subpScope = true;
    }

    public String getType() {
        if (this.type == null) {
            BpmnType gatewayType;
            if (this.node.isActivity()) {
                Activity act = (Activity)this.node.asAnyNode(Activity.class);
                if (act.isSubprocess()) {
                    return null;
                }
                if (act.isUserTask()) {
                    return "HumanTask";
                }
                if (act instanceof BusinessRuleTask) {
                    return "DecisionService";
                }
            } else if (this.node.isEvent()) {
                Event evt = (Event)this.node.asAnyNode(Event.class);
                if (evt.getBpmnType().equals((Object)BpmnType.CATCH_INTERMEDIATE_EVENT) && evt.getEventTriggerType().equals((Object)EventTriggerType.MESSAGE)) {
                    return "Notification";
                }
            } else if (this.node.isGateway() && ((gatewayType = this.node.getBpmnType()).equals((Object)BpmnType.EXCLUSIVE_GATEWAY) || gatewayType.equals((Object)BpmnType.INCLUSIVE_GATEWAY) || gatewayType.equals((Object)BpmnType.PARALLEL_GATEWAY))) {
                return GATEWAY;
            }
        }
        return this.type;
    }

    public void setType(String objType) {
        this.type = objType;
    }

    public List getAttributes() {
        BpmnAttribute bpmnAttr;
        ArrayList<BpmnAttribute> attributes = new ArrayList<BpmnAttribute>();
        if (this.node.getId() != null) {
            bpmnAttr = new BpmnAttribute("Id", this.node.getId());
            attributes.add(bpmnAttr);
        }
        if (this.node.getDefaultLabel() != null) {
            bpmnAttr = new BpmnAttribute("Name", this.node.getDefaultLabel());
            attributes.add(bpmnAttr);
        }
        if (this.node.getDefaultDescription() != null) {
            bpmnAttr = new BpmnAttribute("Description", this.node.getDefaultDescription());
            attributes.add(bpmnAttr);
        }
        if (this.node.getLane() != null) {
            bpmnAttr = new BpmnAttribute("Lane", this.node.getLane().getName());
            attributes.add(bpmnAttr);
        }
        if (this.node.isEvent()) {
            bpmnAttr = new BpmnAttribute("NodeType", "Event");
            attributes.add(bpmnAttr);
            bpmnAttr = new BpmnAttribute("EventType", this.node.getBpmnType().toString());
            attributes.add(bpmnAttr);
            Event evt = (Event)this.node.asAnyNode(Event.class);
            if (evt.isCatchEvent()) {
                bpmnAttr = new BpmnAttribute("OutMessage", "out");
                attributes.add(bpmnAttr);
            }
            if (evt.isThrowEvent()) {
                bpmnAttr = ((ThrowEvent)evt).isSync() ? new BpmnAttribute("Message", "in") : new BpmnAttribute("InMessage", "in");
                attributes.add(bpmnAttr);
            }
            if (evt.getBpmnType().equals((Object)BpmnType.CATCH_INTERMEDIATE_EVENT) && evt.getEventTriggerType().equals((Object)EventTriggerType.MESSAGE)) {
                bpmnAttr = new BpmnAttribute("TaskType", "Notification");
                attributes.add(bpmnAttr);
            }
            if (evt.isCatchEvent()) {
                bpmnAttr = new BpmnAttribute("Instantiate", evt.asCatchEvent().isConversationInitiator() ? "yes" : "no");
                attributes.add(bpmnAttr);
            }
        }
        if (this.node.isGateway()) {
            bpmnAttr = new BpmnAttribute("NodeType", "Gateway");
            attributes.add(bpmnAttr);
            bpmnAttr = new BpmnAttribute("GatewayType", this.node.getBpmnType().toString());
            attributes.add(bpmnAttr);
        }
        if (this.node.isActivity()) {
            bpmnAttr = new BpmnAttribute("NodeType", "Activity");
            attributes.add(bpmnAttr);
            bpmnAttr = new BpmnAttribute("ActivityType", this.node.getBpmnType().toString());
            attributes.add(bpmnAttr);
            Activity act = (Activity)this.node.asAnyNode(Activity.class);
            if (act.isSubprocess()) {
                bpmnAttr = new BpmnAttribute("Embedded", "Embedded");
                attributes.add(bpmnAttr);
            }
            if (act.isCallActivity()) {
                bpmnAttr = new BpmnAttribute("Embedded", "Independent");
                attributes.add(bpmnAttr);
            }
            if (act.isBusinessRuleTask()) {
                bpmnAttr = new BpmnAttribute("AT_REPOSITORY", act.toBusinessRuleTask().getBusinessRuleName());
                attributes.add(bpmnAttr);
                bpmnAttr = new BpmnAttribute("AT_CATALOG", act.toBusinessRuleTask().getFunctionName());
                attributes.add(bpmnAttr);
            }
            if (act.isUserTask()) {
                bpmnAttr = new BpmnAttribute("TaskType", "User");
                attributes.add(bpmnAttr);
                bpmnAttr = new BpmnAttribute("Priority", String.valueOf(act.toUserTask().getPriority()));
                attributes.add(bpmnAttr);
                String title = act.toUserTask().getSubject() != null ? act.toUserTask().getSubject().getExpressionValue() : null;
                bpmnAttr = new BpmnAttribute("Title", title);
                attributes.add(bpmnAttr);
                String owner = act.toUserTask().getInitiator() != null ? act.toUserTask().getInitiator().getExpressionValue() : null;
                bpmnAttr = new BpmnAttribute("Owner", owner);
                attributes.add(bpmnAttr);
                if (act.toUserTask().getHumanTask() != null) {
                    HumanTask tsk = act.toUserTask().getHumanTask();
                    bpmnAttr = new BpmnAttribute("Payload", Arrays.toString(tsk.getArguments().toArray()));
                    bpmnAttr = new BpmnAttribute("HumanTaskName", tsk.getText());
                    attributes.add(bpmnAttr);
                }
                bpmnAttr = new BpmnAttribute("Pattern", null);
                attributes.add(bpmnAttr);
            }
            if (act.getBpmnType().equals((Object)BpmnType.SERVICE_TASK)) {
                bpmnAttr = new BpmnAttribute("TaskType", "Service");
                if (act.toServiceTask().getInputDataAssociationSet().getArgumentsContainer().getDeclarations().toArray().length > 0) {
                    bpmnAttr = new BpmnAttribute("InMessage", "in");
                    attributes.add(bpmnAttr);
                }
                if (act.toServiceTask().getOutputDataAssociationSet().getArgumentsContainer().getDeclarations().toArray().length > 0) {
                    bpmnAttr = new BpmnAttribute("OutMessage", "out");
                    attributes.add(bpmnAttr);
                }
            }
            if (act.getBpmnType().equals((Object)BpmnType.SEND_TASK)) {
                bpmnAttr = new BpmnAttribute("TaskType", "Send");
                attributes.add(bpmnAttr);
                if (act.toSendTask().getInputDataAssociationSet().getArgumentsContainer().getDeclarations().toArray().length > 0) {
                    bpmnAttr = new BpmnAttribute("InMessage", "in");
                    attributes.add(bpmnAttr);
                }
            }
            if (act.getBpmnType().equals((Object)BpmnType.RECEIVE_TASK)) {
                bpmnAttr = new BpmnAttribute("TaskType", "Receive");
                attributes.add(bpmnAttr);
                if (act.toReceiveTask().getOutputDataAssociationSet().getArgumentsContainer().getDeclarations().toArray().length > 0) {
                    bpmnAttr = new BpmnAttribute("OutMessage", "out");
                    attributes.add(bpmnAttr);
                }
                bpmnAttr = new BpmnAttribute("Instantiate", act.toReceiveTask().isInstantiate() ? "yes" : "no");
                attributes.add(bpmnAttr);
            }
        }
        if (this.node.isEvent() && !((Event)this.node.asAnyNode(Event.class)).getEventTriggerType().equals((Object)EventTriggerType.NONE) || this.node.isActivity() && (((Activity)this.node).isSendTask() || ((Activity)this.node).isReceiveTask() || ((Activity)this.node).isServiceTask())) {
            ParticipantEnabled participantEnabled = (ParticipantEnabled)this.node;
            if (this.node.isConversational() && participantEnabled.getParticipantRef() != null) {
                OperationReferenceImpl operationRef = new OperationReferenceImpl((Conversational)this.node.asAnyNode(Conversational.class));
                QName portType = null;
                try {
                    portType = operationRef.getPortType();
                }
                catch (Exception e) {
                    // empty catch block
                }
                ParticipantReference participantRef = participantEnabled.getParticipantRef();
                if (portType != null) {
                    bpmnAttr = new BpmnAttribute("Interface", participantRef.getId() + ":" + portType.getLocalPart());
                    attributes.add(bpmnAttr);
                }
                String operation = null;
                if (participantEnabled.getOperation() != null) {
                    operation = CatalogMemberUtils.getOperationNativeName((CatalogMember)participantEnabled.getOperation());
                }
                bpmnAttr = new BpmnAttribute("Operation", operation);
                attributes.add(bpmnAttr);
            }
        }
        return attributes;
    }

    public BpaBpelAttribute getAttribute(String type) {
        for (Object attribute : this.getAttributes()) {
            if (!((BpaBpelAttribute)attribute).getName(null).equals(type)) continue;
            return (BpaBpelAttribute)attribute;
        }
        return null;
    }

    public void setAttribute(String type, String value) {
        UserTask uTask;
        Activity act;
        if (type.equals("Id")) {
            this.node.setId(value);
        }
        if (type.equals("Name")) {
            this.node.setDefaultLabel(value);
        }
        if (type.equals("EventType")) {
            Event evt = (Event)this.node.asAnyNode(Event.class);
            evt.setEventTriggerType(EventTriggerType.valueOf((String)value));
        }
        if (type.equals("Operation")) {
            SendTask stask;
            if (this.node.isActivity() && (act = (Activity)this.node.asAnyNode(Activity.class)) instanceof SendTask) {
                stask = act.toSendTask();
                stask.setOperationName(value);
            }
            if (this.node.isActivity() && (act = (Activity)this.node.asAnyNode(Activity.class)) instanceof ReceiveTask) {
                stask = act.toReceiveTask();
                stask.setOperationName(value);
            }
        }
        if (type.equals("Instantiate") && this.node.isActivity() && (act = (Activity)this.node.asAnyNode(Activity.class)) instanceof ReceiveTask) {
            ReceiveTask rtask = act.toReceiveTask();
            if (value.equalsIgnoreCase("true")) {
                rtask.setInstantiate(true);
            } else {
                rtask.setInstantiate(false);
            }
        }
        if (type.equals("Priority") && this.node.isActivity() && (act = (Activity)this.node.asAnyNode(Activity.class)).isUserTask()) {
            uTask = act.toUserTask();
            int priority = Integer.valueOf(value);
            Expression priorityExpression = ExpressionHelper.createNumericExpression((Integer)priority);
            uTask.setPriority(priorityExpression);
        }
        if (type.equals("Owner") && this.node.isActivity() && (act = (Activity)this.node.asAnyNode(Activity.class)).isUserTask()) {
            uTask = act.toUserTask();
            Expression initiatorExpression = ExpressionHelper.createTextExpression((String)value);
            uTask.setInitiator(initiatorExpression);
        }
        if (type.equals("Title") && this.node.isActivity() && (act = (Activity)this.node.asAnyNode(Activity.class)).isUserTask()) {
            uTask = act.toUserTask();
            Expression titleExpression = ExpressionHelper.createTextExpression((String)value);
            uTask.setSubject(titleExpression);
        }
    }

    public boolean isSubprocessScope() {
        return this.subpScope;
    }

    public boolean isSubprocess() {
        return this.indepSubp;
    }

    public void setSubprocess() {
        this.indepSubp = true;
    }

    public Node getNode() {
        return null;
    }
}

