/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpa.export.bpmn.impl;

import java.util.ArrayList;
import java.util.List;
import oracle.bpa.export.pluginwrapper.BpaBpelAttribute;
import oracle.bpa.export.pluginwrapper.BpaBpelConnection;
import oracle.bpa.export.pluginwrapper.BpaBpelObject;
import oracle.bpm.bpa.bpmn.util.BoundaryFinder;
import oracle.bpm.bpa.bpmn.util.Graph;
import oracle.bpm.bpa.export.bpmn.impl.BpmnAttribute;
import oracle.bpm.bpa.export.bpmn.impl.BpmnObject;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.project.model.processes.ConditionalFlow;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;

public class BpmnConnection
implements BpaBpelConnection {
    String conditionExpression = null;
    String connectionId = null;
    String connectionType = "Sequence Flow";
    boolean hasOutcome = false;
    String lastUpdateDate;
    BoundaryFinder processBoundaryFinder;
    Graph processGraph;
    SequenceFlow sequenceFlow;

    public BpmnConnection(SequenceFlow sequenceFlow, Graph graph, BoundaryFinder boundaryFinder) {
        this.sequenceFlow = sequenceFlow;
        this.processGraph = graph;
        this.processBoundaryFinder = boundaryFinder;
    }

    public BpaBpelObject getSourceObject() {
        FlowNode flowNode = this.sequenceFlow.getSource();
        return new BpmnObject(flowNode, this.processGraph, this.processBoundaryFinder);
    }

    public BpaBpelObject getTargetObject() {
        FlowNode flowNode = this.sequenceFlow.getTarget();
        return new BpmnObject(flowNode, this.processGraph, this.processBoundaryFinder);
    }

    public String getConnectionIdentifier() {
        return this.connectionId;
    }

    public boolean isOutcomeAssociated() {
        return this.hasOutcome;
    }

    public String getUpdateDate() {
        return this.lastUpdateDate;
    }

    public void setUpdateDate(String date) {
        this.lastUpdateDate = date;
    }

    public String getType() {
        return this.connectionType;
    }

    public void setType(String type) {
        this.connectionType = type;
    }

    public String getConditionExpr() {
        return this.conditionExpression;
    }

    public void setConditionExpr(String condition) {
        this.conditionExpression = condition;
    }

    public List getAttributes() {
        ConditionalFlow cFlow;
        BpmnAttribute bpmnAttr;
        BpmnAttribute bpmnAttr2;
        ArrayList<BpmnAttribute> attributes = new ArrayList<BpmnAttribute>();
        if (this.sequenceFlow.getId() != null) {
            bpmnAttr2 = new BpmnAttribute("Id", this.sequenceFlow.getId());
            attributes.add(bpmnAttr2);
        }
        if (this.sequenceFlow.getDefaultDescription() != null) {
            bpmnAttr2 = new BpmnAttribute("Description", this.sequenceFlow.getDefaultDescription());
            attributes.add(bpmnAttr2);
        }
        if (this.sequenceFlow.getSource() != null) {
            String sourceId = this.sequenceFlow.getSource().getId();
            bpmnAttr = new BpmnAttribute("Source", sourceId);
            attributes.add(bpmnAttr);
        }
        if (this.sequenceFlow.getTarget() != null) {
            String targetId = this.sequenceFlow.getTarget().getId();
            bpmnAttr = new BpmnAttribute("Target", targetId);
            attributes.add(bpmnAttr);
        }
        if (this.sequenceFlow.isConditionalFlow() && (cFlow = this.sequenceFlow.toConditionalFlow()).getCondition() != null) {
            bpmnAttr = new BpmnAttribute("Condition", cFlow.getCondition().getExpressionValue().replaceAll("bpmn:getDataObject", "bpws:getVariableData"));
            attributes.add(bpmnAttr);
        }
        return attributes;
    }

    public BpaBpelAttribute getAttribute(String type) {
        ConditionalFlow cFlow;
        if (type.equals("Id") && this.sequenceFlow.getId() != null) {
            BpmnAttribute bpmnAttr = new BpmnAttribute("Id", this.sequenceFlow.getId());
            return bpmnAttr;
        }
        if (type.equals("Description") && this.sequenceFlow.getDefaultDescription() != null) {
            BpmnAttribute bpmnAttr = new BpmnAttribute("Description", this.sequenceFlow.getDefaultDescription());
            return bpmnAttr;
        }
        if (type.equals("Source") && this.sequenceFlow.getSource() != null) {
            String sourceId = this.sequenceFlow.getSource().getId();
            BpmnAttribute bpmnAttr = new BpmnAttribute("Source", sourceId);
            return bpmnAttr;
        }
        if (type.equals("Target") && this.sequenceFlow.getTarget() != null) {
            String targetId = this.sequenceFlow.getTarget().getId();
            BpmnAttribute bpmnAttr = new BpmnAttribute("Target", targetId);
            return bpmnAttr;
        }
        if (type.equals("Condition") && this.sequenceFlow.isConditionalFlow() && (cFlow = this.sequenceFlow.toConditionalFlow()).getCondition() != null) {
            BpmnAttribute bpmnAttr = new BpmnAttribute("Condition", cFlow.getCondition().getExpressionValue().replaceAll("bpmn:getDataObject", "bpws:getVariableData"));
            return bpmnAttr;
        }
        return null;
    }

    public void setAttribute(String type, String value) {
        if (type.equals("Id")) {
            this.sequenceFlow.setId(value);
        }
        if (type.equals("Source")) {
            this.sequenceFlow.setSource(this.processGraph.getNode(value));
        }
        if (type.equals("Target")) {
            this.sequenceFlow.setTarget(this.processGraph.getNode(value));
        }
        if (type.equals("Condition")) {
            ConditionalFlow cFlow = this.sequenceFlow.toConditionalFlow();
            cFlow.setCondition((Expression)new XPathExpression(value));
        }
    }

    public void setOutcomeAssociated() {
        this.hasOutcome = true;
    }

    public void setConnectionIdentifier(String connId) {
        this.connectionId = connId;
    }
}

