/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpa.export.bpmn.impl;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import oracle.bpa.common.context.BpaContext;
import oracle.bpa.common.exception.BpaException;
import oracle.bpa.common.log.BpaDiagnosticService;
import oracle.bpa.common.log.iface.IBpaLogger;
import oracle.bpa.export.exportimpl.data.SCAExportState;
import oracle.bpa.export.pluginwrapper.BpaBpelExportAction;
import oracle.bpa.export.util.BpelExportStateUtil;
import oracle.bpa.util.xmlwrapper.XMLWrapper;
import oracle.bpm.bpa.export.bpmn.iface.IBpelExport;
import oracle.bpm.bpa.export.bpmn.iface.IBpelExportAction;
import oracle.bpm.bpa.export.bpmn.iface.IBpelProcessExport;
import oracle.bpm.bpa.export.bpmn.impl.BpelExportActionImpl;
import oracle.bpm.bpa.export.bpmn.impl.BpelProcessExportImpl;
import oracle.bpm.bpa.util.ResourceResolver;
import oracle.bpm.bpa.util.xmlwrapper.XMLWrapperImpl;
import oracle.bpm.project.model.processes.Process;
import org.w3c.dom.Document;

public class BpelExportImpl
implements IBpelExport {
    BpaContext bpaContext;
    IBpelExportAction bpelExportAction;
    BpelExportStateUtil exportStateUtil;
    Map processDetails;
    SCAExportState state;
    XMLWrapper xmlWrapper;

    @Override
    public void exportStarting(String name, Document document, IBpaLogger logger, Level level, BpaContext context) throws BpaException {
        this.processDetails = new HashMap();
        this.bpelExportAction = new BpelExportActionImpl();
        this.exportStateUtil = new BpelExportStateUtil();
        BpaDiagnosticService.setLogger((int)4, (Level)level, (IBpaLogger)logger);
        BpaDiagnosticService.setLogger((int)1, (Level)level, (IBpaLogger)logger);
        BpaDiagnosticService.setLogger((int)0, (Level)level, (IBpaLogger)logger);
        BpaDiagnosticService.log((int)4, (Level)BpaDiagnosticService.INFORMATION, (String)"Oracle BPEL Export of BPMN Process started...");
        this.bpaContext = context;
        InputStream inpStream = new ResourceResolver().getResource("oracle/bpa/export/bpmn/config/bpm_config.xml");
        if (inpStream == null) {
            System.out.println("config is null");
        }
        this.xmlWrapper = XMLWrapperImpl.getInstance(this.bpaContext);
        this.xmlWrapper.parseConfigFile(inpStream);
        this.exportStateUtil.initializeSCAExport(this.xmlWrapper, Locale.US);
        this.exportStateUtil.createInitialState(name);
    }

    @Override
    public IBpelExportAction exportFinished() {
        this.exportStateUtil.serializeState((BpaBpelExportAction)((BpelExportActionImpl)this.bpelExportAction));
        BpaDiagnosticService.log((int)4, (Level)BpaDiagnosticService.INFORMATION, (String)"Oracle BPEL Export of BPMN Process finished...");
        return this.bpelExportAction;
    }

    @Override
    public IBpelProcessExport getProcessExport(Process process, Document document) {
        String processName = process.getLabel(this.bpaContext.getLocale());
        String processId = process.getId();
        this.state = this.exportStateUtil.getExportState();
        if (!this.processDetails.containsKey(processId)) {
            int processNameCounter = 1;
            for (String pName : this.processDetails.values()) {
                if (!pName.equals(processName)) continue;
                ++processNameCounter;
            }
            if (processNameCounter != 1) {
                String newProcessName = processName + "_" + processNameCounter;
                process.setDefaultLabel(newProcessName);
            }
            this.processDetails.put(processId, processName);
            return new BpelProcessExportImpl(process, document, this.xmlWrapper, (BpelExportActionImpl)this.bpelExportAction, this.state, this.bpaContext);
        }
        return null;
    }
}

