/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpa.bpmn.util;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import oracle.bpa.common.log.BpaDiagnosticService;
import oracle.bpm.bpa.bpmn.util.Graph;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.SequenceFlow;

public class BackedgeFinder {
    private Decoration decoration;
    private Graph graph;
    private Set<FlowNode> white;
    private Set<FlowNode> grey;

    public Object parse(NodeContainer process) throws Exception {
        this.graph = new Graph();
        this.graph.parse(process);
        this.decoration = new Decoration();
        this.white = new HashSet<FlowNode>();
        this.grey = new HashSet<FlowNode>();
        Set<FlowNode> nodes = this.graph.getNodes();
        for (FlowNode node : nodes) {
            this.white.add(node);
        }
        FlowNode start = this.graph.getStart();
        this.mark(start);
        return this.decoration;
    }

    public boolean isBackEdge(SequenceFlow sequenceFlow) {
        return this.decoration.back.contains(sequenceFlow);
    }

    public String toString() {
        return this.decoration.back.toString();
    }

    void remove(SequenceFlow sequenceFlow) {
        this.decoration.back.remove(sequenceFlow);
    }

    private void mark(FlowNode node) {
        this.white.remove(node);
        this.grey.add(node);
        for (SequenceFlow sequenceFlow : this.graph.getOutgoingSequenceFlows(node)) {
            FlowNode target = this.graph.getNode(sequenceFlow.getTarget().getId());
            if (this.grey.contains(target)) {
                this.decoration.back.add(sequenceFlow);
            }
            if (!this.white.contains(target)) continue;
            this.mark(target);
        }
        this.grey.remove(node);
    }

    private void log(String message) {
        BpaDiagnosticService.log((int)5, (Level)BpaDiagnosticService.DEBUG, (String)message);
    }

    private class Decoration {
        public Set<SequenceFlow> back = new HashSet<SequenceFlow>();
    }
}

