/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpa.bpmn.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpa.bpmn.model.Connection;
import oracle.bpa.bpmn.model.ICollection;
import oracle.bpa.bpmn.model.Node;
import oracle.bpa.bpmn.util.AbstractGraph;
import oracle.bpa.writer.WriterUtil;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;

public class BPMNGraph
extends AbstractGraph {
    private Map<Node, FlowNode> bpaBpmNodesCache = new HashMap<Node, FlowNode>();
    private Map<String, Node> bpaNodesCache = new HashMap<String, Node>();
    private Map<String, FlowNode> bpmNodesCache = new HashMap<String, FlowNode>();
    private Sequence<EndEvent> endEvents;
    private FlowNode startEvent;

    public BPMNGraph(ICollection bpaProcess, NodeContainer bpmProcess) {
        this();
        this.setBpaProcess(bpaProcess);
        this.setBpmProcess(bpmProcess);
    }

    BPMNGraph() {
    }

    public void parse(ICollection bpaProcess) {
        this.setBpaProcess(bpaProcess);
        this.populateBpaBpmModelCache();
    }

    public void parse(NodeContainer bpmProcess) {
        this.setBpmProcess(bpmProcess);
        this.populateBpaBpmModelCache();
    }

    public void parse() {
        if (this.getBpaProcess() != null && this.getBpmProcess() != null) {
            this.populateBpaBpmModelCache();
        }
    }

    public Set<Connection> getIncomingConnections(Node node) {
        FlowNode flowNode = this.bpaBpmNodesCache.get(node);
        if (flowNode == null) {
            return this.getEmptySet();
        }
        HashSet<Connection> connectionSet = new HashSet<Connection>();
        Sequence inComingGoingSequenceFlows = flowNode.getIncomingSequenceFlows();
        for (SequenceFlow sequenceNode : inComingGoingSequenceFlows) {
            FlowNode sourceNode = sequenceNode.getSource();
            FlowNode targetNode = sequenceNode.getTarget();
            Connection connection = new Connection(this.getBpaNodeFromBpmNode(sourceNode), this.getBpaNodeFromBpmNode(targetNode));
            connectionSet.add(connection);
        }
        return connectionSet;
    }

    public Set<Connection> getOutgoingConnections(Node node) {
        FlowNode flowNode = this.bpaBpmNodesCache.get(node);
        if (flowNode == null) {
            return this.getEmptySet();
        }
        HashSet<Connection> connectionSet = new HashSet<Connection>();
        Sequence outGoingSequenceFlows = flowNode.getOutgoingSequenceFlows();
        for (SequenceFlow sequenceNode : outGoingSequenceFlows) {
            FlowNode sourceNode = sequenceNode.getSource();
            FlowNode targetNode = sequenceNode.getTarget();
            Connection connection = new Connection(this.getBpaNodeFromBpmNode(sourceNode), this.getBpaNodeFromBpmNode(targetNode));
            connectionSet.add(connection);
        }
        return connectionSet;
    }

    public Set<Node> getNodes() {
        return this.bpaBpmNodesCache.keySet();
    }

    public Node getNode(String id) {
        return this.bpaNodesCache.get(id);
    }

    public Node getStart() {
        Node node = null;
        if (this.startEvent == null) {
            this.startEvent = ModelUtils.getStartFlowNode((NodeContainer)this.getBpmProcess());
        }
        if (this.startEvent != null) {
            node = this.bpaNodesCache.get(this.startEvent.getId());
        }
        return node;
    }

    public Node getEnd() {
        Node end = null;
        return end;
    }

    public boolean isEnd(Node node) {
        FlowNode cachedNode = this.bpaBpmNodesCache.get(node);
        if (this.endEvents == null) {
            this.endEvents = this.getBpmProcess().getEvents(EndEvent.class);
        }
        for (FlowNode flowNode : this.endEvents) {
            if (!flowNode.equals(cachedNode)) continue;
            return true;
        }
        return false;
    }

    public boolean isStart(Node node) {
        FlowNode cachedNode = this.bpaBpmNodesCache.get(node);
        if (this.startEvent == null) {
            this.startEvent = ModelUtils.getStartFlowNode((NodeContainer)this.getBpmProcess());
        }
        return this.startEvent.equals(cachedNode);
    }

    private void populateBpaBpmModelCache() {
        try {
            if (this.getBpaProcess() == null) {
                throw new Exception("BPA process is not associated with Graph");
            }
            if (this.getBpmProcess() == null) {
                throw new Exception("BPM process is not associated with Graph");
            }
            WriterUtil.populateBpaNodeCache((ICollection)this.getBpaProcess(), this.bpaNodesCache);
            for (Object bpmNode : this.getBpmProcess().getChildren()) {
                if (!(bpmNode instanceof FlowNode)) continue;
                this.bpmNodesCache.put(((FlowNode)bpmNode).getId(), (FlowNode)bpmNode);
            }
            List bpaProcessNodes = this.getBpaProcess().getObjects();
            for (int count = 0; count < bpaProcessNodes.size(); ++count) {
                Node activityNode = (Node)bpaProcessNodes.get(count);
                this.bpaBpmNodesCache.put(activityNode, this.bpmNodesCache.get(WriterUtil.convertToValidBpmId((String)activityNode.getObjectId())));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Node getBpaNodeFromBpmNode(FlowNode flowNode) {
        String objectId = flowNode.getId();
        Node bpaNode = this.bpaNodesCache.get(objectId);
        if (bpaNode == null) {
            try {
                throw new Exception("No BPA found for the objectId - " + objectId);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return bpaNode;
    }
}

