/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.common.model.impl.io;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.SortedSet;
import java.util.TreeSet;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.impl.io.transformation.Transformation;
import oracle.bpm.common.model.impl.io.transformation.TransformationManager;
import oracle.bpm.common.model.io.PersistenceManager;
import oracle.bpm.io.StreamUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPersistenceManager<E extends Entity>
implements PersistenceManager<E> {
    private TransformationManager transformationManager;

    @Nullable
    public abstract Integer getFileVersion(@NotNull InputStream var1) throws IOException;

    @NotNull
    public abstract Integer getCurrentFileVersion();

    @Override
    public final E load(@NotNull InputStream stream) throws IOException {
        E e;
        try {
            byte[] bytes = StreamUtils.readBytes((InputStream)stream);
            ByteArrayInputStream streamForVersion = new ByteArrayInputStream(bytes);
            Integer fileVersion = this.getFileVersion(streamForVersion);
            Integer currentVersion = this.getCurrentFileVersion();
            InputStream streamToLoad = new ByteArrayInputStream(bytes);
            if (fileVersion == null || currentVersion < fileVersion) {
                streamToLoad = this.getTransformationManager().transform(streamToLoad, fileVersion, currentVersion);
            }
            e = this.loadMigrated(streamToLoad, fileVersion, currentVersion);
        }
        catch (Exception e2) {
            try {
                throw new IOException(e2);
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{stream});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{stream});
        return e;
    }

    protected abstract E loadMigrated(@NotNull InputStream var1, @Nullable Integer var2, @NotNull Integer var3) throws IOException;

    protected SortedSet<Transformation> createTransformationsSet() {
        return new TreeSet<Transformation>();
    }

    private TransformationManager getTransformationManager() {
        if (this.transformationManager == null) {
            SortedSet<Transformation> transformations = this.createTransformationsSet();
            this.transformationManager = new TransformationManager(transformations);
        }
        return this.transformationManager;
    }
}

