/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.common.model.impl.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.attributes.Attr;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.common.model.events.EventListener;
import oracle.bpm.common.model.events.EventManager;
import oracle.bpm.common.model.impl.TransactionManager;

public class EventManagerImpl
implements EventManager {
    private List<Event> eventBuffer = new ArrayList<Event>();
    private Map<EventListener, EventFilterPolicy> listeners = new HashMap<EventListener, EventFilterPolicy>();

    @Override
    public void addListener(EventListener listener, Attr<?> ... attributes) {
        if (!this.listeners.containsKey(listener)) {
            this.listeners.put(listener, new EventFilterPolicy());
        }
        this.listeners.get(listener).processAddFilter(attributes);
    }

    @Override
    public void removeListener(EventListener listener, Attr<?> ... attributes) {
        if (this.listeners.containsKey(listener)) {
            if (attributes.length == 0) {
                this.listeners.remove(listener);
            } else {
                this.listeners.get(listener).processRemoveFilter(attributes);
            }
        }
    }

    public void notifyEventToListeners(Event event) {
        Entity sourceObject = this.getSourceObject(event);
        if (!TransactionManager.getInstance().isUnderCommit(sourceObject)) {
            this.throwEvents(Arrays.asList(event));
        } else {
            TransactionManager.getInstance().markAsEventBuffer(sourceObject, this);
            this.eventBuffer.add(event);
        }
    }

    public synchronized void releaseEvents() {
        this.throwEvents(this.eventBuffer);
        this.eventBuffer.clear();
    }

    private Entity getSourceObject(Event event) {
        if (event.getChildEvent() == null) {
            return event.getObject();
        }
        return this.getSourceObject(event.getChildEvent());
    }

    private void throwEvents(List<Event> events) {
        for (EventListener listener : this.listeners.keySet()) {
            ArrayList<Event> filteredEvents = new ArrayList<Event>();
            EventFilterPolicy policy = this.listeners.get(listener);
            for (Event event : events) {
                if (!policy.isValid(event.getAttr())) continue;
                filteredEvents.add(event);
            }
            if (filteredEvents.isEmpty()) continue;
            listener.onEvent(filteredEvents.toArray(new Event[0]));
        }
    }

    private static class EventFilterPolicy {
        private Set<Attr<?>> featuresToExclude = new HashSet();
        private Set<Attr<?>> featuresToInclude = new HashSet();
        private boolean includeAll = false;

        private EventFilterPolicy() {
        }

        public void processAddFilter(Attr<?> ... attributes) {
            if (attributes.length == 0) {
                this.featuresToExclude.clear();
                this.featuresToInclude.clear();
                this.includeAll = true;
            } else {
                this.featuresToExclude.removeAll(Arrays.asList(attributes));
                if (!this.includeAll) {
                    this.featuresToInclude.addAll(Arrays.asList(attributes));
                }
            }
        }

        public void processRemoveFilter(Attr<?> ... attributes) {
            if (attributes.length == 0) {
                this.featuresToExclude.clear();
                this.featuresToInclude.clear();
                this.includeAll = false;
            } else {
                this.featuresToExclude.addAll(Arrays.asList(attributes));
                this.featuresToInclude.removeAll(Arrays.asList(attributes));
            }
        }

        public boolean isValid(Attr<?> attr) {
            return this.includeAll && !this.featuresToExclude.contains(attr) || this.featuresToInclude.contains(attr);
        }
    }
}

