/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.common.model.impl.events;

import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.attributes.Attr;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.common.model.events.EventType;

public class EventImpl
implements Event {
    private Attr<?> attr;
    private Event childEvent;
    private EventType eventType;
    private Object newValue;
    private Entity object;
    private Object oldValue;

    public EventImpl(EventType eventType, Entity object, Attr<?> attr, Object oldValue, Object newValue) {
        this(eventType, object, attr, oldValue, newValue, null);
    }

    public EventImpl(EventType eventType, Entity object, Attr<?> attr, Object oldValue, Object newValue, Event childEvent) {
        this.eventType = eventType;
        this.object = object;
        this.attr = attr;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.childEvent = childEvent;
    }

    @Override
    public Event getChildEvent() {
        return this.childEvent;
    }

    @Override
    public Entity getObject() {
        return this.object;
    }

    @Override
    public EventType getType() {
        return this.eventType;
    }

    @Override
    public Attr<?> getAttr() {
        return this.attr;
    }

    @Override
    public Object getOldValue() {
        return this.oldValue;
    }

    @Override
    public Object getNewValue() {
        return this.newValue;
    }

    @Override
    public boolean equals(Event event) {
        return this.getType().equals((Object)event.getType()) && this.getAttr().equals(event.getAttr()) && this.getObject().equals(event.getObject()) && (this.getOldValue() == event.getOldValue() || this.getOldValue() != null && this.getOldValue().equals(event.getOldValue())) && (this.getNewValue() == event.getNewValue() || this.getNewValue() != null && this.getNewValue().equals(event.getNewValue())) && (this.getChildEvent() == event.getChildEvent() || this.getChildEvent() != null && this.getChildEvent().equals(event.getChildEvent()));
    }

    @Override
    public boolean containsObject(Entity object) {
        return this.getObject().equals(object) || this.getChildEvent() != null && this.getChildEvent().containsObject(object);
    }

    @Override
    public Event clone() {
        return new EventImpl(this.eventType, this.object, this.attr, this.oldValue, this.newValue, this.getChildEvent());
    }
}

