/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.common.model.impl.diff;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.common.model.attributes.Attr;
import oracle.bpm.common.model.diff.DiffNode;
import oracle.bpm.common.model.diff.DiffType;

public class DiffNodeImpl
implements DiffNode {
    private Attr<?> attribute;
    private List<DiffNode> featureDiffs;
    private Object sourceObject;
    private Object targetObject;

    public DiffNodeImpl(Object sourceObject, Object targetObject) {
        this(sourceObject, targetObject, new ArrayList<DiffNode>());
    }

    public DiffNodeImpl(Object sourceObject, Object targetObject, List<DiffNode> featureDiffs) {
        this.sourceObject = sourceObject;
        this.targetObject = targetObject;
        this.featureDiffs = featureDiffs;
    }

    public void setAttribute(Attr<?> attribute) {
        this.attribute = attribute;
    }

    @Override
    public DiffType getType() {
        if (this.sourceObject != null && this.targetObject == null) {
            return DiffType.ONLY_IN_SOURCE;
        }
        if (this.targetObject != null && this.sourceObject == null) {
            return DiffType.ONLY_IN_TARGET;
        }
        return DiffType.CHANGED;
    }

    @Override
    public Attr<?> getAttribute() {
        return this.attribute;
    }

    @Override
    public Object getSourceObject() {
        return this.sourceObject;
    }

    @Override
    public Object getTargetObject() {
        return this.targetObject;
    }

    @Override
    public List<DiffNode> getChildDiffs() {
        return this.featureDiffs;
    }
}

