/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.common.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.MetadataFactory;
import oracle.bpm.common.model.attributes.Attr;
import oracle.bpm.common.model.attributes.AttrType;
import oracle.bpm.common.model.attributes.ContentType;
import oracle.bpm.common.model.diff.DiffNode;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.common.model.events.EventType;
import oracle.bpm.common.model.impl.EntityImpl;
import oracle.bpm.common.model.impl.TransactionManager;
import oracle.bpm.common.model.impl.diff.DiffNodeImpl;
import oracle.bpm.common.model.impl.diff.DiffResult;
import oracle.bpm.common.model.impl.events.EventImpl;
import oracle.bpm.common.model.impl.wrappers.collections.ListEntity;

public class ModelListCollection<E>
extends EntityImpl
implements List<E> {
    private AttrType attrType;
    private static final Attr<ListEntity> INTERNAL_ATTRIBUTE = new InternalAttr();

    public ModelListCollection() {
        super.setAttr(INTERNAL_ATTRIBUTE, new ListEntity(new ArrayList<EntityImpl>()));
    }

    public void setAttrType(AttrType type) {
        this.attrType = type;
    }

    @Override
    public int size() {
        return this.getCollection().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getCollection().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.getRightCollection().contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.getRightCollection().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getRightCollection().toArray();
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        return this.getRightCollection().containsAll(objects);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getRightCollection().toArray(a);
    }

    @Override
    public int indexOf(Object o) {
        return this.getRightCollection().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getRightCollection().lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.getRightCollection().listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int i) {
        return this.getRightCollection().listIterator(i);
    }

    @Override
    public List<E> subList(int i, int i1) {
        return this.getRightCollection().subList(i, i1);
    }

    @Override
    public E get(int i) {
        return this.getRightCollection().get(i);
    }

    @Override
    public boolean add(E e) {
        boolean result;
        EntityImpl value = this.getModelObject(e);
        if (TransactionManager.getInstance().isInTransaction(this)) {
            if (!TransactionManager.getInstance().isChangedObject(this)) {
                super.setAttr(INTERNAL_ATTRIBUTE, new ListEntity((ArrayList)this.getCollection().clone()));
            }
            result = this.getCollection().add(value);
        } else {
            result = this.getCollection().add(value);
            if (result && this.parentObject != null) {
                this.parentObject.notifyChange(new EventImpl(EventType.ATTR_ADDED, this, MetadataFactory.collectionKeyAttr(this.getCollection().indexOf(value)), null, e));
            }
        }
        if (this.attrType.equals((Object)AttrType.VALUE)) {
            value.setParent(this);
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        EntityImpl realObject = this.getModelObject(o);
        if (TransactionManager.getInstance().isInTransaction(this)) {
            if (!TransactionManager.getInstance().isChangedObject(this)) {
                super.setAttr(INTERNAL_ATTRIBUTE, new ListEntity((ArrayList)this.getCollection().clone()));
            }
            return this.getCollection().remove(realObject);
        }
        int pos = this.getCollection().indexOf(realObject);
        boolean result = this.getCollection().remove(realObject);
        if (result && this.parentObject != null) {
            this.parentObject.notifyChange(new EventImpl(EventType.ATTR_REMOVED, this, MetadataFactory.collectionKeyAttr(pos), o, null));
        }
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends E> es) {
        boolean result = true;
        for (E value : es) {
            result = result && this.add(value);
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        boolean result = true;
        for (Object value : objects) {
            result = result && this.remove(value);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        ArrayList<E> toRemove = new ArrayList<E>();
        for (E value : this.getRightCollection()) {
            if (objects.contains(value)) continue;
            toRemove.add(value);
        }
        return this.removeAll(toRemove);
    }

    @Override
    public void clear() {
        ArrayList<EntityImpl> values = new ArrayList<EntityImpl>();
        values.addAll(this.getCollection());
        for (Entity entity : values) {
            this.remove(entity);
        }
    }

    @Override
    public void add(int i, E e) {
        EntityImpl value = this.getModelObject(e);
        if (this.attrType.equals((Object)AttrType.VALUE)) {
            value.setParent(this);
        }
        if (TransactionManager.getInstance().isInTransaction(this)) {
            if (!TransactionManager.getInstance().isChangedObject(this)) {
                super.setAttr(INTERNAL_ATTRIBUTE, new ListEntity((ArrayList)this.getCollection().clone()));
            }
            this.getCollection().add(i, value);
        } else {
            boolean result = this.getCollection().add(value);
            if (result && this.parentObject != null) {
                this.parentObject.notifyChange(new EventImpl(EventType.ATTR_ADDED, this, MetadataFactory.collectionKeyAttr(this.getCollection().indexOf(value)), null, e));
            }
        }
    }

    @Override
    public boolean addAll(int i, Collection<? extends E> es) {
        for (E value : es) {
            this.add(i++, value);
        }
        return true;
    }

    @Override
    public E remove(int i) {
        E realObject = this.get(i);
        if (realObject != null) {
            EntityImpl modelObject = this.getModelObject(realObject);
            if (TransactionManager.getInstance().isInTransaction(this)) {
                if (!TransactionManager.getInstance().isChangedObject(this)) {
                    super.setAttr(INTERNAL_ATTRIBUTE, new ListEntity((ArrayList)this.getCollection().clone()));
                }
                this.getCollection().remove(modelObject);
            } else {
                int pos = this.getCollection().indexOf(modelObject);
                boolean result = this.getCollection().remove(modelObject);
                if (result && this.parentObject != null) {
                    this.parentObject.notifyChange(new EventImpl(EventType.ATTR_REMOVED, this, MetadataFactory.collectionKeyAttr(pos), realObject, null));
                }
            }
        }
        return realObject;
    }

    @Override
    public E set(int i, E e) {
        E oldValue = this.get(i);
        EntityImpl value = this.getModelObject(e);
        if (this.attrType.equals((Object)AttrType.VALUE)) {
            value.setParent(this);
        }
        if (TransactionManager.getInstance().isInTransaction(this)) {
            if (!TransactionManager.getInstance().isChangedObject(this)) {
                super.setAttr(INTERNAL_ATTRIBUTE, new ListEntity((ArrayList)this.getCollection().clone()));
            }
            this.getCollection().set(i, value);
        } else {
            this.getCollection().set(i, value);
            this.parentObject.notifyChange(new EventImpl(EventType.ATTR_CHANGED, this, MetadataFactory.collectionKeyAttr(this.getCollection().indexOf(value)), oldValue, e));
        }
        return oldValue;
    }

    @Override
    protected <E> void setAttr(Attr<E> attr, E value) {
        if (attr.equals(INTERNAL_ATTRIBUTE)) {
            EntityImpl oldValue;
            int i;
            ArrayList<EntityImpl> localList = this.getCollection();
            if (localList == null) {
                localList = new ArrayList();
            }
            ArrayList<EntityImpl> newList = ((ListEntity)value).getValue();
            int commonCount = Math.min(localList.size(), newList.size());
            for (i = 0; i < commonCount; ++i) {
                if (localList.get(i).equals(newList.get(i))) continue;
                oldValue = localList.get(i);
                EntityImpl newValue = newList.get(i);
                newValue.setParent(this);
                localList.set(i, newValue);
                this.parentObject.notifyChange(new EventImpl(EventType.ATTR_CHANGED, this, MetadataFactory.collectionKeyAttr(i), this.getRealObject(oldValue), this.getRealObject(newValue)));
            }
            for (i = localList.size() - 1; i >= commonCount; --i) {
                oldValue = localList.get(i);
                localList.remove(i);
                this.parentObject.notifyChange(new EventImpl(EventType.ATTR_REMOVED, this, MetadataFactory.collectionKeyAttr(i), this.getRealObject(oldValue), null));
            }
            for (i = commonCount; i < newList.size(); ++i) {
                EntityImpl newValue = newList.get(i);
                newValue.setParent(this);
                localList.add(newValue);
                this.parentObject.notifyChange(new EventImpl(EventType.ATTR_ADDED, this, MetadataFactory.collectionKeyAttr(i), null, this.getRealObject(newValue)));
            }
        }
    }

    @Override
    protected DiffNodeImpl getDiff(Entity externalObject, List<DiffResult> alreadyProcessed) {
        DiffNodeImpl diff;
        int pos;
        ArrayList<DiffNode> featuresDiffs = new ArrayList<DiffNode>();
        ModelListCollection external = (ModelListCollection)externalObject;
        alreadyProcessed.add(new DiffResult(this, external));
        int objectsToCompare = this.getCollection().size() != external.size() ? Math.min(this.getCollection().size(), external.size()) : this.getCollection().size();
        for (pos = 0; pos < objectsToCompare; ++pos) {
            DiffNodeImpl childDiff;
            Entity externalFeature;
            EntityImpl localFeature = this.getCollection().get(pos);
            if (alreadyProcessed.contains(new DiffResult(localFeature, externalFeature = (Entity)external.getCollection().get(pos))) || (childDiff = localFeature.getDiff(externalFeature, alreadyProcessed)) == null) continue;
            childDiff.setAttribute(MetadataFactory.collectionKeyAttr(pos));
            featuresDiffs.add(childDiff);
        }
        if (objectsToCompare < this.getCollection().size()) {
            for (pos = objectsToCompare; pos < this.getCollection().size(); ++pos) {
                diff = new DiffNodeImpl(this.getRealObject(this.getCollection().get(pos)), null);
                diff.setAttribute(MetadataFactory.collectionKeyAttr(pos));
                featuresDiffs.add(diff);
            }
        }
        if (objectsToCompare < external.size()) {
            for (pos = objectsToCompare; pos < external.size(); ++pos) {
                diff = new DiffNodeImpl(null, this.getRealObject(external.getCollection().get(pos)));
                diff.setAttribute(MetadataFactory.collectionKeyAttr(pos));
                featuresDiffs.add(diff);
            }
        }
        if (!featuresDiffs.isEmpty()) {
            return new DiffNodeImpl(this, externalObject, featuresDiffs);
        }
        return null;
    }

    @Override
    protected EntityImpl clone(Map<Entity, EntityImpl> alreadyCloned) {
        ModelListCollection<E> result = new ModelListCollection<E>();
        alreadyCloned.put(this, result);
        for (EntityImpl object : this.getCollection()) {
            EntityImpl clone = !alreadyCloned.containsKey(object) ? object.clone(alreadyCloned) : alreadyCloned.get(object);
            if (this.attrType.equals((Object)AttrType.VALUE)) {
                clone.setParent(result);
            }
            super.getCollection().add(clone);
        }
        return result;
    }

    @Override
    void notifyChange(Event event) {
        Event clonedChild = event.clone();
        EntityImpl entity = (EntityImpl)event.getObject();
        int position = this.getCollection().indexOf(entity);
        EventImpl result = new EventImpl(EventType.ATTR_CHANGED, this, MetadataFactory.collectionKeyAttr(position), event.getObject(), event.getObject(), clonedChild);
        if (this.parentObject != null && this.attrType.equals((Object)AttrType.VALUE) && !event.containsObject(this)) {
            this.parentObject.notifyChange(result);
        }
        this.eventManager.notifyEventToListeners(result);
    }

    private ArrayList<EntityImpl> getCollection() {
        ListEntity list = this.getAttr(INTERNAL_ATTRIBUTE);
        if (list != null) {
            return list.getValue();
        }
        return null;
    }

    private ArrayList<E> getRightCollection() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (EntityImpl object : this.getCollection()) {
            result.add(this.getRealObject(object));
        }
        return result;
    }

    private static class InternalAttr
    implements Attr<ListEntity> {
        private static final String ATTR_NAME = "collections";

        private InternalAttr() {
        }

        @Override
        public String getId() {
            return ATTR_NAME;
        }

        @Override
        public AttrType getAttrType() {
            return AttrType.VALUE;
        }

        @Override
        public Class<ListEntity> getClassType() {
            return ListEntity.class;
        }

        @Override
        public ContentType getContentType() {
            return ContentType.OBJECT;
        }

        @Override
        public Object getDefaultValue() {
            return null;
        }
    }
}

