/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.langs.java;

import oracle.bpm.compiler.BaseCILSourceGenerator;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.Cast;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Declaration;
import oracle.bpm.compiler.DoBlock;
import oracle.bpm.compiler.Equality;
import oracle.bpm.compiler.Exit;
import oracle.bpm.compiler.For;
import oracle.bpm.compiler.ForEach;
import oracle.bpm.compiler.In;
import oracle.bpm.compiler.IncDecOperator;
import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.JavaFor;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.LoopStatement;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.On;
import oracle.bpm.compiler.OnExit;
import oracle.bpm.compiler.Range;
import oracle.bpm.compiler.Switch;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;

public class JavaCILSourceGenerator
extends BaseCILSourceGenerator {
    public JavaCILSourceGenerator() throws InvalidLanguageException {
        this(LanguageSpec.getLanguageSpec("Java"));
    }

    public JavaCILSourceGenerator(LanguageSpec langSpec) {
        super(langSpec);
        this.generateInnerDeclarations = true;
        this.generateIsNullAsEq = true;
        this.generateNotBeforeIs = true;
        this.useParenthesisForInteractiveStms = true;
        this.useParenthesisForRelayTo = true;
    }

    @Override
    public void generate(Cast cast) {
        Node targetType = cast.getTargetType();
        targetType.setParenthesis(true);
        this.generateExpr(targetType);
        this.print(" ");
        Node expr = cast.getExpr();
        if (this.isComplexExpression(expr)) {
            expr.setParenthesis(true);
        }
        this.generateExpr(expr);
    }

    @Override
    public void generate(Conversion conversion, Node expr) {
        if (!conversion.isSyntheticCast()) {
            if (!conversion.getParenthesis()) {
                this.print("(");
            }
            this.print("(");
            this.generateType(conversion.getTypeDescription(), JavaCILSourceGenerator.getContext(conversion));
            this.print(") ");
            if (this.isComplexExpression(expr)) {
                expr.setParenthesis(true);
            }
            this.generateExpr(expr);
            if (!conversion.getParenthesis()) {
                this.print(")");
            }
        } else {
            this.generateExpr(expr);
        }
    }

    @Override
    public void generate(In in, Node expr, Node range) {
        if (range instanceof Range) {
            this.print("(");
            this.generateExpr(expr);
            this.printSpaceDelimited(">=");
            range.getOp1().generate(this);
            this.printSpaceDelimited("&&");
            this.generateExpr(expr);
            this.printSpaceDelimited("<=");
            range.getOp2().generate(this);
            this.print(")");
        } else {
            this.generateExpr(expr);
            this.printSpaceDelimited("in");
            range.generate(this);
        }
    }

    @Override
    public void generate(Declaration decl) {
        decl.getDeclType().generate(this);
        this.print(" ");
        decl.getOp1().generate(this);
        Node init = decl.getInit();
        if (init != null && !init.isSynthetic()) {
            this.print(" = ");
            init.generate(this);
        }
        if (decl.isStatement()) {
            this.generateStatementSeparator(decl);
        }
    }

    @Override
    public void generate(ForEach foreach, Node index, Node array, Node where, Node body) {
        this.generateSeparatorBefore(foreach);
        TypeDescription indexType = foreach.hasScope() ? foreach.getSymbolTable().get(index.getText()).getType() : index.getTypeDescription();
        TypeDescription arrayType = array.getTypeDescription();
        if (!arrayType.isSql() && !indexType.equals(arrayType.getElementType())) {
            this.print("for (");
            this.generateType(indexType, JavaCILSourceGenerator.getContext(foreach));
            this.printSpace();
            this.printIdentifier(index.getText());
            this.print(" : ");
        } else {
            this.print("foreach (");
            this.printIdentifier(index.getText());
            this.printSpaceDelimited("in");
        }
        this.generateExpr(array);
        this.print(") ");
        boolean doblock = body instanceof DoBlock;
        if (!doblock) {
            this.println("{");
            this.indent();
        }
        if (where == null) {
            body.generate(this);
        } else {
            this.print("if (");
            JavaCILSourceGenerator.clearSynthetic(where);
            where.generate(this);
            this.println(") {");
            this.indent();
            body.generate(this);
            this.unindent();
            this.println("}");
        }
        if (!doblock) {
            this.unindent();
            this.println("}");
        }
        this.generateSeparatorAfter(foreach);
    }

    @Override
    public void generate(For fornode, Node index, Node range, Node body) {
        TypeDescription indexType = index.getTypeDescription();
        TypeDescription rangeType = range.getTypeDescription();
        String indexText = this.identifier(index.getText());
        this.generateSeparatorBefore(fornode);
        if (range instanceof Range) {
            this.print("for (");
            this.generateType(indexType, JavaCILSourceGenerator.getContext(fornode));
            this.printSpace();
            this.print(indexText);
            this.printSpaceDelimited("=");
            this.generateExpr(range.getOp1());
            this.print("; ");
            this.print(indexText);
            this.printSpaceDelimited("<=");
            this.generateExpr(range.getOp2());
            this.print("; ");
            this.print(indexText);
            this.print("++)");
        } else if (rangeType.isMap()) {
            this.print("foreach (");
            this.printIdentifier(index.getText());
            this.printSpaceDelimited("in");
            this.generateExpr(range);
            this.print(".keys");
            this.print(")");
        } else {
            this.print("for (");
            this.print("int ");
            this.print(indexText);
            this.printSpaceDelimited("=");
            this.print("0");
            this.print("; ");
            this.print(String.valueOf(indexText));
            this.printSpaceDelimited("<");
            this.generateExpr(range);
            this.print(".length");
            this.print("; ");
            this.print(String.valueOf(indexText));
            this.print("++)");
        }
        this.generateLoopBody(fornode, body, null, true);
    }

    @Override
    public void generate(JavaFor javaFor) {
        this.generateSeparatorBefore(javaFor);
        this.print("for (");
        for (Node init = javaFor.getInit().getFirst(); init != null; init = init.getNext()) {
            init.setStatement(false);
            init.generate(this);
            init.setStatement(true);
            if (init.getNext() == null) continue;
            this.print(", ");
        }
        this.print("; ");
        javaFor.getCond().generate(this);
        this.print("; ");
        for (Node reinit = javaFor.getReinit().getFirst(); reinit != null; reinit = reinit.getNext()) {
            reinit.setStatement(false);
            reinit.generate(this);
            reinit.setStatement(true);
            if (reinit.getNext() == null) continue;
            this.print(", ");
        }
        this.print(")");
        this.generateLoopBody(javaFor, javaFor.getBody(), javaFor.getName(), true);
    }

    @Override
    public void generate(Exit exit, Node predicate, Node label) {
        Method currentMember;
        this.generateSeparatorBefore(exit);
        if (predicate != null) {
            predicate.setParenthesis(true);
            this.print("if ");
            this.generateExpr(predicate);
            this.println(" {");
            this.indent();
        }
        this.print("break");
        if (label != null) {
            this.printSpace();
            label.generate(this);
        } else if (!exit.isInLoop() && (currentMember = exit.getCurrentMember()) != null) {
            this.printSpace();
            this.printIdentifier(currentMember.getMethodType().getName());
        }
        this.generateStatementSeparator(exit);
        if (predicate != null) {
            this.unindent();
            this.println("}");
        }
        this.generateSeparatorAfter(exit);
    }

    @Override
    public void generate(On on) {
        this.print("catch (");
        on.getOp1().generate(this);
        this.print(" ");
        on.getOp2().generate(this);
        this.println(") {");
        this.generateIndented(on.getOp3());
        this.println("}");
    }

    @Override
    public void generate(DoBlock doblock) {
        String label = doblock.getName();
        if (label == null || !label.equals("")) {
            // empty if block
        }
        Block exceptions = doblock.getExceptions();
        OnExit onExit = doblock.getOnExit();
        if (exceptions.hasChildren() || onExit != null) {
            this.print("try ");
        }
        this.println("{");
        this.generateIndented(doblock.getDeclarations());
        this.generateIndented(doblock.getStatements());
        this.println("}");
        ((Node)exceptions).generate(this);
        if (onExit != null) {
            onExit.generate(this);
        }
        this.generateSeparatorAfter(doblock);
    }

    @Override
    public void generate(IncDecOperator node) {
        this.genIncDec(node, node.getFirst());
        if (node.isStatement()) {
            this.generateStatementSeparator(node);
        }
    }

    @Override
    public void generate(Method method) {
        boolean hasExceptions;
        MethodTypeDescription mtd = method.getMethodType();
        this.generateType(mtd.getResultType(), mtd.getParent());
        this.print(" ");
        this.printIdentifier(method.getName());
        this.generateMethodArgs(mtd, true);
        this.println();
        this.println("{");
        this.indent();
        Block declarations = method.getDeclarations();
        Block exceptions = method.getExceptions();
        OnExit onExit = method.getOnExit();
        boolean bl = hasExceptions = exceptions != null && exceptions.hasChildren();
        if (declarations.hasChildren()) {
            this.generate(declarations);
            this.pw.printSeparator();
        }
        if (hasExceptions || onExit != null) {
            this.println("try {");
            this.indent();
        }
        this.generate(method.getStatements());
        if (hasExceptions || onExit != null) {
            this.unindent();
            this.println("}");
        }
        if (hasExceptions) {
            exceptions.generate(this);
        }
        if (onExit != null) {
            onExit.generate(this);
        }
        this.unindent();
        this.println("}");
    }

    @Override
    public void generate(OnExit onExit) {
        this.print("finally ");
        this.generateBlock(onExit.getBlock());
    }

    @Override
    public void generate(Switch switchNode, Node expr, Node cases) {
        this.generateSeparatorBefore(switchNode);
        this.print("switch (");
        expr.generate(this);
        this.println(") {");
        while (cases != null) {
            cases.generate(this);
            cases = cases.getNext();
        }
        this.println("}");
        this.generateSeparatorAfter(switchNode);
    }

    @Override
    public void generate(Switch.Case caseNode, Node cond, Node body) {
        for (Node current = cond.getFirst(); current != null; current = current.getNext()) {
            this.print("case ");
            if (current instanceof Equality) {
                current.getOp2().generate(this);
            } else {
                current.generate(this);
            }
            this.println(":");
        }
        this.generateIndented(body);
        this.printIndentedLn("break;");
    }

    @Override
    public void generate(Switch.Default defaultNode, Node body) {
        this.println("default:");
        this.generateIndented(body);
        this.printIndentedLn("break;");
    }

    @Override
    protected boolean isComplexExpression(Node node) {
        return node instanceof Cast || super.isComplexExpression(node);
    }

    @Override
    protected void generateArgument(Argument argument, TypeDescription context) {
        if (argument.isIn() && argument.isOut()) {
            this.print("in out");
            this.print(" ");
        } else if (argument.isOut()) {
            this.print("out");
            this.print(" ");
        }
        this.generateType(argument.getType(), context);
        this.print(" ");
        this.printIdentifier(argument.getName());
    }

    protected void generateBlock(Node block) {
        this.println("{");
        this.indent();
        block.generate(this);
        this.unindent();
        this.println("}");
    }

    @Override
    protected void generateElse(Node elseNode) {
        this.println("}");
        this.println("else {");
        this.generateIndented(elseNode);
        this.println("}");
    }

    @Override
    protected void generateElseIf(Node elseNode) {
        this.println("}");
        this.print("else ");
        elseNode.generate(this);
    }

    @Override
    protected void generateLabel(String label) {
        this.printIdentifier(label);
        this.println(":");
    }

    @Override
    protected void generateLoopBody(LoopStatement loop, Node body, String name, boolean separateWithSpace) {
        super.generateLoopBody(loop, body, null, separateWithSpace);
    }

    @Override
    protected void generateStatementSeparator(Node statement) {
        if (statement instanceof Block) {
            this.println();
        } else {
            this.println(";");
        }
    }

    @Override
    protected void generateTransformLibrary(Node library) {
        this.print("(");
        this.generateExpr(library);
        this.print(")");
    }
}

