/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import java.util.Set;
import oracle.bpm.compiler.Arithmetic;
import oracle.bpm.compiler.Assignment;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.BoolConst;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CodeStyle;
import oracle.bpm.compiler.Comp;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Declaration;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.ExitException;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.For;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.InfinitLoopException;
import oracle.bpm.compiler.IntConst;
import oracle.bpm.compiler.LoopStatement;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NodeIterator;
import oracle.bpm.compiler.NonBooleanException;
import oracle.bpm.compiler.Not;
import oracle.bpm.compiler.NullStatement;
import oracle.bpm.compiler.Range;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.Any;
import oracle.bpm.type.TypeFactory;

public class While
extends LoopStatement {
    public While(Token t) {
        super(t);
    }

    While() {
    }

    public static Node condition(Node condition, Node statements) {
        While whileNode = new While();
        whileNode.setOperands(condition, statements);
        return whileNode;
    }

    @Override
    public String getText() {
        return this.getName() + ":while";
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this, this.getPredicate(), this.getBody());
    }

    public Node rewriteAsFor() {
        return this.rewriteAsFor(false);
    }

    public Node rewriteAsFor(boolean checkOnly) {
        Node pred = this.getPredicate();
        Comp comp = pred instanceof Comp ? (Comp)pred : null;
        Node prev = this.getPrev();
        Node body = this.getBody();
        if (prev instanceof Assignment && comp != null && comp.isLessThan()) {
            Node var = prev.getFirst();
            Node from = var.getNext();
            Node compVar = comp.getFirst();
            Node to = compVar.getNext();
            Symbol varSymbol = var.getSymbol();
            Symbol compSymbol = compVar.getSymbol();
            boolean firstUse = var.isFirstSymbolUse();
            boolean isLastUse = false;
            for (Node lastUse = varSymbol.getLastUse(); lastUse != null; lastUse = lastUse.getParent()) {
                if (lastUse != this) continue;
                isLastUse = true;
                break;
            }
            if (Any.equals(varSymbol, compSymbol) && firstUse && isLastUse) {
                Assignment inc = null;
                NodeIterator it = body.getChildren();
                while (it.hasNext()) {
                    Assignment assign;
                    Node statement = it.next();
                    if (!(statement instanceof Assignment) || !Any.equals(varSymbol, (assign = (Assignment)statement).getVarSymbol()) || !assign.isIncrement()) continue;
                    inc = assign;
                    break;
                }
                Method doblock = this.getCurrentMember();
                Declaration decl = doblock.findDeclaration(varSymbol.getName());
                if (inc != null && decl != null) {
                    if (checkOnly) {
                        return null;
                    }
                    Identifier idx = new Identifier(var.getSymbol().getName(), this);
                    try {
                        if (comp.isLessThan()) {
                            IntConst one = new IntConst(1L, this);
                            to = new Arithmetic(to, 1, one);
                            FuegoCompiler compiler = this.getCompiler();
                            compiler.clearDirective(1);
                            to = to.checkType();
                            compiler.setDirective(1);
                        }
                        Range range = new Range(from, to);
                        For f = new For(idx, range, this.getBody());
                        prev.removeFromParent();
                        inc.removeFromParent();
                        decl.remove();
                        f = (For)f.checkType();
                        this.replace(f);
                        return f;
                    }
                    catch (TypeException noway) {
                        noway.printStackTrace();
                    }
                }
            }
        }
        return this;
    }

    @Override
    protected boolean splitToPrint() {
        return true;
    }

    @Override
    void setBody(Node body) {
        this.getOp1().setNext(body);
        body.setNext(null);
    }

    @Override
    Node getBody() {
        return this.getOp2();
    }

    Node getPredicate() {
        return this.getOp1();
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        Node condition = this.getOp1();
        Node body = this.getOp2();
        condition.checkFlow(context);
        FlowContext split = context.split();
        Set<String> exit = split.backupExit();
        body.checkFlow(split);
        boolean exitCaught = split.catchExit(this.getName());
        split.restoreExit(exit);
        context.join(split);
        if (condition.isConstant() && ((BoolConst)condition).booleanValue()) {
            if (!exitCaught && !context.hasUnCaughtExit()) {
                this.reportError(new InfinitLoopException(this));
            }
            context.breaksFlow(!exitCaught);
        } else {
            context.breaksFlow(false);
        }
        return context;
    }

    @Override
    Node checkType() throws TypeException {
        Node pred = this.getOp1();
        Node body = this.getOp2();
        pred = pred.checkType(TypeFactory.getBool());
        if (body instanceof Block) {
            Block block = (Block)body;
            this.setName(block.getName());
        }
        body = body.checkType();
        if (pred.getKind() != 1) {
            this.reportError(new NonBooleanException(pred));
        }
        if (pred.isConstant() && !((BoolConst)pred).booleanValue()) {
            return NullStatement.NODE;
        }
        this.setOperands(Conversion.UnBox.create(pred).checkType(), body);
        this.setTypeDescription(TypeFactory.getVoid());
        return this.processBody(body);
    }

    @Override
    void generate(CodeGenerator cg) {
        cg.generate(this);
    }

    @Override
    Node refactor(CodeStyle ss) {
        super.refactor(ss);
        this.rewriteAsFor();
        return this;
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        block3: {
            try {
                while (((Boolean)this.getOp1().value(rm)).booleanValue()) {
                    this.getOp2().run(rm);
                }
            }
            catch (ExitException exit) {
                if (exit.getLabel() == null || exit.getLabel().equals(this.getName())) break block3;
                throw exit;
            }
        }
        return null;
    }

    public static class Until
    extends While {
        public Until() {
        }

        public Until(Token t) {
            super(t);
        }

        @Override
        Node checkType() throws TypeException {
            if (this.getKind() != -1) {
                return this;
            }
            Node predicate = this.getPredicate();
            Node body = this.getBody();
            predicate = Not.not(predicate).checkType();
            this.setOperands(predicate, body);
            return super.checkType();
        }
    }
}

