/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.NList;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NodeIterator;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TransformationNotAvailableException;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;

public class TransformCall
extends MemberAccess {
    public TransformCall(Token t) {
        super(t);
        this.setParametric(false);
    }

    TransformCall() {
        this((Token)null);
    }

    @Override
    public String getText() {
        return "->";
    }

    @Override
    public void generate(SourceGenerator cg) {
        Node source = this.getSource();
        Node target = this.getOp2();
        Node library = this.getOp3();
        cg.generate(this, source, target, library);
    }

    @Override
    TypeDescription getDeclaration() {
        return this.getMemberType();
    }

    Node getLibrary() {
        return this.getOp3();
    }

    Node getSource() {
        return this.getOp1();
    }

    @Override
    Node checkType() throws TypeException {
        Node source;
        if (this.getKind() != -1) {
            return this;
        }
        Node sourceList = new NList();
        Node lastSource = source = this.getFirst();
        while (!(source instanceof TypeSpec)) {
            lastSource = source;
            source = source.getNext();
        }
        Node target = lastSource.getNext();
        Node library = target.getNext();
        lastSource.setNext(null);
        sourceList.setFirst(this.getFirst());
        this.setOperands(sourceList, target, library);
        sourceList = sourceList.checkType();
        target = target.checkType();
        library = library.checkType();
        this.setOperands(sourceList, target, library);
        ObjectTypeDescription libraryType = library.getObjectType();
        TypeDescription targetType = target.getTypeDescription();
        int argc = sourceList.childCount();
        int count = libraryType.getMemberCount();
        List<TypeDescription> array = CollectionPool.getArrayList();
        for (Node src = sourceList.getFirst(); src != null; src = src.getNext()) {
            array.add(src.getTypeDescription());
        }
        TypeDescription[] sourceTypes = array.toArray(new TypeDescription[array.size()]);
        CollectionPool.releaseArrayList(array);
        MethodTypeDescription selected = null;
        List selectedList = null;
        for (int i = 0; i < count; ++i) {
            MethodTypeDescription member = libraryType.getMemberType(i);
            int argumentCount = member.getArgumentCount();
            if (argumentCount != argc || !member.getResultType().equals(targetType)) continue;
            if (selected == null) {
                selected = member;
                continue;
            }
            if (selectedList == null) {
                selectedList = CollectionPool.getArrayList();
                selectedList.add(selected);
            }
            selectedList.add(member);
        }
        if (selectedList != null) {
            Map<String, TypeDescription> empty = Collections.emptyMap();
            selected = MemberAccess.select(selectedList, empty, sourceTypes, false, this);
            CollectionPool.releaseArrayList(selectedList);
        }
        if (selected == null || selected.getArgumentCount() != sourceTypes.length) {
            throw new TransformationNotAvailableException(this, sourceTypes, targetType, libraryType);
        }
        if (!MemberAccess.isAssignableFromArgs(selected, sourceTypes, Collections.emptyMap())) {
            throw new TransformationNotAvailableException(this, sourceTypes, targetType, libraryType);
        }
        this.setTypeDescription(selected.getResultType());
        this.setMemberType(selected);
        if (!this.isGeneratingSource()) {
            Args args = new Args(1L);
            NodeIterator sources = sourceList.getChildren(true);
            while (sources.hasNext()) {
                args.addInArgument(sources.next());
            }
            Invoke invoke = new Invoke(library, selected, args, false);
            invoke.initialize(this);
            invoke.setExpression(true);
            this.setOperand(invoke.checkType());
        }
        return this;
    }

    @Override
    void generate(CodeGenerator cg) {
        this.getOp1().gen(cg);
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        return this.getFirst().run(rm);
    }
}

