/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.util.Map;
import oracle.bpm.cil.CilException;
import oracle.bpm.cil.MessageListener;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.TypeException;
import org.jetbrains.annotations.NonNls;

class Template
extends Node
implements MessageListener {
    private final Node compiledCode;
    private final Node context;
    private boolean failed;
    private Map<String, Node> parameters;

    Template(Node code, Node context) {
        this.compiledCode = code;
        this.context = context;
        this.setExpression(context.isExpression());
        this.setScope(context.getScope());
        this.setParent(context);
        if (this.compiledCode == null) {
            this.failed = true;
        } else {
            this.setFirst(this.compiledCode);
            this.compiledCode.setScope(this.getScope());
        }
    }

    @Override
    public void reportError(CilException error) {
        this.failed = true;
    }

    @Override
    public void reportWarning(CilException warning) {
    }

    void addParameter(@NonNls String name, Node value) {
        if (this.parameters == null) {
            this.parameters = CollectionPool.getHashMap();
        }
        this.parameters.put(name, value);
    }

    Node getParameter(String name) {
        Node result = null;
        if (this.parameters != null && (result = this.parameters.get(name)) == null) {
            result = this.getDynamicParameter(name);
        }
        return result;
    }

    Node apply() {
        Node result;
        if (this.compiledCode == null) {
            result = this.context;
        } else {
            this.bindParameters(this);
            Node tree = this.context;
            try {
                tree = this.checkType();
            }
            catch (TypeException e) {
                this.reportError(e);
            }
            result = this.isFailed() ? this.context : tree;
        }
        CollectionPool.releaseHashMap(this.parameters);
        this.parameters = null;
        return result;
    }

    @Override
    Node checkType() throws TypeException {
        Node result = this.getOp1().checkType();
        return this.isFailed() ? null : result;
    }

    boolean isFailed() {
        return this.failed;
    }

    private Node getDynamicParameter(String name) {
        Node result = null;
        if ("parent".equals(name)) {
            result = this.context;
        } else if ("memberName".equals(name)) {
            result = new Identifier(this.getCurrentMember().getName());
        } else if ("componentName".equals(name)) {
            result = new Identifier(this.getCurrentClass().getName());
        }
        return result;
    }
}

