/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeFactory;

public class SymbolTable
extends TreeMap<String, Symbol> {
    private Map<String, Symbol> args = null;
    private ObjectClass currentClass;
    private SymbolTable defaultTable = null;
    private Boolean forceArgQualification = null;
    private Map<String, Symbol> functions = null;
    private static final Symbol[] SYMBOL_ARRAY = new Symbol[0];
    private static SymbolComparator sensitiveComparator = new SymbolComparator(true);
    private static SymbolComparator insensitiveComparator = new SymbolComparator(false);
    static final long serialVersionUID = -5681564677730521898L;
    static final long serialCheck = -1059824148905570195L;

    public SymbolTable() {
        this((SymbolTable)null);
    }

    public SymbolTable(SymbolTable defaultTable, boolean sensitive) {
        super(sensitive ? sensitiveComparator : insensitiveComparator);
        this.defaultTable = defaultTable;
    }

    private SymbolTable(SymbolTable defaultTable) {
        super(sensitiveComparator);
        this.defaultTable = defaultTable;
    }

    public final Symbol getArgument(String key) {
        Symbol result = null;
        if (this.args != null) {
            result = this.args.get(key);
        }
        if (result == null && this.defaultTable != null) {
            result = this.defaultTable.getArgument(key);
        }
        return result;
    }

    public final Symbol[] getArguments() {
        if (this.args == null) {
            return SYMBOL_ARRAY;
        }
        Collection<Symbol> args = this.args.values();
        Symbol[] symbols = new Symbol[args.size()];
        int i = 0;
        for (Symbol symbol : args) {
            symbols[i++] = symbol;
        }
        return symbols;
    }

    public final Symbol getLocal(String key) {
        return (Symbol)super.get(key);
    }

    public final Symbol get(String key) {
        Symbol result = (Symbol)super.get(key);
        if (result == null) {
            if (!this.isForceArgQualification() && this.args != null) {
                result = this.args.get(key);
            }
            if (result == null && this.defaultTable != null) {
                result = this.defaultTable.get(key);
            }
        }
        if (result != null && result.isArgument() && this.isForceArgQualification()) {
            return null;
        }
        return result;
    }

    public SymbolTable getDefaultTable() {
        return this.defaultTable;
    }

    public final Symbol getFunction(String key) {
        Symbol result;
        Symbol symbol = result = this.functions != null ? this.functions.get(key) : null;
        if (result == null && this.defaultTable != null) {
            result = this.defaultTable.getFunction(key);
        }
        return result;
    }

    public final void pop(Symbol s) {
        assert (s.getType() != null);
        String nm = s.getName();
        if (s.getType() == TypeFactory.getNone()) {
            this.remove(nm);
        } else {
            this.put(s);
        }
    }

    public final Symbol push(Symbol s) {
        assert (s.getType() != null);
        Symbol old = this.put(s);
        if (old == null) {
            return new Symbol(s.getName(), TypeFactory.getNone());
        }
        return old;
    }

    public final Symbol push(String nm, TypeDescription t) {
        return this.push(new Symbol(nm, t));
    }

    public final Symbol put(Symbol s) {
        assert (s.getType() != null);
        return super.put(s.getName(), s);
    }

    public final Symbol putArgument(Argument arg, String signature) {
        if (this.args == null) {
            this.args = CollectionPool.getHashMap();
        }
        Symbol symbol = new Symbol(arg);
        symbol.setExternallyDeclared(!arg.isReturnValue());
        this.args.put(arg.getName(), symbol);
        return symbol;
    }

    public final void putFunction(String name, TypeDescription type) {
        assert (type.isMethod());
        if (this.functions == null) {
            this.functions = CollectionPool.getHashMap();
        }
        this.functions.put(name, new Symbol(name, type));
    }

    public final Symbol remove(String key) {
        return (Symbol)super.remove(key);
    }

    public void setDefaultTable(SymbolTable defaultTable) {
        this.defaultTable = defaultTable;
    }

    public void setForceArgQualification(boolean forceArgumentQualification) {
        this.forceArgQualification = forceArgumentQualification;
    }

    @Override
    public String toString() {
        return "SymbolTable(" + super.toString() + ", #" + System.identityHashCode(this) + ")";
    }

    void setCurrentClass(ObjectClass currentClass) {
        this.currentClass = currentClass;
    }

    ObjectClass getCurrentClass() {
        if (this.currentClass == null && this.defaultTable != null) {
            this.currentClass = this.defaultTable.getCurrentClass();
        }
        return this.currentClass;
    }

    private boolean isForceArgQualification() {
        if (this.forceArgQualification == null) {
            if (this.defaultTable != null) {
                Boolean bl = this.forceArgQualification = this.defaultTable.isForceArgQualification() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (this.forceArgQualification == null) {
                this.forceArgQualification = Boolean.FALSE;
            }
        }
        return this.forceArgQualification;
    }

    static final class SymbolComparator
    implements Comparator<String> {
        private boolean sensitive;

        SymbolComparator(boolean sensitive) {
            this.sensitive = sensitive;
        }

        @Override
        public int compare(String a, String b) {
            if (this.sensitive) {
                return a == null ? (b == null ? 0 : -1) : (b == null ? 1 : a.compareTo(b));
            }
            return a == null ? (b == null ? 0 : -1) : (b == null ? 1 : a.toLowerCase().compareTo(b.toLowerCase()));
        }
    }
}

