/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.bcgen.LocalVariable;
import oracle.bpm.compiler.Node;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeHolder;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.DefaultValue;
import oracle.bpm.util.PrimitiveTypeUtils;

public final class Symbol
implements Comparable,
TypeHolder {
    private Argument argument;
    private boolean autoDeclared;
    private boolean externallyDeclared;
    private boolean filtered;
    private boolean isUsedAsTarget;
    private Node lastUse;
    private LocalVariable localVariable;
    private MethodTypeDescription member;
    private long modifiers;
    private String name;
    private Symbol replacement;
    private String signature;
    private boolean silentAutoDeclared;
    private Symbol target;
    private TypeDescription type;
    private boolean typeSpec;
    private Object value;
    private static int number = 0;

    public Symbol(String nm, TypeDescription td) {
        this(nm, td, 0L);
    }

    public Symbol(String nm, TypeDescription td, long modifiers) {
        this.name = nm;
        this.type = td;
        this.modifiers = modifiers;
    }

    public Symbol(String nm, TypeDescription td, Object v) {
        this(nm, td, v, 0L);
    }

    Symbol(Argument arg) {
        this("", arg);
        this.setSignature("arg$".concat(arg.getName()));
    }

    Symbol(String prefix, Argument arg) {
        this(prefix + arg.getName(), arg.getType());
        this.argument = arg;
        this.autoDeclared = true;
        this.silentAutoDeclared = true;
        this.setSignature(prefix + arg.getName());
    }

    private Symbol(String nm, TypeDescription td, Object v, long modifiers) {
        this.name = nm;
        this.type = td;
        this.value = v;
        this.modifiers = modifiers;
    }

    public int compareTo(Object object) {
        if (!(object instanceof Symbol)) {
            return -1;
        }
        return this.getName().compareTo(((Symbol)object).getName());
    }

    public Argument getArgument() {
        return this.argument;
    }

    public String getHolderType() {
        return this.argument == null ? this.getType().getHolderType().getDefaultHolder() : this.argument.getHolderJavaType();
    }

    public Class getJavaClass() {
        Class javaClass;
        if (this.argument != null && this.argument.isExternal()) {
            try {
                javaClass = JavaClass.loadByJavaType(this.argument.getJavaType());
            }
            catch (ClassNotFoundException e) {
                javaClass = null;
            }
        } else {
            Class clazz = javaClass = this.type.isInvokeable() ? Invokeable.class : this.type.getJavaClass();
        }
        if (javaClass == null) {
            javaClass = Object.class;
        }
        return PrimitiveTypeUtils.box(javaClass);
    }

    public int getKind() {
        return this.getType().getKind();
    }

    public Node getLastUse() {
        return this.lastUse;
    }

    public LocalVariable getLocalVariable() {
        return this.localVariable;
    }

    public long getModifiers() {
        return this.modifiers;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Symbol getReplacement() {
        return this.replacement;
    }

    public String getSignature() {
        if (this.signature != null) {
            return this.signature;
        }
        String name = this.getName();
        if (!this.isThis() && !this.isSuper()) {
            name = "var$".concat(Symbol.safeChars(name));
        }
        return this.isExternallyDeclared() ? this.getName() : name;
    }

    @Override
    public TypeDescription getType() {
        return this.member != null ? this.member.getResultType() : this.type;
    }

    public String getUniqueName(String suffix) {
        return this.getName() + "$" + suffix + number++;
    }

    public boolean isArgument() {
        return this.argument != null;
    }

    public boolean isAutoDeclared() {
        return this.autoDeclared;
    }

    public boolean isConstant() {
        return Modifier.isConst(this.modifiers);
    }

    public boolean isExternalArgument() {
        return this.isArgument() && this.isExternallyDeclared();
    }

    public boolean isFilteredIterable() {
        return this.filtered;
    }

    public boolean isHolder() {
        return this.argument != null && this.argument.isOut();
    }

    public boolean isInstanceVariable() {
        return this.isExternallyDeclared() && !this.isArgument() && !this.isStatic();
    }

    public boolean isSilentAutoDeclared() {
        return this.silentAutoDeclared;
    }

    public boolean isTargetUsed() {
        return this.target != null && this.target.isUsedAsTarget;
    }

    public boolean isTypeSpec() {
        return this.typeSpec;
    }

    public void setAutoDeclared(Node pos, boolean v, boolean silent) {
        this.autoDeclared = v;
        this.silentAutoDeclared = silent;
    }

    public void setExternallyDeclared(boolean value) {
        this.externallyDeclared = value;
    }

    public void setFilteredIterable(boolean b) {
        this.filtered = b;
    }

    public Node setLastUse(Node lastUse) {
        Node prev = this.lastUse;
        this.lastUse = lastUse;
        return prev;
    }

    public void setLocalVariable(LocalVariable variable) {
        this.localVariable = variable;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setReplacement(Symbol replacement) {
        this.replacement = replacement;
    }

    public void setSignature(String s) {
        this.signature = s;
    }

    public void markTargetUsed() {
        if (this.target == null) {
            return;
        }
        this.target.isUsedAsTarget = true;
    }

    @Override
    public void setType(TypeRef ref) {
        this.setType(ref.get());
    }

    public void setType(TypeDescription type) {
        assert (type != null);
        this.type = type;
    }

    public void setTypeSpec(boolean typeSpec) {
        this.typeSpec = typeSpec;
    }

    public void setUniqueSignature(String suffix) {
        this.setSignature(this.getName() + "$" + suffix + number++);
    }

    public void setValue(Object v) {
        assert (!(v instanceof Symbol));
        if (this.replacement != null) {
            this.replacement.setValue(v);
            return;
        }
        this.value = v;
        if (this.value == null && this.type != null && this.type.isPrimitive() && this.type.getKind() != 12) {
            Class<?> javaClass = this.getType().getJavaClass();
            this.value = DefaultValue.forClass(javaClass);
        }
    }

    public Object getValue() {
        Object result;
        if (this.replacement != null) {
            result = this.replacement.getValue();
        } else if (this.member == null) {
            result = this.value;
        } else {
            Object target = this.getTarget().getValue();
            try {
                result = this.member.invoke(target, null);
            }
            catch (ComponentExecutionException e) {
                throw new RuntimeExceptionShell(e);
            }
        }
        return result;
    }

    public String toString() {
        String result = this.getName();
        if (this.isConstant()) {
            result = result + "=" + this.value;
        }
        TypeDescription td = this.getType();
        result = result + "::" + (td == null ? "(null)" : ((Object)this.getType()).toString());
        return result;
    }

    MethodTypeDescription getMember() {
        return this.member;
    }

    Symbol getTarget() {
        return this.target;
    }

    boolean isAssignableValue(Object value) {
        Class<?> javaClass2;
        Class<?> valueClass;
        if (this.type == null || value == null) {
            return true;
        }
        Class javaClass = this.getJavaClass();
        if (javaClass.isAssignableFrom(valueClass = value.getClass())) {
            return true;
        }
        try {
            javaClass2 = Class.forName(javaClass.getName(), false, valueClass.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return javaClass2.isAssignableFrom(valueClass);
    }

    boolean isInnerClassParentReference() {
        String signature = this.getSignature();
        return signature != null && "this_0".equals(signature);
    }

    boolean isLazyHolder() {
        return this.isHolder() && Any.isLazyHolder(this.getHolderType());
    }

    boolean isMember() {
        return this.member != null;
    }

    boolean isThis() {
        return this.name.equals("this");
    }

    void setMember(MethodTypeDescription mn) {
        this.member = mn;
    }

    void setTarget(Symbol d) {
        this.target = d;
    }

    boolean isSuper() {
        return this.name.equals("super");
    }

    private static String transliterate(String name, String fromChars, String toChars) {
        int nameLen = name.length();
        StringBuilder result = new StringBuilder(nameLen);
        for (int i = 0; i < nameLen; ++i) {
            char c = name.charAt(i);
            int pos = fromChars.indexOf(c);
            if (pos >= toChars.length()) continue;
            result.append(pos < 0 ? c : toChars.charAt(pos));
        }
        return result.toString();
    }

    private static String safeChars(String name) {
        return Symbol.transliterate(name, ".()", "_$");
    }

    private boolean isExternallyDeclared() {
        return this.externallyDeclared;
    }

    private boolean isStatic() {
        return (this.modifiers & 0x40L) != 0L;
    }
}

