/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import fuego.parser.collections.AST;
import java.util.Set;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.DuplicatedCaseException;
import oracle.bpm.compiler.Equality;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.InvalidAssignmentException;
import oracle.bpm.compiler.LocalVar;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.NList;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NodeIterator;
import oracle.bpm.compiler.NotLiteralValueException;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;

public class SwitchCases
extends NList {
    public SwitchCases(Token t) {
        super(t);
    }

    public SwitchCases(AST ast) {
        super(ast);
    }

    SwitchCases() {
    }

    @Override
    public String getText() {
        return "cases";
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    Node checkType(LocalVar expr, TypeDescription exprType, Set<String> cases) throws TypeException {
        TypeDescription type = null;
        NodeIterator it = this.getChildren();
        boolean constant = true;
        while (it.hasNext()) {
            Node current = it.next();
            current = current.checkType(exprType);
            TypeDescription currentType = current.getTypeDescription();
            type = type == null ? currentType : type.promote(currentType);
            String text = current.getText();
            if (!SwitchCases.isConstant(current)) {
                this.reportError(new NotLiteralValueException(current));
            } else if (cases.contains(text)) {
                this.reportError(new DuplicatedCaseException(current));
            } else {
                cases.add(text);
            }
            if (!exprType.isAssignableFrom(currentType)) {
                throw new InvalidAssignmentException(current, currentType, exprType);
            }
            current = Conversion.promote(current, currentType);
            current = Equality.equals(new Deref(SwitchCases.copy(expr)), current);
            current.setParent(this);
            it.replace(current.checkType());
            constant = constant && current.isConstant();
        }
        this.setTypeDescription(type);
        return this;
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        for (Node current = this.getFirst(); current != null; current = current.getNext()) {
            Object value = current.value(rm);
            if (!Any.equals(Boolean.TRUE, value)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static boolean isConstant(Node node) {
        boolean constant = node.isConstant();
        if (!constant && node instanceof MemberReference) {
            MemberReference reference = (MemberReference)node;
            MethodTypeDescription memberType = reference.getMemberType();
            constant = memberType != null && memberType.isFinal();
        }
        return constant;
    }
}

