/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Diadic;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NullConst;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.StringConst;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.Str;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.filter.Operation;

public class StringCat
extends Diadic {
    public StringCat(Token t) {
        super(t);
    }

    StringCat(Node op1, Node op2) {
        this.setOperands(op1, op2);
        this.initialize(op1);
    }

    @Override
    public String getText() {
        return "cat";
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this, this.getOp1(), this.getOp2());
    }

    static Node make(Node op1, Node op2, Node parent) throws TypeException {
        if (!op1.isGeneratingSource() && op1.isConstant() && op2.isConstant()) {
            if (op1 instanceof NullConst || op1 instanceof Conversion.Null) {
                return op2;
            }
            if (op2 instanceof NullConst || op2 instanceof Conversion.Null) {
                return op1;
            }
            return StringConst.append((StringConst)op1, (StringConst)op2).dettach();
        }
        StringCat result = new StringCat(op1, op2);
        result.setParent(parent);
        result.initialize(parent);
        return result.checkType();
    }

    @Override
    Operation getOperationTree() {
        if (this.isParameter()) {
            return new Operation(0, "?", null);
        }
        Operation op1 = this.getOp1().getOperationTree();
        Operation op2 = this.getOp2().getOperationTree();
        Operation[] operands = new Operation[]{op1, op2};
        return new Operation(18, "||", operands);
    }

    @Override
    Node checkType() throws TypeException {
        if (this.getKind() != -1) {
            return this;
        }
        super.checkType();
        Node op1 = this.getOp1();
        Node op2 = this.getOp2();
        if (op1.getKind() != 5) {
            op1 = Conversion.promote(op1, TypeFactory.getString());
        }
        if (op2.getKind() != 5) {
            op2 = Conversion.promote(op2, TypeFactory.getString());
        }
        int length1 = op1.getTypeDescription().getLength();
        int length2 = op2.getTypeDescription().getLength();
        int length = length1 < 0 || length2 < 0 ? -1 : Math.max(length1, length2);
        this.setOperands(op1, op2);
        this.setTypeDescription(TypeFactory.getString(length));
        return this;
    }

    @Override
    void generate(CodeGenerator cg) {
        cg.generate(this);
    }

    @Override
    void generateSQLCode(StringBuffer query) {
        if (this.checkParameter(query)) {
            return;
        }
        this.getOp1().generateSQLCode(query);
        query.append(" || ");
        this.getOp2().generateSQLCode(query);
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        assert (this.getKind() != -1);
        String value1 = (String)this.getOp1().value(rm, String.class);
        String value2 = (String)this.getOp2().value(rm, String.class);
        return Str.concat(value1, value2);
    }
}

