/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.compiler.Aggregate;
import oracle.bpm.compiler.Alias;
import oracle.bpm.compiler.Arg;
import oracle.bpm.compiler.Arithmetic;
import oracle.bpm.compiler.ArrayConst;
import oracle.bpm.compiler.BaseCILSourceGenerator;
import oracle.bpm.compiler.Delete;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.Exists;
import oracle.bpm.compiler.GroupByColumns;
import oracle.bpm.compiler.Having;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.In;
import oracle.bpm.compiler.Insert;
import oracle.bpm.compiler.JavaFor;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.OrderBy;
import oracle.bpm.compiler.Select;
import oracle.bpm.compiler.SelectColumns;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.SqlColumnReference;
import oracle.bpm.compiler.Tables;
import oracle.bpm.compiler.TokenNames;
import oracle.bpm.compiler.Update;

public class SqlSourceGenerator
extends BaseCILSourceGenerator
implements SourceGenerator {
    private boolean escapeVariables;

    public SqlSourceGenerator(LanguageSpec langSpec) {
        super(langSpec);
        this.setNames(new TokenNames());
        this.getNames().setConcatOperator("||");
        this.getNames().relationalDistinct = "<>";
        this.getNames().literalArrayStart = "(";
        this.getNames().literalArrayEnd = ")";
        this.escapeVariables = false;
    }

    @Override
    public void generate(Aggregate aggregate, Node operand, int op, boolean distinct) {
        String opname = "";
        switch (op) {
            case 0: {
                opname = "AVG";
                break;
            }
            case 3: {
                opname = "SUM";
                break;
            }
            case 1: {
                opname = "MAX";
                break;
            }
            case 2: {
                opname = "MIN";
                break;
            }
            case 4: {
                opname = "COUNT";
            }
        }
        this.print(opname + "(");
        if (distinct) {
            this.print("DISTINCT ");
        }
        this.generateExpr(operand);
        this.print(")");
    }

    @Override
    public void generate(In in, Node expr, Node range) {
        this.generateExpr(expr);
        this.printSpaceDelimited("in");
        this.generateExpr(range);
    }

    @Override
    public void generate(ArrayConst arrayConst, boolean isMap) {
        super.generate(arrayConst, isMap);
    }

    @Override
    public void generate(Alias alias, Node variable, Node aliasName) {
        this.generateExpr(variable);
        if (!alias.isSynthetic()) {
            this.printSpaceDelimited("AS");
            aliasName.generate(this);
        }
    }

    @Override
    public void generate(Arithmetic arithmetic) {
        if (arithmetic.getOperator() == 2 && arithmetic.getOp1() == null) {
            this.print("*");
        } else {
            super.generate(arithmetic);
        }
    }

    @Override
    public void generate(Deref deref, Node op) {
        if (this.escapeVariables && op instanceof Identifier) {
            this.print(":");
        }
        super.generate(deref, op);
    }

    @Override
    public void generate(Select select) {
        Node orderBy;
        Node having;
        this.println();
        this.indent();
        this.print("SELECT ");
        Node columns = select.getColumns();
        Node tables = select.getTables();
        Node where = select.getWhere();
        if (select.isDistinct()) {
            this.printSpaceDelimited("DISTINCT");
        }
        columns.generate(this);
        this.println();
        this.print("FROM ");
        tables.generate(this);
        this.generateSqlWhere(where);
        Node groupBy = select.getGroupBy();
        if (groupBy != null) {
            this.print(" ");
            groupBy.generate(this);
        }
        if ((having = select.getHaving()) != null) {
            this.println();
            having.generate(this);
        }
        if ((orderBy = select.getOrderBy()) != null) {
            this.println();
            orderBy.generate(this);
        }
        this.println();
        this.unindent();
    }

    @Override
    public void generate(Update.SetValues setValues) {
        this.println();
        this.print("SET ");
        Node assign = setValues.getFirst();
        while (assign != null) {
            Node target = assign.getOp1();
            Node expr = assign.getOp2();
            target.generate(this);
            this.printSpaceDelimited("=");
            this.generateExpr(expr);
            if ((assign = assign.getNext()) == null) continue;
            this.println(",");
        }
    }

    @Override
    public void generate(Update update) {
        this.generateSeparatorBefore(update);
        this.print("UPDATE ");
        Node table = update.getTable();
        Node values = update.getValues();
        Node where = update.getWhere();
        table.generate(this);
        values.generate(this);
        this.generateSqlWhere(where);
        this.generateSqlStatementSeparator(update);
        this.generateSeparatorAfter(update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(SqlColumnReference sqlColumnReference) {
        boolean prevEscape = this.escapeVariables;
        try {
            this.escapeVariables = false;
            if (sqlColumnReference.isForceParamQualification()) {
                this.print(":");
            }
            sqlColumnReference.getOp1().generate(this);
        }
        finally {
            this.escapeVariables = prevEscape;
        }
    }

    @Override
    public void generate(Delete delete) {
        this.generateSeparatorBefore(delete);
        Node table = delete.getTable();
        Node where = delete.getWhere();
        this.print("DELETE FROM ");
        table.generate(this);
        this.generateSqlWhere(where);
        this.generateSqlStatementSeparator(delete);
        this.generateSeparatorAfter(delete);
    }

    @Override
    public void generate(Exists exists, Node op, boolean negate) {
        if (negate) {
            this.print("NOT ");
        }
        this.print("EXISTS ");
        op.setParenthesis(true);
        this.generateExpr(op);
    }

    @Override
    public void generate(SelectColumns selectColumns) {
        if (selectColumns.isAllColumns()) {
            this.print("*");
        } else {
            Node column = selectColumns.getFirst();
            this.generateCommaDelimited(column);
        }
    }

    @Override
    public void generate(GroupByColumns groupByColumns) {
        this.print("GROUP BY ");
        this.generateCommaDelimited(groupByColumns.getFirst());
    }

    @Override
    public void generate(OrderBy orderBy) {
        this.print("ORDER BY ");
        this.generateCommaDelimited(orderBy.getFirst());
    }

    @Override
    public void generate(Having having) {
        this.print("HAVING ");
        this.generateExpr(having.getFirst());
    }

    @Override
    public void generate(Insert insert) {
        this.generateSeparatorBefore(insert);
        this.print("INSERT INTO ");
        Node table = insert.getTable();
        table.generate(this);
        Node op2 = insert.getOp2();
        Node op3 = insert.getOp3();
        op2.generate(this);
        if (op3 != null) {
            op3.generate(this);
        }
        this.generateSqlStatementSeparator(insert);
        this.generateSeparatorAfter(insert);
    }

    @Override
    public void generate(Insert.Values values) {
        this.println();
        this.print("VALUES ");
        this.print("(");
        this.generateCommaDelimited(values.getFirst());
        this.print(")");
    }

    @Override
    public void generate(Insert.Columns columns) {
        this.print("(");
        this.generateCommaDelimited(columns.getFirst());
        this.print(")");
    }

    @Override
    public void generate(Tables tables) {
        Node table = tables.getFirst();
        while (table != null) {
            table.generate(this);
            if ((table = table.getNext()) == null) continue;
            this.print(", ");
        }
    }

    @Override
    public void generate(Arg arg) {
        this.generateArgument(arg, false);
    }

    @Override
    public void generate(JavaFor javaFor) {
        throw new IllegalStateException("SqlSourceGenerator");
    }

    @Override
    protected SourceGenerator getSqlGenerator() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateSqlWhere(Node where) {
        if (where != null) {
            this.println();
            this.print("WHERE ");
            try {
                this.escapeVariables = true;
                this.generateExpr(where);
            }
            finally {
                this.escapeVariables = false;
            }
        }
    }
}

