/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import fuego.parser.collections.AST;
import java.util.List;
import oracle.bpm.compiler.AmbiguousColumnException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.Function;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.Insert;
import oracle.bpm.compiler.InvalidColumnException;
import oracle.bpm.compiler.InvalidFunctionException;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.MemberReferenceException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.QualifiedName;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.compiler.UndefinedVariableException;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.sql.ColumnReference;

public class SqlColumnReference
extends Node {
    private ColumnReference columnReference;
    private boolean forceParamQualification;

    public SqlColumnReference(Token token) {
        super(token);
    }

    public SqlColumnReference(AST ast) {
        super(ast);
        this.initialize(ast);
        assert (!(ast instanceof MemberReference));
    }

    @Override
    public String getText() {
        return "sqlref";
    }

    @Override
    public String getTypeText() {
        Node op1 = this.getOp1();
        Node op2 = this.getOp2();
        return op1.getTypeText() + (op2 != null ? '.' + op2.getTypeText() : "");
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    static Node updateReferences(Node tree) {
        if (tree instanceof Deref) {
            SqlColumnReference ref = new SqlColumnReference((AST)tree.getOp1());
            ref.copyParentFrom(tree);
            tree.replace(ref);
            return ref;
        }
        if (tree instanceof MemberReference) {
            SqlColumnReference ref = new SqlColumnReference((AST)new QualifiedName((AST)tree.getOp1()));
            ref.copyParentFrom(tree);
            tree.replace(ref);
            return ref;
        }
        for (Node child = tree.getFirst(); child != null; child = child.getNext()) {
            child = SqlColumnReference.updateReferences(child);
        }
        return tree;
    }

    @Override
    void setColumnReference(ColumnReference columnReference) {
        this.columnReference = columnReference;
    }

    @Override
    ColumnReference getColumnReference() {
        return this.columnReference;
    }

    void setForceParamQualification(boolean qualif) {
        this.forceParamQualification = qualif;
    }

    boolean isForceParamQualification() {
        return this.forceParamQualification;
    }

    @Override
    Node checkType() throws TypeException {
        return this.checkType(false);
    }

    Node checkType(boolean onlySqlColumns) throws TypeException {
        Node funct;
        Node deref;
        if (this.getKind() != -1) {
            return this;
        }
        Node qname = this.getOp1();
        if (qname instanceof Const) {
            return new Deref(qname).checkType();
        }
        if (qname instanceof Identifier || qname.childCount() == 1) {
            ColumnReference column;
            Node name = qname instanceof Identifier ? qname : qname.getFirst();
            String id = name.getText();
            ColumnReference columnReference = column = this.isSQLScope() ? this.findColumnInTables(id, onlySqlColumns) : null;
            if (column != null) {
                this.initColumn(column);
            } else {
                if (onlySqlColumns) {
                    throw new InvalidColumnException(name);
                }
                deref = new Deref(name);
                UndefinedVariableException undefined = null;
                try {
                    deref = deref.checkType();
                    if (this.getSQLScope().isOnlyLocal() && deref instanceof MemberAccess) {
                        throw new InvalidColumnException(name);
                    }
                    this.setFirst(deref);
                    this.setTypeDescription(deref.getTypeDescription());
                }
                catch (UndefinedVariableException e) {
                    undefined = e;
                }
                if (undefined != null) {
                    if (this.isSQLScope() && (column = this.findColumnInTables(id, true)) != null) {
                        this.initColumn(column);
                        undefined = null;
                    }
                    if (undefined != null) {
                        throw new InvalidColumnException(name);
                    }
                } else {
                    this.setParametric(true);
                }
            }
        } else {
            Node member = qname.getFirst().getLast();
            StringBuilder result = new StringBuilder();
            for (Node n = qname.getFirst(); n != member; n = n.getNext()) {
                if (result.length() != 0) {
                    result.append('.');
                }
                result.append(n.getTypeText());
            }
            String object = result.toString();
            assert (!object.isEmpty()) : "Invalid object name from : \n" + qname.dump();
            TypeDescription ref = this.findType(object, false);
            if (ref == null) {
                ref = this.findType(object.toUpperCase(), false);
            }
            List<ObjectTypeDescription> tables = this.getSQLScope().getTables();
            if (ref != null && tables.contains(ref.get()) && this.isSQLScope()) {
                TypeDescription type = ref.get();
                String memberName = member.getText();
                MethodTypeDescription memberType = null;
                int count = type.getMemberCount();
                for (int i = 0; i < count; ++i) {
                    MethodTypeDescription attr = type.getMemberType(i);
                    if (!attr.isAttribute() || !attr.getName().equalsIgnoreCase(memberName)) continue;
                    memberType = attr;
                    break;
                }
                if (memberType == null) {
                    memberType = this.findMember(type, memberName, 18, member, true);
                    if (memberType == null) {
                        throw MemberReferenceException.illegallMemberSearchClosest(type, member);
                    }
                    Identifier newName = new Identifier(memberType.getName());
                    newName.initialize(member);
                    member = newName;
                }
                boolean insertParent = this.findParentByClass(Insert.class) != null;
                ColumnReference column = new ColumnReference(type.asObject(), memberType, !insertParent);
                this.setColumnReference(column);
                this.setTypeDescription(memberType.getResultType());
                this.setParametric(false);
                TypeSpec typeSpec = new TypeSpec(ref.get(), qname.getFirst());
                qname.setOperands(typeSpec, member);
            } else {
                if (onlySqlColumns) {
                    throw new InvalidColumnException(qname);
                }
                Node memberRef = SqlColumnReference.createMemberReferences(object, member);
                memberRef.setParent(this);
                memberRef.initialize(this);
                try {
                    memberRef = memberRef.checkType();
                    this.setFirst(memberRef);
                    this.setTypeDescription(memberRef.getTypeDescription());
                }
                catch (UndefinedVariableException e2) {
                    throw new InvalidColumnException(qname);
                }
                this.setParametric(true);
            }
        }
        ColumnReference colRef = this.getColumnReference();
        if (colRef != null && (funct = (Node)this.findParentByClass(Function.class)) != null) {
            if (this.getCurrentLanguage().isFuego1() && qname instanceof Identifier || qname.childCount() == 1) {
                Node name = qname instanceof Identifier ? qname : qname.getFirst();
                try {
                    deref = new Deref(name);
                    deref = deref.checkType();
                    return deref;
                }
                catch (UndefinedVariableException e) {
                    // empty catch block
                }
            }
            throw new InvalidFunctionException(funct, funct.getOp1().getText());
        }
        assert (this.getKind() != -1);
        return this;
    }

    @Override
    List<Node> collectParameters(List<Node> params) {
        if (this.isParametric()) {
            this.setParameter(true);
            params.add(this);
        }
        return params;
    }

    @Override
    void generate(CodeGenerator cg) {
        this.getFirst().gen(cg);
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        sql.append(this.isParameter() ? " ? " : this.getColumnReference().getSignature());
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        return this.getOp1().run(rm);
    }

    private static Node createMemberReferences(String object, Node member) {
        Node objectNode;
        int dot = object.lastIndexOf(46);
        if (dot != -1) {
            String first = object.substring(0, dot);
            String last = object.substring(dot + 1);
            objectNode = SqlColumnReference.createMemberReferences(first, new Identifier(last));
        } else {
            objectNode = new Identifier(object);
        }
        return new MemberReference(objectNode, member);
    }

    private ColumnReference findColumnInTables(String id, boolean closeMatch) throws AmbiguousColumnException {
        ColumnReference column = null;
        Node name = this.getOp1() instanceof Identifier ? this.getOp1() : this.getOp1().getFirst();
        List<ObjectTypeDescription> tables = this.getSQLScope().getTables();
        int length = tables.size();
        for (int i = 0; i < length; ++i) {
            ObjectTypeDescription type = tables.get(i);
            MethodTypeDescription member = null;
            MethodTypeDescription[] members = type.findClosestMembers(id, 0, 18);
            if (!closeMatch) {
                if (members.length == 1 && members[0].getName().equalsIgnoreCase(id)) {
                    member = members[0];
                }
            } else if (members.length == 1 && !(member = members[0]).getName().equalsIgnoreCase(id)) {
                if (this.getCurrentLanguage().isLastVersion()) {
                    this.reportWarning(new MemberReferenceException(this, type, id, member.getName()));
                }
                Identifier replacement = new Identifier(member.getName());
                replacement.initialize(name);
                name.replace(replacement);
            }
            if (member == null) continue;
            if (column != null) {
                throw new AmbiguousColumnException(name);
            }
            boolean insertParent = this.findParentByClass(Insert.class) != null;
            column = new ColumnReference(type, member, !insertParent);
            this.setColumnReference(column);
        }
        if (column == null && !closeMatch && id.indexOf(95) != -1) {
            column = this.findColumnInTables(id, true);
        }
        return column;
    }

    private void initColumn(ColumnReference column) {
        this.setColumnReference(column);
        this.setParametric(false);
        this.setTypeDescription(column.getType());
    }
}

