/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.InvalidAssignmentException;
import oracle.bpm.compiler.InvalidReturnException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.ReturnException;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeFactory;

public class Return
extends Node {
    TypeDescription expectedType;

    public Return(Token t) {
        super(t);
    }

    Return() {
    }

    Return(Node expr) {
        this(expr, null);
    }

    Return(Node expr, TypeDescription td) {
        this.setOperand(expr);
        this.initialize(expr);
        expr.setExpression(true);
        this.expectedType = this.canonicalType(td);
    }

    public static Return expression(Node expr) {
        return new Return(expr);
    }

    @Override
    public String getText() {
        return "return";
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this, this.getFirst());
    }

    @Override
    protected boolean splitToPrint() {
        return true;
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        this.getFirst().checkFlow(context);
        context.breaksFlow(true);
        context.addExit(this.getCurrentMember().getName());
        return context;
    }

    @Override
    Node checkType() throws TypeException {
        if (this.getTypeDescription() == TypeFactory.getNone()) {
            Node expr = this.getFirst();
            if (this.expectedType == null) {
                MethodTypeDescription method = this.getCurrentMember().getMethodType();
                this.expectedType = this.canonicalType(method.isConstructor() ? TypeFactory.getVoid() : method.getResultType());
            }
            if (this.expectedType.isVoid()) {
                this.reportError(new InvalidReturnException(this));
                return this;
            }
            TypeDescription exprType = TypeFactory.getVoid();
            if (expr != null) {
                expr = expr.checkType(this.expectedType);
                exprType = expr.getTypeDescription();
            }
            if (!exprType.equals(this.expectedType) && !this.expectedType.isAssignableFrom(exprType)) {
                this.reportError(new InvalidAssignmentException(expr, exprType, this.expectedType));
            }
            if (expr != null) {
                try {
                    expr = Conversion.promote(expr, this.expectedType);
                    MethodTypeDescription method = this.getCurrentMember().getMethodType();
                    Argument result = method.getResultArgument();
                    if (Modifier.isExternal(result.getModifiers())) {
                        String type = result.getJavaType();
                        expr = Conversion.Export.create(expr, type, this.expectedType).checkType(this.expectedType);
                    }
                    this.setOperand(expr);
                }
                catch (TypeException e) {
                    this.reportError(e);
                    expr.setTypeDescription(this.expectedType);
                }
                exprType = expr.getTypeDescription();
            }
            this.setTypeDescription(exprType);
        }
        return this;
    }

    @Override
    void generate(CodeGenerator cg) {
        cg.generate(this);
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        throw new ReturnException((Node)this, this.getFirst().value(rm));
    }
}

