/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import java.util.List;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.ConstGenerator;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.filter.Operation;

public class NullConst
extends Const {
    public NullConst() {
        this((Token)null);
    }

    public NullConst(Token t) {
        super(t, TypeFactory.getNull());
        this.setPrimitive(true);
    }

    NullConst(Node init) {
        this();
        if (init != null) {
            this.copyParentFrom(init);
            this.initialize(init);
        }
    }

    @Override
    public String getText() {
        return "null";
    }

    @Override
    public void generate(ConstGenerator cg) {
        cg.generate(this);
    }

    @Override
    public String toString() {
        return super.toString() + this.getText();
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    static final boolean equals(Node b) {
        return false;
    }

    @Override
    boolean isCollectable() {
        return false;
    }

    @Override
    Operation getOperationTree() {
        if (this.isParameter()) {
            return new Operation(0, "?", null);
        }
        return new Operation(28, null, null, "null");
    }

    @Override
    List<Node> collectParameters(List<Node> params) {
        this.setParametric(false);
        return super.collectParameters(params);
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        sql.append(this.isParameter() ? " ? " : "NULL");
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        return null;
    }
}

