/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CodeStyle;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Equality;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.Exists;
import oracle.bpm.compiler.Is;
import oracle.bpm.compiler.Logic;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NonBooleanException;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.filter.Operation;

public class Not
extends Node {
    public Not(Token t) {
        super(t);
    }

    Not() {
    }

    public static Node not(Node expr) {
        Not not = new Not();
        not.copyParentFrom(expr);
        not.initialize(expr);
        not.setOperand(expr);
        return not;
    }

    @Override
    public String getText() {
        return "not";
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this, this.getFirst());
    }

    @Override
    Operation getOperationTree() {
        if (this.isParameter()) {
            return new Operation(0, "?", null);
        }
        Operation[] operand = new Operation[]{this.getFirst().getOperationTree()};
        return new Operation(12, "not", operand);
    }

    @Override
    Node checkType() throws TypeException {
        Node result = this;
        if (this.getKind() == -1) {
            this.setTypeDescription(TypeFactory.getPrimitiveBool());
            Node op = this.getFirst();
            op = op.checkType(TypeFactory.getBool());
            if (op.getKind() != 1) {
                this.reportError(new NonBooleanException(op));
            }
            if (!this.isGeneratingSource()) {
                if (op instanceof Not) {
                    result = op.getFirst();
                } else if (op instanceof Logic) {
                    result = op.negate();
                } else if (op.isConstant()) {
                    result = op.negate();
                } else if (op instanceof Is) {
                    Is is = (Is)op;
                    result = is.negate();
                }
            }
            this.setOperand(Conversion.UnBox.create(op).checkType());
        }
        return result;
    }

    @Override
    void generate(CodeGenerator cg) {
        cg.generate(this);
    }

    @Override
    void generateSQLCode(StringBuffer query) {
        if (!(this.getFirst() instanceof Exists) && this.checkParameter(query)) {
            return;
        }
        query.append("( NOT ");
        this.getFirst().generateSQLCode(query);
        query.append(" )");
    }

    @Override
    Node refactor(CodeStyle ss) {
        super.refactor(ss);
        Node op = this.getFirst();
        Node result = this;
        if (ss.getNotBeforeIs() == 2 && op instanceof Is) {
            Is is = (Is)op;
            result = is.negate();
        } else if (ss.isInvertNotEq() && op instanceof Equality) {
            Equality eq = (Equality)op;
            result = eq.negate();
        }
        result.setParenthesis(this.getParenthesis());
        return result;
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        return (Boolean)this.getFirst().value(rm) == false;
    }
}

