/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import fuego.parser.collections.AST;
import java.io.CharArrayWriter;
import java.util.Collection;
import oracle.bpm.bcgen.Mod;
import oracle.bpm.bcgen.ModSet;
import oracle.bpm.cil.CilException;
import oracle.bpm.cil.MessageListener;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.Assignment;
import oracle.bpm.compiler.AutodeclaredException;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.CannotOverrideException;
import oracle.bpm.compiler.ClassConst;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Comment;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.CompilerExceptionShell;
import oracle.bpm.compiler.CompilerParserException;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.ConstantPool;
import oracle.bpm.compiler.Declaration;
import oracle.bpm.compiler.DeprecatedConstructionException;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.DoBlock;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.ExitException;
import oracle.bpm.compiler.ExtractedMethod;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.FormalArgument;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.FuegoInvokeable;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.InvalidAbstractMemberException;
import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.InvalidNameException;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.LocalVar;
import oracle.bpm.compiler.MemberCannotBeCachedException;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.MissingExpressionException;
import oracle.bpm.compiler.MissingReturnException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NullStatement;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.compiler.Return;
import oracle.bpm.compiler.ReturnException;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.RuntimeCompilationException;
import oracle.bpm.compiler.Scope;
import oracle.bpm.compiler.SetElement;
import oracle.bpm.compiler.SetMember;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.SymbolTable;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.compiler.UnusedVariableException;
import oracle.bpm.component.Component;
import oracle.bpm.lang.ArgumentMap;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeFinder;
import oracle.bpm.type.Variable;
import oracle.bpm.util.ArrayUtils;

public class Method
extends DoBlock
implements MessageListener {
    protected boolean compiled;
    MethodTypeDescription overridedMember;
    private ClassConst[] argClasses;
    private CilException firstError;
    private boolean generateAdaptor;
    private LanguageSpec langSpec;
    private MethodTypeDescription memberToReport;
    private MethodTypeDescription methodType;
    private boolean override;
    private int partToReport;
    private int uniqueNumber;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public Method(Token t) {
        super(t);
        this.setTypeDescription(TypeFactory.getVoid());
    }

    public Method(AST name, AST arguments, AST returnType, AST statements) {
        this.initialize(name);
        this.addChild(name);
        this.addChild(arguments);
        if (returnType != null) {
            this.addChild(returnType);
        }
        this.addChild((AST)Block.makeEmpty(this));
        this.addChild(statements);
        this.setTypeDescription(TypeFactory.getNone());
    }

    Method() {
        this((Token)null);
    }

    Method(MethodTypeDescription method) {
        this();
        this.setMethodType(method);
        this.setTypeDescription(method);
    }

    Method(MethodTypeDescription method, Node methodBody) {
        this(method);
        this.setBody(method.getName(), methodBody);
    }

    public ClassConst[] getArgClasses() {
        return this.argClasses;
    }

    public void setGenerateAdaptor(boolean generateAdaptor) {
        this.generateAdaptor = generateAdaptor;
    }

    public boolean isGenerateAdaptor() {
        return this.generateAdaptor || Modifier.isAdaptors(this.getModifiers());
    }

    public MethodTypeDescription getMethodType() {
        return this.methodType;
    }

    public long getModifiers() {
        return this.getMethodType().getModifiers();
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    public boolean isOverride() {
        return this.override;
    }

    public TypeDescription getResultType() {
        return this.getTypeDescription().asMethod().getResultType();
    }

    @Override
    public String getText() {
        return Method.getText(this.getMethodType());
    }

    public Node createArgumentRef(String name) {
        MemberReference argRef = new MemberReference("arg", name);
        argRef.initialize(this);
        return argRef;
    }

    public Invoke createCall(Node init) {
        Identifier method = new Identifier(this.getMethodType().getName());
        Node currentInstance = this.isStatic() ? this.getCurrentClass().createStaticReference(init) : this.getCurrentClass().createReference(init);
        Args args = new Args(1L);
        args.initialize(init);
        method.setSynthetic(true);
        return new Invoke(method, currentInstance, args);
    }

    @Override
    public void reportError(CilException error) {
        this.remap(error);
        if (this.firstError == null) {
            this.firstError = error;
        }
        super.reportError(error);
    }

    @Override
    public void reportWarning(CilException warning) {
        this.remap(warning);
        super.reportWarning(warning);
    }

    @Override
    public Method getCurrentMember() {
        return this;
    }

    @Override
    public Block getDeclarations() {
        Node decl = super.getFirst();
        while (decl instanceof Identifier || decl instanceof FormalArgument) {
            decl = decl.getNext();
        }
        return (Block)decl;
    }

    @Override
    public void setParent(Node parent) {
        super.setParent(parent);
    }

    @Override
    public void generate(SourceGenerator cg) {
        boolean fullParsing = this.getMethodType().isFullParsing();
        if (Modifier.isExpression(this.getMethodType().getModifiers())) {
            Node first = this.getStatements().getFirst();
            if (this.isLValue()) {
                first.generate(cg);
            } else {
                ((Return)first).getFirst().generate(cg);
            }
        } else if (fullParsing) {
            cg.generate(this);
        } else {
            Block exceptions = this.getExceptions();
            if (exceptions != null && exceptions.childCount() > 0 || this.getOnExit() != null) {
                this.setName(null);
                this.getDeclarations().removeChildren();
                cg.generate((DoBlock)this);
            } else {
                this.getStatements().generate(cg);
            }
        }
    }

    public Node getFirstStatement() {
        return this.getFirst().getNext().getNext().getFirst();
    }

    public boolean isTooLong() {
        return this.getSourceCode() != null && this.getSourceCode().getLength() > 60000;
    }

    protected void setMethodType(MethodTypeDescription methodType) {
        this.methodType = methodType;
    }

    protected Collection<Variable> getVariables(MethodTypeDescription method) {
        return method.getVariables();
    }

    protected void checkReturnStatement(FlowContext context) throws MissingReturnException {
        block6: {
            MethodTypeDescription method = this.getMethodType();
            assert (method.isMethod() || method.isTransformation()) : "Not a method: " + method;
            if (!(this.isConstructor() || this.getResultType().isVoid() || method.isAbstract())) {
                FlowContext.Variable resultVar;
                String resultName = method.getResultArgument().getName();
                Declaration resultDecl = this.findDeclaration(resultName);
                FlowContext.Variable variable = resultVar = resultDecl != null ? resultDecl.getVariable() : null;
                if (!context.breaksFlow()) {
                    if (resultDecl == null || !resultVar.isInitalized()) {
                        Node firstSentence = this.getStatements().getFirst();
                        MissingReturnException missingReturnException = new MissingReturnException(firstSentence != null ? firstSentence.getLast() : this, this.getResultType());
                        this.reportError(missingReturnException);
                    }
                    Return result = new Return(new MemberReference("arg", resultName));
                    result.initialize(this);
                    this.getStatements().addChild((AST)result);
                    try {
                        result.checkType();
                    }
                    catch (TypeException e) {
                        if ($assertionsDisabled) break block6;
                        throw new AssertionError((Object)e);
                    }
                }
            }
        }
    }

    protected void checkBusinessRule() {
        MethodTypeDescription mtd = this.getMethodType();
        if (mtd.getProperty("rule.code") != null) {
            mtd.setCode("return " + mtd.getResultType().getText() + "(evaluate(Fuego.Rules.Rule(\"" + mtd.getName() + "\")))", "Fuego");
            FuegoCompiler compiler = this.getCompiler();
            try {
                this.compile(compiler);
            }
            catch (CompilerException e) {
                this.firstError = e;
            }
            if (this.firstError != null) {
                throw new IllegalStateException("Unexpected compiler error", this.firstError);
            }
        }
    }

    static Object[] setArgumentValues(MethodTypeDescription method, Object[] argValues, SymbolTable table) throws IllegalArgumentException {
        if (argValues == null) {
            argValues = EMPTY_ARRAY;
        }
        if (argValues.length != method.getArgumentCount()) {
            String message = "Illegal argument count for method '" + method.getText() + "'. Args: " + ArrayUtils.toString(argValues);
            throw new IllegalArgumentException(message);
        }
        Object[] oldValues = new Object[argValues.length];
        for (int i = 0; i < argValues.length; ++i) {
            Argument arg = method.getArgument(i);
            Object value = argValues[i];
            Symbol symbol = table.getArgument(arg.getName());
            if (arg.isOut() && argValues[i] == null) {
                throw new IllegalArgumentException("Illegal Argument Type, it should be a holder instead of null");
            }
            if (!arg.isOut() && !symbol.isAssignableValue(value)) {
                throw new IllegalArgumentException("Illegal Argument Type: " + JavaClass.classInfo(value) + ", Expected: " + symbol.getJavaClass());
            }
            oldValues[i] = symbol.getValue();
            symbol.setValue(argValues[i]);
        }
        return oldValues;
    }

    static Node extract(Node node, String name) throws TypeException {
        return ExtractedMethod.create(node, name);
    }

    static Node extract(Node node, String name, TypeDescription resultType) throws TypeException {
        return ExtractedMethod.create(node, name, resultType);
    }

    static String getText(MethodTypeDescription member) {
        if (member == null) {
            return "";
        }
        TypeDescription parent = member.getParent();
        return (parent != null ? parent.getText() + '.' : "") + member.getText();
    }

    static void restoreArgumentValues(MethodTypeDescription method, Object[] oldValues, SymbolTable table) {
        int length = method.getArgumentCount();
        for (int i = 0; i < length; ++i) {
            Argument arg = method.getArgument(i);
            Symbol symbol = table.getArgument(arg.getName());
            symbol.setValue(oldValues[i]);
        }
    }

    static String argumentType(Argument arg) {
        String javaType = arg.isOut() ? arg.getHolderJavaType() : (arg.isExternal() ? arg.getJavaType() : arg.getType().javaType());
        return javaType;
    }

    boolean isCompiled() {
        return this.compiled;
    }

    @Override
    String getComponentName() {
        return this.getCurrentClass().getTypeDescription().getText();
    }

    boolean isConstructor() {
        return this.getMethodType() != null && this.getMethodType().isConstructor();
    }

    Adaptor getDynamicObjectAdaptor() {
        Adaptor adaptor = new Adaptor();
        adaptor.setParent(this);
        return adaptor;
    }

    String getFullName() {
        String prefix = "";
        MethodTypeDescription methodType = this.getMethodType();
        if (!this.isConstructor()) {
            prefix = methodType.getPrefix();
        }
        return prefix + methodType.getName();
    }

    boolean isGetter() {
        return false;
    }

    String getJavaSignature() {
        return this.getMethodType().getJavaSignature();
    }

    LanguageSpec getLanguageSpec() {
        block3: {
            if (this.langSpec == null) {
                try {
                    this.langSpec = LanguageSpec.getLanguageSpec(this.getMethodType().getCodeLanguage());
                }
                catch (InvalidLanguageException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)e.toString());
                }
            }
        }
        return this.langSpec;
    }

    void setMemberPartToReport(int partToReport) {
        this.partToReport = partToReport;
    }

    void setMemberToReport(MethodTypeDescription memberToReport) {
        this.memberToReport = memberToReport;
    }

    MethodTypeDescription getMemberToReport() {
        return this.memberToReport == null ? this.getMethodType() : this.memberToReport;
    }

    int getPartToReport() {
        return this.partToReport;
    }

    boolean isAccessor() {
        return this.isGetter() || this.isSetter();
    }

    boolean isRunsOnServer() {
        return Modifier.isServer(this.getModifiers());
    }

    boolean isSetter() {
        return false;
    }

    boolean isStatic() {
        return Modifier.isStatic(this.getModifiers()) && !this.isConstructor();
    }

    Symbol getArgument(String name) {
        return this.getSymbolTable().getArgument(name);
    }

    @Override
    boolean isTopLevel() {
        return true;
    }

    @Override
    int getUniqueNumber() {
        return this.uniqueNumber++;
    }

    void addDeclarationsForVariables(MethodTypeDescription method) {
        Node current;
        for (current = this.getFirst(); current != null && !(current instanceof Block); current = current.getNext()) {
        }
        Block declarations = (Block)current;
        Declaration first = null;
        Node last = null;
        Scope scope = this.getScope();
        for (Variable var : this.getVariables(method)) {
            Declaration decl = new Declaration(var);
            if (scope != null) {
                decl.setScope(scope);
            }
            if (first == null) {
                first = decl;
            } else {
                last.setNext(decl);
            }
            last = decl;
        }
        if (first != null && declarations != null) {
            Node firstChild = declarations.getFirst();
            if (firstChild == null) {
                declarations.setFirst(first);
            } else {
                firstChild.getLast().setNext(first);
            }
        }
    }

    @Override
    LocalVar autodeclareLocal(Node source, String name, TypeDescription type, boolean silent) {
        LocalVar local = super.autodeclareLocal(source, name, type, silent);
        if (!silent) {
            this.reportWarning(new AutodeclaredException(local, local.getSymbol(), this.getMethodType()));
        }
        return local;
    }

    void checkArgs() throws TypeException {
        Symbol symbol;
        MethodTypeDescription method = this.getMethodType();
        int argc = method.getArgumentCount();
        ClassConst[] argClasses = new ClassConst[argc];
        boolean isCached = method.hasModifiers(0x10000000000L);
        SymbolTable symbols = this.getSymbolTable();
        if (isCached && !method.isStatic()) {
            this.reportError(new MemberCannotBeCachedException((Node)this, method));
        }
        for (int i = 0; i < argc; ++i) {
            Argument arg = method.getArgument(i);
            arg.setNumber(i);
            symbol = symbols.putArgument(arg, Method.argSignature(arg));
            if (arg.isOut() && !arg.isIn()) {
                this.addDeclaration(symbol);
            }
            TypeDescription argType = arg.getType();
            TypeSpec.checkValid(argType, this);
            if (isCached && arg.isOut() && !argType.isPredefined()) {
                this.reportError(new MemberCannotBeCachedException(this, method, arg));
            }
            if (argType.isPrimitive() && argType.getKind() != 12) continue;
            argClasses[i] = new ClassConst(argType, (Node)this);
        }
        TypeDescription resultType = method.getResultType();
        if (!resultType.isVoid()) {
            Argument result = method.getResultArgument();
            TypeSpec.checkValid(resultType, this);
            if (isCached && !resultType.isPredefined()) {
                this.reportError(new MemberCannotBeCachedException(this, method, result));
            }
            if (result.getName() != null) {
                symbol = symbols.putArgument(result, Method.argSignature(result));
                this.addDeclaration(symbol);
            }
        }
        this.argClasses = argClasses;
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        Symbol[] args;
        this.compiled = true;
        SymbolTable symbols = this.getSymbolTable();
        for (Symbol symbol : args = symbols.getArguments()) {
            Argument arg = symbol.getArgument();
            if (!arg.isIn()) continue;
            context.defineVariable(symbol, true);
        }
        context = super.checkFlow(context);
        this.checkReturnStatement(context);
        for (Declaration decl = (Declaration)this.getDeclarations().getFirst(); decl != null; decl = (Declaration)decl.getNext()) {
            boolean isUnused;
            String name = decl.getName();
            boolean bl = isUnused = !decl.isUsed() && symbols.get(name) != null && !symbols.get(name).isSilentAutoDeclared();
            if (!isUnused || this.getCompiler().getDirective(2048)) continue;
            this.reportWarning(new UnusedVariableException(decl));
        }
        return context;
    }

    @Override
    Node checkType() throws TypeException {
        MethodTypeDescription member;
        Node id = this.assignName();
        Node current = id.getNext();
        while (current instanceof FormalArgument) {
            current.checkType();
            current = current.getNext();
        }
        id.setNext(current);
        this.checkArgs();
        if (this.isLValue()) {
            try {
                this.checkTypeLValue();
            }
            catch (TypeException exception) {
                this.reportError(exception);
            }
            return this;
        }
        ObjectClass currentClass = this.getCurrentClass();
        TypeDescription currentType = currentClass.getTypeDescription();
        MethodTypeDescription method = this.getMethodType();
        if (method.isAbstract() && !currentClass.isAbstract()) {
            this.reportError(new InvalidAbstractMemberException(this, method, currentType));
        }
        for (member = method.findIn(currentType, TypeFinder.Scope.INHERITED); member != null && !method.overrides(member); member = member.getNextMethod()) {
        }
        if (member != null) {
            this.setOverride(true);
            this.overridedMember = member;
            this.setWrapTypedExceptions(true);
            if (!method.getResultType().equals(member.getResultType())) {
                this.reportError(new CannotOverrideException(this, method, member));
            }
        }
        this.getSymbolTable().setForceArgQualification(method.isForceArgQualification());
        this.setTypeDescription(method);
        if (method.isAbstract()) {
            for (Node node = this.getStatements().getFirst(); node != null; node = node.getNext()) {
                boolean isCode;
                boolean bl = isCode = !(node instanceof Comment) && !(node instanceof NullStatement);
                if (!isCode) continue;
                this.reportError(new InvalidAbstractMemberException(node, method));
                break;
            }
        }
        super.checkType();
        Block exceptions = this.getExceptions();
        if (exceptions != null && exceptions.childCount() > 0 && this.getCurrentLanguage().isLastVersion()) {
            this.reportWarning(new DeprecatedConstructionException(exceptions.getFirst()));
        }
        if (!this.isGeneratingSource() && method.isAbstract() && !this.getResultType().equals(TypeFactory.getVoid())) {
            Return returnConst = new Return(Const.defaultValue(this.getResultType(), null));
            this.getStatements().addChild((AST)returnConst);
            ((Node)returnConst).checkType();
        }
        return this;
    }

    @Override
    void collectConstants(ConstantPool cp) {
        super.collectConstants(cp);
        if (this.argClasses != null) {
            for (ClassConst classConst : this.argClasses) {
                if (classConst == null) continue;
                classConst.collectConstants(cp);
            }
        }
    }

    @Override
    Node compile(FuegoCompiler compiler) throws CompilerException {
        this.compiled = true;
        return super.compile(compiler);
    }

    @Override
    Method findCurrentMember() {
        return this;
    }

    @Override
    void generate(CodeGenerator cg) {
        this.checkBusinessRule();
        cg.generate(this);
    }

    String[] outputArgumentsRequest() {
        String[] result;
        MethodTypeDescription methodType = this.getMethodType();
        int argc = 0;
        for (int i = 0; i < methodType.getArgumentCount(); ++i) {
            if (!methodType.getArgument(i).isOut()) continue;
            ++argc;
        }
        if (argc == 0) {
            result = null;
        } else {
            result = new String[argc];
            argc = 0;
            for (int i = 0; i < methodType.getArgumentCount(); ++i) {
                if (!methodType.getArgument(i).isOut()) continue;
                result[argc++] = "#" + i;
            }
        }
        return result;
    }

    boolean overridesFuegoObject() {
        return this.overridedMember != null && this.overridedMember.belongsToFuegoObject();
    }

    @Override
    void parse(FuegoCompiler compiler) throws CompilerException {
        Node node;
        MethodTypeDescription method = this.getMethodType();
        boolean isExpression = method.isExpression();
        char[] source = method.getCodeText();
        if ((source != null || isExpression) && !method.isAbstract()) {
            this.getSymbolTable().clear();
            if (this.symbols != null) {
                this.symbols.clear();
            }
            this.setFirst(null);
            try {
                if (isExpression) {
                    Node newBody;
                    node = compiler.parse(method.getCode(), this);
                    if (node == null && !method.hasModifiers(0x80000000L)) {
                        throw new MissingExpressionException(this);
                    }
                    if (this.isLValue()) {
                        Identifier id = new Identifier("value$0");
                        newBody = new Assignment(node, new Deref(id));
                    } else {
                        newBody = new Return(node);
                    }
                    newBody.setSynthetic(true);
                    this.setBody(method.getName(), newBody);
                } else {
                    node = compiler.parseMethod(method.getCode(), method.isFullParsing(), this);
                    if (method.isFullParsing()) {
                        Node current = node.getFirst();
                        this.setFirst(current);
                    } else {
                        Node exceptions = node.getNext();
                        this.setBody(method.getName(), node);
                        if (exceptions != null) {
                            this.getExceptions().replace(exceptions);
                        }
                    }
                }
            }
            catch (CompilerParserException e) {
                e.setMember(method);
                this.reportError(e);
            }
        }
        if (this.getFirst() == null || method.isAbstract()) {
            this.setBody(method.getName(), NullStatement.NODE);
        }
        this.addDeclarationsForVariables(method);
        for (node = this.getFirst(); node != null; node = node.getNext()) {
            node.setScope(this.getScope());
        }
    }

    ModSet getAccessModifiers() {
        long v = this.getModifiers() & 0xE000L;
        Mod result = v == 0L || Modifier.isPublic(v) || this.getMethodType().getParent().isInnerType() ? Mod.PUBLIC : (Modifier.isPrivate(v) ? Mod.PUBLIC : (Modifier.isProtected(v) ? Mod.PROTECTED : Mod.PACKAGE));
        return this.isStatic() ? result.STATIC() : result;
    }

    void rewrite() throws CompilerException {
        LanguageSpec languageSpec = LanguageSpec.getLanguageSpec(this.getMethodType().getCodeLanguage());
        this.rewrite(languageSpec.getLatest());
    }

    @Override
    Object run(RunningMonitor rm, Object[] argValues, FuegoInvokeable instance) throws ExecutionException {
        ObjectClass currentClass = this.getCurrentClass();
        if (!this.isCompiled()) {
            try {
                this.compile(this.getCompiler());
            }
            catch (CompilerException e) {
                throw new RuntimeCompilationException(this, this.getComponentName(), this.getName(), e);
            }
            if (this.firstError != null) {
                throw new RuntimeCompilationException(this, this.getComponentName(), this.getName(), this.firstError);
            }
        }
        MethodTypeDescription member = this.getMethodType();
        rm.beginEvent(member);
        Object[] oldValues = null;
        SymbolTable symbols = this.getSymbolTable();
        FuegoInvokeable prev = currentClass.getCurrentInvokeable();
        String location = Component.getLocation();
        try {
            oldValues = Method.setArgumentValues(member, argValues, symbols);
            currentClass.setCurrentInvokeable(instance);
            if (member.hasModifiers(65536L)) {
                Component.setLocation("SERVER");
            }
            super.run(rm);
            assert (currentClass.getCurrentInvokeable() == instance);
            if (this.isConstructor()) {
                rm.endEvent(member);
                FuegoInvokeable fuegoInvokeable = currentClass.getCurrentInvokeable();
                return fuegoInvokeable;
            }
        }
        catch (ExitException exec) {
        }
        catch (ExecutionException exec) {
            if (exec.getNode() == null) {
                exec.setNode(this);
            }
            exec.setMember(member);
            exec.addStackFrame(member);
            rm.endEvent(member);
            if (exec instanceof ReturnException) {
                ReturnException ret = (ReturnException)exec;
                Object object = ret.getValue();
                return object;
            }
            throw exec;
        }
        catch (Throwable e) {
            rm.endEvent(member);
            throw new CompilerExceptionShell((Node)this, e);
        }
        finally {
            Component.setLocation(location);
            if (oldValues != null) {
                Method.restoreArgumentValues(member, oldValues, symbols);
            }
            currentClass.setCurrentInvokeable(prev);
        }
        rm.endEvent(member);
        return null;
    }

    private static String argSignature(Argument arg) {
        return "arg$" + arg.getName() + (arg.isOut() ? ".value" : "");
    }

    private void checkTypeLValue() throws TypeException {
        Block statements = this.getStatements();
        Node first = statements.getFirst();
        if (!(first instanceof Assignment)) {
            return;
        }
        Assignment assig = (Assignment)first;
        Node checked = assig.checkType();
        if (!(checked instanceof SetMember) && !(checked instanceof SetElement)) {
            this.reportError(assig.invalidAssignment(checked.getFirst()));
        }
        statements.setFirst(checked);
    }

    private boolean isLValue() {
        long mods = this.getMethodType().getModifiers();
        return Modifier.isExpression(mods) && Modifier.isLValue(mods);
    }

    private Node assignName() throws InvalidNameException {
        Node id = this.getFirst();
        String name = this.getMethodType().getName();
        if (name == null || name.isEmpty()) {
            name = id.getText();
            this.getMethodType().setName(name);
        }
        if (!Str.isValidJavaIdentifier(name)) {
            throw new InvalidNameException((Node)this, this.getMethodType());
        }
        return id;
    }

    private void remap(CilException error) {
        TypeDescription errorMember = error.getMember();
        if (this.memberToReport != null && (errorMember == null || errorMember == this.getMethodType())) {
            error.setMember(this.memberToReport);
            error.setMemberPart(this.partToReport);
        } else if (errorMember == null) {
            error.setMember(this.getMethodType());
        }
    }

    private void rewrite(LanguageSpec languageSpec) {
        MethodTypeDescription member = this.getMethodType();
        SourceGenerator generator = languageSpec.createSourceGenerator();
        CharArrayWriter out = new CharArrayWriter();
        generator.setWriter(out);
        this.generate(generator);
        generator.close();
        member.setCode(out.toCharArray(), languageSpec.getId());
    }

    class Adaptor
    extends Method {
        Adaptor() {
            this.initialize(Method.this);
        }

        @Override
        public MethodTypeDescription getMethodType() {
            return Method.this.getMethodType();
        }

        @Override
        String getJavaSignature() {
            StringBuilder signature = new StringBuilder();
            if (Method.this.isConstructor()) {
                signature.append('K');
                signature.append(Method.this.getMethodType().getParent().getJavaType());
            } else {
                signature.append('M');
                signature.append(Method.this.getFullName());
            }
            signature.append("(Loracle.bpm.lang.ArgumentMap;)");
            if (!Method.this.isConstructor()) {
                signature.append(Method.this.getMethodType().getResultArgument().getJavaSignature());
            }
            return signature.toString();
        }

        @Override
        Object run(RunningMonitor rm, Object[] argValues, FuegoInvokeable instance) throws ExecutionException {
            try {
                int length;
                int n = length = argValues != null ? argValues.length : 0;
                if (length != 1 || !(argValues[0] instanceof ArgumentMap)) {
                    throw new IllegalArgumentException();
                }
                ArgumentMap dynamic = (ArgumentMap)argValues[0];
                int argc = this.getMethodType().getArgumentCount();
                argValues = new Object[argc];
                for (int i = 0; i < argc; ++i) {
                    Argument arg = this.getMethodType().getArgument(i);
                    TypeDescription argType = arg.getType();
                    Class<?> javaClass = argType.getJavaClass();
                    javaClass = javaClass != null ? javaClass : Object.class;
                    argValues[i] = dynamic.getArgument(arg.getName(), javaClass);
                    if (!arg.isOut()) continue;
                    Class<?> cl = Class.forName(arg.getHolderJavaType());
                    Object holder = cl.newInstance();
                    if (!argType.isPrimitive() || argValues[i] != null) {
                        this.setHolderValue(holder, argValues[i]);
                    }
                    argValues[i] = holder;
                }
                return Method.this.run(rm, argValues, instance);
            }
            catch (ReturnException e) {
                return e.getValue();
            }
            catch (ExecutionException e) {
                throw e;
            }
            catch (Throwable e) {
                if (Log.isDebugging()) {
                    Log.logDebug(e);
                }
                throw new CompilerExceptionShell((Node)this, e);
            }
        }
    }
}

