/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.util.List;
import oracle.bpm.bcgen.LocalVariable;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.ExtractedMethod;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.compiler.Parameter;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.TypeDescription;

public class LocalVar
extends Node {
    private boolean delegated;
    private Node sourceId;
    private Symbol symbol;

    LocalVar(Symbol symbol, Node id) {
        this(symbol, id, false);
    }

    LocalVar(Symbol symbol, Node id, boolean delegated) {
        assert (symbol != null) : "Symbol must not be null";
        assert (!(id instanceof ObjectClass));
        if (id != null) {
            this.copyParentFrom(id);
        }
        this.symbol = symbol;
        this.delegated = delegated;
        this.sourceId = id;
        this.setTypeDescription(symbol.getType());
        this.initialize(id);
        this.copyTreePositionFrom(id);
    }

    public boolean isDelegated() {
        return this.delegated;
    }

    @Override
    public Symbol getSymbol() {
        return this.symbol;
    }

    @Override
    public Node getTargetValue() {
        return this;
    }

    @Override
    public String getText() {
        return this.symbol.getName();
    }

    @Override
    public void generate(SourceGenerator cg) {
        if (this.sourceId != null && !this.mustRename() && !(this.sourceId instanceof Parameter)) {
            this.sourceId.generate(cg);
        } else {
            cg.generate(this, this.symbol);
        }
    }

    static LocalVar create(String prefix, TypeDescription td, Node orig) throws TypeException {
        Identifier id = new Identifier(prefix + '$' + orig.getUniqueNumber(), orig.getScope());
        id.copyParentFrom(orig);
        id.initialize(orig);
        return (LocalVar)id.getAutoDeclared(td, true, true);
    }

    void setSourceId(Node sourceId) {
        this.sourceId = sourceId;
    }

    Node getSourceId() {
        return this.sourceId;
    }

    @Override
    boolean isComplexExpression() {
        return false;
    }

    boolean isCurrentReference() {
        return this.sourceId instanceof Identifier.This || this.symbol != null && this.symbol == this.getThis();
    }

    @Override
    TypeDescription getDeclaration() {
        if (this.symbol.isSilentAutoDeclared()) {
            return this.getTypeDescription();
        }
        this.getCurrentDoBlock();
        return null;
    }

    LocalVariable getLocalVariable() {
        return this.symbol.getLocalVariable();
    }

    String getSignature() {
        return this.symbol.getSignature();
    }

    Symbol getTarget() {
        return this.delegated ? this.symbol.getTarget() : this.symbol;
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        context.use(this.symbol, (Node)this);
        context.breaksFlow(false);
        return context;
    }

    @Override
    List<Node> collectParameters(List<Node> params) {
        if (this.isParametric()) {
            this.setParameter(true);
            params.add(this);
        }
        return params;
    }

    @Override
    void extractArguments(ExtractedMethod method) {
        method.addOutputArgument(this);
    }

    @Override
    void generate(CodeGenerator cg) {
        cg.generate(this);
    }

    @Override
    void generateSQLCode(StringBuffer query) {
        query.append(this.symbol.getName());
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        if (this.symbol.isArgument()) {
            return this.symbol;
        }
        String name = this.symbol.getName();
        Symbol s = this.getSymbolTable().get(name);
        assert (s != null) : "Missing symbol '" + name + "' in " + this.getSymbolTable() + ". \n" + this.dumpContext();
        return this.delegated ? s.getTarget() : s;
    }

    private boolean mustRename() {
        return this.symbol != null && this.symbol.getReplacement() != null;
    }
}

