/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.math.BigDecimal;
import oracle.bpm.compiler.ArrayConst;
import oracle.bpm.compiler.BoolConst;
import oracle.bpm.compiler.ClassConst;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.ConstGenerator;
import oracle.bpm.compiler.DecimalConst;
import oracle.bpm.compiler.DefaultConst;
import oracle.bpm.compiler.EnumConst;
import oracle.bpm.compiler.IntConst;
import oracle.bpm.compiler.IntervalConst;
import oracle.bpm.compiler.JavaGenerator;
import oracle.bpm.compiler.JavaPrintWriter;
import oracle.bpm.compiler.NullConst;
import oracle.bpm.compiler.RealConst;
import oracle.bpm.compiler.RegExpConst;
import oracle.bpm.compiler.StringConst;
import oracle.bpm.compiler.TimeConst;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;

class JavaConstGenerator
implements ConstGenerator {
    private final JavaGenerator jg;
    private final JavaPrintWriter pw;

    JavaConstGenerator(JavaGenerator javaGenerator) {
        this.jg = javaGenerator;
        this.pw = javaGenerator.pw;
    }

    @Override
    public void generate(BoolConst c) {
        this.pw.print(c.isPrimitive() ? c.getText() : "Boolean." + c.getText().toUpperCase());
    }

    @Override
    public void generate(DefaultConst c) {
        TypeDescription type = c.getTypeDescription();
        if (type.isObject() && c.hasChildren()) {
            c.getFirst().gen(this.jg);
        } else if (type.isArray() && DefaultConst.isGroupArray(type)) {
            TypeDescription elementType = type.getElementType();
            String elementJavaType = elementType.getJavaType();
            String constructor = elementType.findMember(elementType.getName()).getJavaSignature();
            this.pw.print("new " + type.getJavaType());
            this.pw.print("(JavaClass.fromClass(");
            this.pw.printJavaType(elementJavaType);
            this.pw.print(".class), ");
            this.pw.printQuoted(constructor);
            this.pw.print(", new Object[] { this })");
        } else {
            this.pw.print(type.getInitialization().javaInitString(type));
        }
    }

    @Override
    public void generate(StringConst c) {
        this.pw.printQuoted(Str.escape(c.value));
    }

    @Override
    public void generate(NullConst c) {
        this.pw.print("null");
    }

    @Override
    public void generate(ArrayConst c) {
        if (c.isMap() || !c.isPrimitive()) {
            this.initializeArray(c, c.isMap() ? (c.isOrdered() ? "asTreeMap" : "asMap") : "asList");
        } else {
            this.pw.print(" new ");
            this.pw.printJavaType(c.getTypeDescription());
            if (c.hasChildren()) {
                this.pw.print("{");
                this.jg.generateCommaDelimitedCode(c.getFirst(), this.pw);
                this.pw.print("}");
            }
        }
    }

    @Override
    public void generate(ClassConst c) {
        this.pw.printJavaType(c.getText());
        this.pw.print(".class");
    }

    @Override
    public void generate(DecimalConst c) {
        long lv = c.value.longValue();
        if (BigDecimal.valueOf(lv).equals(c.value)) {
            this.pw.print("BigDecimal.valueOf(" + lv + "L)");
        } else {
            this.pw.print("new BigDecimal(\"" + c.value + "\")");
        }
    }

    @Override
    public void generate(EnumConst c) {
        this.pw.print(c.isNativeEnum() ? c.getText() : (c.isPrimitive() ? c.getValue() : "Int.valueOf(" + c.getValue() + ')'));
    }

    @Override
    public void generate(IntervalConst c) {
        String txt = c.getText();
        if (txt.isEmpty()) {
            this.pw.print("Interval.valueOf(0)");
        } else {
            this.pw.print("Interval.valueOf(\"" + txt + "\")");
        }
    }

    @Override
    public void generate(RealConst c) {
        TypeDescription typeDescription = c.getTypeDescription();
        if (typeDescription.isPrimitive()) {
            this.pw.print(c.getText());
            if (typeDescription == TypeFactory.getPrimitiveReal(32)) {
                this.pw.print("f");
            }
        } else {
            this.pw.print("new ");
            this.pw.printJavaType(typeDescription);
            this.pw.print("(");
            this.pw.print(c.getText());
            if (typeDescription == TypeFactory.getReal(32)) {
                this.pw.print("f");
            }
            this.pw.print(")");
        }
    }

    @Override
    public void generate(RegExpConst c) {
        JavaPrintWriter pw1 = this.pw;
        pw1.print("RegExp.valueOf(");
        if (c.value == null) {
            pw1.print("null");
        } else {
            pw1.printQuoted(Str.escape(c.value));
        }
        pw1.print(")");
    }

    @Override
    public void generate(TimeConst c) {
        this.pw.print(c.getValue() == null ? "Time.now()" : "Time.valueOf(\"" + c.getText() + "\")");
    }

    @Override
    public void generate(IntConst c) {
        boolean object;
        TypeDescription typeDescription = c.getTypeDescription();
        boolean bl = object = !typeDescription.isPrimitive();
        if (object) {
            this.pw.print("new " + typeDescription.getJavaType());
            this.pw.print("(");
        }
        if (typeDescription.getLength() < 32) {
            this.pw.printJavaCast(typeDescription.primitiveEquivalent(true));
        }
        this.pw.print(c.getText());
        if (typeDescription.getLength() == 64) {
            this.pw.print("L");
        }
        if (object) {
            this.pw.print(")");
        }
    }

    @Override
    public void generate(Const c) {
        String collectedConstant = c.getConstantFieldName();
        if (collectedConstant == null) {
            c.generate(this);
        } else if (c.mustClone()) {
            this.pw.print('(');
            this.pw.printJavaCast(c.getTypeDescription());
            this.pw.print("Any.clone(");
            this.pw.print(collectedConstant);
            this.pw.print(')');
            this.pw.print(')');
        } else {
            this.pw.print(collectedConstant);
        }
    }

    private void initializeArray(ArrayConst c, String method) {
        this.pw.print("ArrayUtils." + method);
        this.pw.print("(new Object[] {");
        this.jg.generateCommaDelimitedCode(c.getFirst(), this.pw);
        this.pw.print("})");
    }
}

