/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import fuego.parser.collections.AST;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.compiler.ArrayReference;
import oracle.bpm.compiler.Assignment;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.ConstantAssignmentException;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.EnumConst;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.Function;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.IncompatibleInputOptionsException;
import oracle.bpm.compiler.IntConst;
import oracle.bpm.compiler.InvalidOperandException;
import oracle.bpm.compiler.InvalidOptionException;
import oracle.bpm.compiler.LocalVar;
import oracle.bpm.compiler.MissingOptionValueException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NotAllowedOptionValueException;
import oracle.bpm.compiler.NullConst;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SetElement;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.StringConst;
import oracle.bpm.compiler.TimeConst;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.UndefinedVariableException;
import oracle.bpm.compiler.ValidValuesException;
import oracle.bpm.lang.EnumTypeDescription;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.IntervalUnit;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.util.ArrayUtils;
import org.jetbrains.annotations.NonNls;

public class InputField
extends Node {
    private Node array;
    private int fieldNumber;
    private Node getResult;
    private Node label;
    private List<Node> options;
    private Node origArray;
    private Node original;
    private Node promoted;
    private Node typeNode;
    private Node var;
    static final String TEXTAREA = "textarea";
    static final String REQUIRED = "required";
    static final String READONLY = "readonly";
    static final String RADIO = "radio";
    static final String PASSWORD = "password";
    static final String DATE = "date";
    static final String TIME = "time";
    static final List<String> VALID_OPTIONS;
    static final List<String> INTERVAL_OPTIONS;
    private static final String[] VALUE_OPTIONS;

    public InputField(Token t) {
        super(t);
    }

    public InputField(AST ast) {
        super(ast);
    }

    InputField() {
    }

    InputField(Node name, Node variable) {
        this.setFirst(name);
        name.setNext(variable);
        this.initialize(variable);
    }

    @Override
    @NonNls
    public String getText() {
        return "input-field";
    }

    @Override
    public void generate(SourceGenerator cg) {
        Node var;
        Node label;
        if (this.getKind() != -1) {
            label = this.getLabelNode();
            var = this.getVar();
        } else {
            label = this.getOp1();
            var = this.getOp2();
        }
        cg.generate(this, label, var, (List<Node>)(this.options != null ? new ArrayList<Node>(this.options) : null), this.origArray);
    }

    @Override
    Node checkType() throws TypeException {
        TypeDescription fieldType;
        TypeDescription type;
        Node options;
        block43: {
            block42: {
                boolean ispredefined;
                this.label = this.getFirst();
                this.var = this.getFirst().getNext();
                if (this.var == null) {
                    this.var = this.label;
                    this.label = null;
                }
                this.original = Node.deepCopy(this.var);
                options = this.var.getNext();
                if (options != null) {
                    if (options instanceof Function) {
                        this.array = options.getNext();
                    } else {
                        this.array = options;
                        options = null;
                    }
                    if (this.array != null) {
                        this.array = this.array.getFirst();
                    }
                }
                this.var = this.var.checkType();
                if (this.var == null) {
                    throw new UndefinedVariableException(this.getFirst().getNext());
                }
                type = this.var.getTypeDescription();
                int kind = type.getKind();
                TypeDescription ftype = kind == 12 ? type.getElementType() : type;
                boolean bl = ispredefined = ftype.isPredefined() && ftype.getKind() != 8;
                if (!(ispredefined && kind != 10 || kind == 17)) {
                    throw new InvalidOperandException(this.var, "input", type);
                }
                if (this.var.isConstant() || this.var instanceof TimeConst) {
                    throw new ConstantAssignmentException(this.var);
                }
                fieldType = type;
                if (fieldType.isArray()) {
                    fieldType = fieldType.getElementType();
                }
                if (this.array == null) break block42;
                Node arr = this.array;
                this.array = this.array.checkType();
                if (this.array == null) {
                    throw new UndefinedVariableException(arr);
                }
                TypeDescription arrayType = this.array.getTypeDescription();
                TypeDescription elemType = arrayType.getElementType();
                TypeDescription indexType = arrayType.getIndexType();
                switch (arrayType.getKind()) {
                    case 12: {
                        if (!fieldType.isAssignableFrom(elemType)) {
                            throw new ValidValuesException(this.array, elemType, fieldType, this.var.getText(), 12);
                        }
                        this.array = Conversion.promote(this.array, TypeFactory.getArray(fieldType));
                        break;
                    }
                    case 13: {
                        if (!fieldType.isAssignableFrom(indexType)) {
                            throw new ValidValuesException(this.array, indexType, fieldType, this.var.getText(), 13);
                        }
                        break block43;
                    }
                    default: {
                        throw new InvalidOperandException(this.array, "in", arrayType.getKind());
                    }
                }
                break block43;
            }
            this.array = new NullConst(this);
        }
        this.origArray = this.array;
        if (fieldType.isEnum() && this.array.getKind() != 13) {
            this.array = EnumConst.makeRestrictedLabelMap((EnumTypeDescription)fieldType, this.array);
        }
        if (this.array.getKind() == 13) {
            fieldType = this.array.getTypeDescription().getElementType();
        }
        if (this.label != null) {
            Node originalLabel = this.label;
            this.label = this.label.checkType();
            if (this.label == null) {
                throw new UndefinedVariableException(originalLabel);
            }
            if (this.label.getKind() != 5) {
                throw new InvalidOperandException((Node)this, this.label.getKind());
            }
        } else {
            this.label = new StringConst(this.var.getText(), this);
            this.label.initialize(this.var);
        }
        this.options = CollectionPool.getLinkedList();
        List<String> opts = CollectionPool.getLinkedList();
        if (options != null) {
            for (Node currentOption = options.getFirst(); currentOption != null; currentOption = currentOption.getNext()) {
                String option;
                String value;
                if (currentOption.isCompletion()) {
                    currentOption.complete(7, this);
                }
                if (currentOption instanceof Assignment) {
                    value = currentOption.getOp2().getText();
                    option = currentOption.getOp1().getText();
                } else {
                    value = null;
                    option = currentOption.getText();
                }
                option = option.toLowerCase();
                if (!VALID_OPTIONS.contains(option)) {
                    throw new InvalidOptionException(currentOption);
                }
                boolean valueOption = ArrayUtils.contains(VALUE_OPTIONS, (Object)option);
                if (value == null && valueOption) {
                    throw new MissingOptionValueException(currentOption);
                }
                if (value != null && !valueOption) {
                    throw new NotAllowedOptionValueException(currentOption);
                }
                if (option.equals(TEXTAREA) && !fieldType.isString()) {
                    throw new InvalidOptionException(currentOption, fieldType);
                }
                if (option.equals(PASSWORD) && !fieldType.isString()) {
                    throw new InvalidOptionException(currentOption, fieldType);
                }
                if ((option.equals(DATE) || option.equals(TIME)) && !fieldType.isTime()) {
                    throw new InvalidOptionException(currentOption, fieldType);
                }
                if (INTERVAL_OPTIONS.contains(option) && fieldType.getKind() != 7) {
                    throw new InvalidOptionException(currentOption, fieldType);
                }
                if (option.equals(REQUIRED) && opts.contains(READONLY)) {
                    throw new IncompatibleInputOptionsException(currentOption, READONLY);
                }
                if (option.equals(READONLY) && opts.contains(REQUIRED)) {
                    throw new IncompatibleInputOptionsException(currentOption, REQUIRED);
                }
                if (option.equals(RADIO) && this.array == null) {
                    throw new InvalidOptionException(currentOption, fieldType);
                }
                if (value == null) {
                    opts.add(option);
                    continue;
                }
                opts.add(option + ':' + value);
            }
            for (String opt : opts) {
                this.options.add(new StringConst(opt, this));
            }
        }
        if (fieldType.isEnum() && !opts.contains(READONLY)) {
            StringConst strConst = new StringConst(READONLY, this);
            strConst.setSynthetic(true);
            this.options.add(strConst);
        }
        if (this.var instanceof LocalVar) {
            this.var = new Deref(this.var).checkType();
        }
        this.promoted = Conversion.promote(this.var, type.primitiveEquivalent(false));
        String typeText = this.var.getTypeDescription().getText();
        if (this.var.getTypeDescription().isEnum()) {
            typeText = "Int";
        }
        this.typeNode = new StringConst(typeText);
        this.typeNode.setScope(this.getScope());
        ArrayReference returnedValue = new ArrayReference();
        returnedValue.setOperands(new Identifier("CILInputResult"), new IntConst((long)this.fieldNumber, this.var));
        returnedValue.initialize(this);
        returnedValue.setParent(this);
        Node casted = Conversion.promote(returnedValue.checkType(), type);
        this.getResult = this.var instanceof ArrayReference ? new SetElement((ArrayReference)this.var, casted) : new Assignment(this.var, casted);
        this.getResult.initialize(this);
        this.getResult = this.getResult.checkType();
        this.setFirst(this.getResult);
        this.setTypeDescription(TypeFactory.getVoid());
        return this;
    }

    @Override
    void generate(CodeGenerator cg) {
        this.getResult.gen(cg);
    }

    Node getDefaultValueNode() {
        return this.promoted;
    }

    int getFieldNumber() {
        return this.fieldNumber;
    }

    Node getLabelNode() {
        return this.label;
    }

    List getOptions() {
        return this.options;
    }

    Node getOriginalVar() {
        return this.original;
    }

    Node getPromotedVar() {
        return this.promoted;
    }

    Node getTypeNode() {
        return this.typeNode;
    }

    Node getValidValuesNode() {
        return this.array;
    }

    Node getVar() {
        return this.var;
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        return this.getResult.run(rm);
    }

    void setFieldNumber(int number) {
        this.fieldNumber = number;
    }

    static {
        VALUE_OPTIONS = new String[0];
        VALID_OPTIONS = new ArrayList<String>();
        INTERVAL_OPTIONS = new ArrayList<String>();
        VALID_OPTIONS.add(TEXTAREA);
        VALID_OPTIONS.add(REQUIRED);
        VALID_OPTIONS.add(READONLY);
        VALID_OPTIONS.add(PASSWORD);
        VALID_OPTIONS.add(DATE);
        VALID_OPTIONS.add(TIME);
        for (int i = 0; i < IntervalUnit.values().length; ++i) {
            IntervalUnit field = IntervalUnit.values()[i];
            VALID_OPTIONS.add(Interval.getFieldName(field).toLowerCase());
            INTERVAL_OPTIONS.add(Interval.getFieldName(field).toLowerCase());
        }
    }
}

