/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Diadic;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.Function;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.IndexedNamedNode;
import oracle.bpm.compiler.InputField;
import oracle.bpm.compiler.InputFields;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.NamedNode;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NodeIterator;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.ArrayTypeDescription;
import oracle.bpm.type.TypeFactory;

public class Input
extends Diadic {
    private Node defaultValues;
    private InputFields fields;
    private Invoke invoke;
    static final String INPUT_CLASSNAME = "Fuego.Internal.Input";
    static final String INPUT_OBJECT = "CILInput";
    static final String INPUT_RESULT = "CILInputResult";
    private static final String FLD_LABELS = "fldLabels";
    private static final String FLD_TYPES = "fldTypes";
    private static final String FLD_DEFAULT_VALUES = "fldDefaultValues";
    private static final String FLD_VALID_VALUES = "fldValidValues";
    private static final String FLD_OPTIONS = "fldOptions";
    private static final String VALUES = "values";
    static final String[] SYNTHETIC_ARGS = new String[]{"fldLabels", "fldTypes", "fldDefaultValues", "fldValidValues", "fldOptions"};
    static final String[] SYNTHETIC_OUT_ARGS = new String[]{"values"};

    public Input(Token t) {
        super(t);
    }

    Input() {
    }

    @Override
    public String getText() {
        return "input";
    }

    @Override
    public void generate(SourceGenerator cg) {
        Args outargs;
        Args inargs;
        InputFields fields;
        Invoke targetInvoke = null;
        if (this.getKind() != -1) {
            Invoke invoke = (Invoke)this.getOp1();
            fields = this.fields;
            inargs = invoke.getInputArgs();
            outargs = invoke.getOutputArgs();
            targetInvoke = invoke.getTargetInvoke();
        } else {
            fields = (InputFields)this.getOp1();
            Node op2 = this.getOp2();
            inargs = Function.createArgs(op2, this);
            inargs = Args.ensureNotNullArgs(null, inargs, this.getScope());
            outargs = (Args)inargs.getNext();
        }
        cg.generate(this, fields, inargs, outargs, targetInvoke);
    }

    @Override
    protected String getStatementSeparator() {
        return null;
    }

    void setArgs(Args args) {
        Node node = this.getFirst();
        if (node == null) {
            this.setFirst(args);
        } else {
            node = node.getLast();
            node.setNext(args);
        }
    }

    void addField(String name, Node value) {
        Node first = this.getFirst();
        InputFields fields = null;
        if (first instanceof InputFields) {
            fields = (InputFields)first;
        }
        if (fields == null) {
            fields = new InputFields();
            fields.setScope(this.getScope());
            this.setFirst(fields);
            if (first != null) {
                fields.setNext(first);
            }
        }
        fields.addField(name, value);
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        NodeIterator it = this.defaultValues.getChildren();
        while (it.hasNext()) {
            Symbol symbol;
            Conversion conv;
            Node current = it.next();
            Conversion conversion = conv = current instanceof Conversion ? (Conversion)current : null;
            if (conv != null) {
                current = conv.getOperand();
            }
            if ((symbol = current.getSymbol()) == null) continue;
            context.ensureVariableInit(symbol);
        }
        return this.invoke.checkFlow(context);
    }

    @Override
    Node checkType() throws TypeException {
        this.setTypeDescription(TypeFactory.getVoid());
        ArrayTypeDescription type = TypeFactory.getArray(this.findType("Java.Lang.Object"));
        Identifier.autodeclare(INPUT_RESULT, type, this, true);
        this.fields = (InputFields)this.getOp1().checkType();
        Node op2 = this.getOp2();
        Args args = Function.createArgs(op2, this);
        args = Args.ensureNotNullArgs(null, args, this.getScope());
        Args outArgs = (Args)args.getNext();
        args.addInArgument(FLD_LABELS, this.fields.getLabels());
        args.addInArgument(FLD_TYPES, this.fields.getTypes());
        this.defaultValues = this.fields.getDefaultValues();
        args.addInArgument(FLD_DEFAULT_VALUES, this.defaultValues);
        args.addInArgument(FLD_VALID_VALUES, this.fields.getValidValues());
        args.addInArgument(FLD_OPTIONS, this.fields.getOptions());
        args.setSyntheticArgs(SYNTHETIC_ARGS);
        outArgs.setSyntheticArgs(SYNTHETIC_OUT_ARGS);
        if (outArgs.isRelay()) {
            NodeIterator it = outArgs.getChildren();
            it.next();
            while (it.hasNext()) {
                it.replace(this.processRelayArgument((NamedNode)it.next()));
            }
        } else {
            NodeIterator it = this.fields.getChildren();
            while (it.hasNext()) {
                InputField field = (InputField)it.next();
                IndexedNamedNode arg = new IndexedNamedNode(VALUES, field.getFieldNumber(), field.getVar());
                arg.setNameType(field.getPromotedVar().getTypeDescription());
                outArgs.addOutArgument(arg);
            }
        }
        Identifier.autodeclare(INPUT_OBJECT, this.findType(INPUT_CLASSNAME), this, true);
        this.invoke = new Invoke("run", INPUT_OBJECT, args);
        this.invoke.initialize(this);
        this.invoke.setParent(this);
        this.invoke = (Invoke)this.invoke.checkType();
        this.setOperands(this.invoke, this.fields);
        return this;
    }

    @Override
    void generate(CodeGenerator cg) {
        if (this.fields == null || this.invoke == null) {
            return;
        }
        this.invoke.gen(cg);
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        this.invoke.run(rm);
        return null;
    }

    private InputField getMatchingField(Node node) {
        NodeIterator it = this.fields.getChildren();
        while (it.hasNext()) {
            InputField field = (InputField)it.next();
            Node var = field.getOriginalVar();
            if (!var.equalsTree(node)) continue;
            return field;
        }
        return null;
    }

    private NamedNode processRelayArgument(NamedNode arg) {
        Node left = arg.getFirst();
        Node right = left.getNext();
        InputField match = this.getMatchingField(right);
        if (match != null) {
            NamedNode node = this.isGeneratingSource() ? new NamedNode(arg.getName(), right) : new IndexedNamedNode(arg.getName(), match.getFieldNumber(), new Identifier(VALUES));
            node.setNameType(match.getPromotedVar().getTypeDescription());
            node.initialize(arg);
            node.getOp1().initialize(arg.getOp1());
            arg = node;
        }
        return arg;
    }
}

