/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import java.math.BigDecimal;
import oracle.bpm.compiler.Arithmetic;
import oracle.bpm.compiler.Assignment;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Dup;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.IntConst;
import oracle.bpm.compiler.InvalidOperandException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.Pop;
import oracle.bpm.compiler.RealConst;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.Decimal;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.filter.Operation;

public class IncDecOperator
extends Node {
    private final boolean increment;
    private final boolean postfix;

    IncDecOperator() {
        this.increment = false;
        this.postfix = false;
    }

    IncDecOperator(Token token, boolean increment, boolean postfix) {
        super(token);
        this.increment = increment;
        this.postfix = postfix;
    }

    @Override
    public String getText() {
        return this.getOperatorName() + (this.isPostfix() ? "p" : "");
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    @Override
    public boolean isIncrement() {
        return this.increment;
    }

    @Override
    public Symbol getSymbol() {
        Node grandson = this.getOp1().getOp1();
        return grandson == null ? null : grandson.getSymbol();
    }

    public boolean isPostfix() {
        return this.postfix;
    }

    @Override
    Operation getOperationTree() {
        if (this.isParameter()) {
            return new Operation(0, "?", null);
        }
        Operation[] operand = new Operation[]{this.getFirst().getOperationTree()};
        return new Operation(17, "-", operand);
    }

    String getOperatorName() {
        return this.isIncrement() ? "++" : "--";
    }

    @Override
    Node checkType() throws TypeException {
        Node result = this;
        if (this.getKind() == -1) {
            if (!this.isGeneratingSource()) {
                result = this.refactor();
            } else {
                super.checkType();
                TypeDescription td = this.getFirst().getTypeDescription();
                if (!td.isNumber()) {
                    throw new InvalidOperandException((Node)this, this.getText(), td);
                }
                this.setTypeDescription(td);
            }
        }
        return result;
    }

    @Override
    void generate(CodeGenerator cg) {
        throw new IllegalStateException("This node is always transformed");
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        Object value;
        Object result = value = this.getFirst().value(rm);
        TypeDescription type = this.getTypeDescription();
        if (this.isIncrement()) {
            switch (this.getFirst().getKind()) {
                case 2: {
                    Number num = (Number)value;
                    value = IntConst.createValue(num != null ? num.longValue() + 1L : 1L, type);
                    break;
                }
                case 4: {
                    Number num = (Number)value;
                    value = RealConst.createValue(num != null ? num.doubleValue() + 1.0 : 1.0, type);
                    break;
                }
                case 3: {
                    value = Decimal.inc((BigDecimal)value);
                }
            }
            if (type.isPrimitive()) {
                this.getFirst().setVariable(rm, value);
            }
        } else {
            switch (this.getFirst().getKind()) {
                case 2: {
                    Number num = (Number)value;
                    value = IntConst.createValue(num != null ? num.longValue() - 1L : -1L, type);
                    break;
                }
                case 4: {
                    Number num = (Number)value;
                    value = RealConst.createValue(num != null ? num.doubleValue() - 1.0 : -1.0, type);
                    break;
                }
                case 3: {
                    value = Decimal.dec((BigDecimal)value);
                }
            }
            if (type.isPrimitive()) {
                this.getFirst().setVariable(rm, value);
            }
        }
        if (!this.isPostfix() || !type.isPrimitive()) {
            result = value;
        }
        return result;
    }

    private Node refactor() throws TypeException {
        boolean postfix = this.isPostfix() && this.isExpression();
        int operation = this.isIncrement() ? 0 : 1;
        Node operand = IncDecOperator.deepCopy(this.getFirst());
        if (postfix) {
            operand = new Dup(operand);
        }
        Node target = IncDecOperator.deepCopy(this.getFirst());
        Assignment assign = new Assignment(target, new Arithmetic(operand, operation, new IntConst(1L)));
        assign.setExpression(this.isExpression());
        Node result = postfix ? new Pop(assign) : assign;
        result.initialize(this);
        return result.checkType();
    }

    public static class PreInc
    extends IncDecOperator {
        public PreInc(Token t) {
            super(t, true, false);
        }
    }

    public static class PreDec
    extends IncDecOperator {
        public PreDec(Token t) {
            super(t, false, false);
        }
    }

    public static class PostInc
    extends IncDecOperator {
        public PostInc(Token t) {
            super(t, true, true);
        }
    }

    public static class PostDec
    extends IncDecOperator {
        public PostDec(Token t) {
            super(t, false, true);
        }
    }
}

