/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import java.util.List;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NodeIterator;
import oracle.bpm.compiler.SQLStatement;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.sql.ColumnReference;
import oracle.bpm.type.TypeFactory;

public class GroupByColumns
extends Node {
    private ColumnReference[] groupingcols;

    public GroupByColumns(Token t) {
        super(t);
    }

    GroupByColumns() {
    }

    @Override
    public String getText() {
        return "group-by";
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    ColumnReference[] getGroupingColumns() {
        return this.groupingcols;
    }

    @Override
    Node checkType() throws TypeException {
        if (this.getKind() != -1) {
            return this;
        }
        this.getScope().setOnlyLocal(true);
        SQLStatement.checkColumns(this);
        List cols = CollectionPool.getArrayList();
        NodeIterator columns = this.getChildren();
        while (columns.hasNext()) {
            cols.add(columns.next().getColumnReference());
        }
        this.groupingcols = new ColumnReference[cols.size()];
        for (int i = 0; i < this.groupingcols.length; ++i) {
            this.groupingcols[i] = (ColumnReference)cols.get(i);
        }
        this.getScope().setOnlyLocal(false);
        this.setTypeDescription(TypeFactory.getVoid());
        CollectionPool.releaseArrayList(cols);
        return this;
    }

    @Override
    void generateSQLCode(StringBuffer query) {
        query.append(" GROUP BY ");
        GroupByColumns.generateCommaDelimitedSQL(this.getFirst(), query);
    }
}

