/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.collections.AST;
import oracle.bpm.cil.CilException;
import oracle.bpm.compiler.Accessor;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.ClassConst;
import oracle.bpm.compiler.CodeKit;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.CompilerParserException;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.FieldDeclaration;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.MissingExpressionException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.Return;
import oracle.bpm.compiler.StringConst;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.type.Argument;
import oracle.bpm.type.SourceCode;

class Getter
extends Accessor {
    Getter(AttributeTypeDescription attribute, int attrIndex) {
        super(attribute, attrIndex);
        assert (!attribute.getType().isUnknown());
        this.setMemberToReport(attribute);
        this.setMemberPartToReport(8);
    }

    @Override
    boolean isGetter() {
        return true;
    }

    @Override
    String getJavaSignature() {
        return this.attr.getJavaSignature();
    }

    @Override
    Node checkType() throws TypeException {
        this.setTypeDescription(this.attr);
        boolean isDetached = Modifier.isDetached(this.attr.getModifiers());
        Node readCode = this.getFirst();
        if (readCode == null) {
            Node result;
            if (isDetached) {
                result = new MemberReference("this", "detachedFieldHandler");
                Args args = new Args(1L);
                args.addInArgument("name", new StringConst(this.attr.getName(), this));
                args.addInArgument("type", new ClassConst(this.attr.getType(), (Node)this));
                result = new Invoke(new Identifier("getDetachedField"), result, args);
                result.setExpression(true);
                result = Conversion.Cast.create(result, this.getResultType().primitiveEquivalent(false));
            } else {
                result = this.attr.isStatic() ? new MemberReference(this.getCurrentClass().createReference(this), new Identifier(this.attr.getName())){

                    @Override
                    boolean isPrimitiveAccess() {
                        return true;
                    }
                } : new MemberReference("this", this.attr.getName());
            }
            readCode = result = new Return(result);
        }
        Block statements = new Block();
        if ((this.getResultType().isArray() || this.getResultType().isObject()) && this.attrIndex != -1 && !this.attr.isStatic()) {
            CodeKit.SetBitSet notify = new CodeKit.SetBitSet(this, this.getUnit(), this.getBitIndex());
            statements.addChild((AST)notify);
        }
        statements.addChild((AST)readCode);
        statements.initialize(this);
        this.setBody(this.getName(), statements);
        this.addDeclarationsForVariables(this.getTypeDescription().asMethod());
        MethodTypeDescription method = this.createMethod();
        Argument resultArgument = method.getResultArgument();
        resultArgument.setType(this.attr.getType());
        resultArgument.setJavaType(this.attr.getJavaType());
        if (Modifier.isExternal(this.attr.getModifiers())) {
            resultArgument.setModifiers(resultArgument.getModifiers() | 0x800L);
        }
        method.setSignature(this.attr.getJavaSignature());
        this.setMethodType(method);
        this.checkOverridings(method);
        return super.checkType();
    }

    @Override
    void parse(FuegoCompiler compiler) throws CompilerException {
        SourceCode code = this.attr.getCode();
        try {
            Node readCode = null;
            if (code != null) {
                readCode = compiler.parseMethod(code, false, this);
            }
            if (readCode == null && this.attr.isVirtual()) {
                throw new MissingExpressionException(this);
            }
            if (readCode != null) {
                readCode.setScope(this.getScope());
                this.setFirst(readCode);
            }
        }
        catch (CompilerParserException e) {
            e.setMember(this.getMethodType());
            this.reportError(e);
        }
    }

    static class Forward
    extends Getter {
        Forward(FieldDeclaration target, AttributeTypeDescription attribute, int attrIndex) {
            super(attribute, attrIndex);
            MemberReference ref = target.createReference();
            ref = new MemberReference(ref, new Identifier(attribute.getName()));
            this.setFirst(new Return(ref));
        }

        @Override
        public void reportWarning(CilException warning) {
        }

        @Override
        void parse(FuegoCompiler compiler) throws CompilerException {
        }
    }
}

