/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import fuego.parser.collections.AST;
import oracle.bpm.compiler.Arg;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NullStatement;
import oracle.bpm.compiler.Ternary;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeFactory;

public class FormalArgument
extends Ternary {
    public FormalArgument(Token t) {
        super(t);
    }

    public FormalArgument(AST type) {
        this.setOperand((Node)type);
    }

    public FormalArgument(AST mode, AST name, AST type) {
        super(mode, name, type);
    }

    FormalArgument() {
    }

    @Override
    Node checkType() throws TypeException {
        Node argMode = this.getOp1();
        Node argName = this.getOp2();
        Node argType = argName != null ? this.getOp3() : null;
        MethodTypeDescription method = this.getCurrentMember().getMethodType();
        if (argName != null) {
            Arg.Type mode = (Arg.Type)argMode;
            assert (argType instanceof TypeSpec) : "Invalid AST";
            argType = argType.checkType();
            TypeDescription type = argType.getTypeDescription();
            method.addArgument(new Argument(argName.getText(), type, mode.getArgumentType()));
        } else {
            argType = argMode;
            assert (argType instanceof TypeSpec) : "Invalid AST";
            argType = argType.checkType();
            TypeDescription type = argType.getTypeDescription();
            method.setResultType(type);
        }
        return NullStatement.NODE;
    }

    public static class Result
    extends FormalArgument {
        public Result() {
        }

        public Result(AST type) {
            this.setOperand((Node)type);
        }

        @Override
        public String getText() {
            return this.getOp1() == null ? "void" : this.getOp1().getText();
        }

        @Override
        Node checkType() throws TypeException {
            MethodTypeDescription method = this.getCurrentMember().getMethodType();
            Node type = this.getFirst();
            TypeDescription returnType = TypeFactory.getVoid();
            if (type != null) {
                boolean condition = type instanceof TypeSpec;
                assert (condition) : "Invalid AST";
                returnType = type.checkType().getTypeDescription();
            }
            method.setResultType(returnType);
            return NullStatement.NODE;
        }
    }
}

