/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.collections.AST;
import oracle.bpm.bcgen.Mod;
import oracle.bpm.bcgen.ModSet;
import oracle.bpm.compiler.CannotBeNotNullException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.ErrorMapping;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.LocalVar;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.compiler.SetMember;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.TypeDescription;

public class FieldDeclaration
extends Node {
    private AttributeTypeDescription attr;
    private Const constant;
    private long modifiers;
    private boolean mustInit;
    private String name;
    private ObjectClass objectClass;

    FieldDeclaration(ObjectClass cl, AttributeTypeDescription attr) {
        this(cl, attr.getName(), attr.getType(), attr.getModifiers());
        this.attr = attr;
    }

    FieldDeclaration(ObjectClass cl, String name, TypeDescription type, long mods) {
        name = FieldDeclaration.name(name);
        this.objectClass = cl;
        this.name = name;
        this.modifiers = mods | 0x2000L;
        this.setTypeDescription(type);
        this.setExpression(false);
    }

    private FieldDeclaration(ObjectClass cl, Const constant) {
        this(cl, constant.getConstantFieldName(), constant.getTypeDescription(), 131136L);
        this.constant = constant;
        this.setSynthetic(true);
    }

    public Node getInitialValue() {
        return this.constant != null ? this.constant : this.getFirst();
    }

    public void setMustInit(boolean mustInit) {
        this.mustInit = mustInit;
    }

    public boolean isMustInit() {
        return this.mustInit;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getText() {
        return this.getName() + " : " + this.getTypeDescription().getText();
    }

    public Node extractInit() {
        try {
            this.parse(null);
        }
        catch (CompilerException e) {
            e.printStackTrace();
        }
        ErrorMapping init = null;
        Node expr = this.removeFirst();
        if (expr != null) {
            SetMember set = new SetMember(){

                @Override
                boolean isPrimitiveAccess() {
                    return true;
                }

                @Override
                public boolean isStatement() {
                    return true;
                }
            };
            set.addChild((AST)this.getCurrentClass().createReference(this));
            set.addChild((AST)new Identifier(this.attr != null ? this.attr.getName() : this.getName()));
            set.addChild((AST)expr);
            init = new ErrorMapping(set, this.attr);
        }
        return init;
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    public MemberReference createReference() {
        LocalVar current = new LocalVar(this.objectClass.getSymbol(), null);
        current.initialize(this.objectClass);
        return new MemberReference((Node)current, new Identifier(this.getName())){

            @Override
            boolean isPrimitiveAccess() {
                return true;
            }
        };
    }

    @Override
    protected String getStatementSeparator() {
        return null;
    }

    @Override
    protected boolean splitToPrint() {
        return true;
    }

    static String name(String name) {
        if (oracle.bpm.util.Identifier.belongsToJava(name)) {
            name = "_" + name;
        }
        return name;
    }

    static FieldDeclaration createConstantField(ObjectClass cl, Const constant) {
        return new FieldDeclaration(cl, constant);
    }

    AttributeTypeDescription getAttribute() {
        return this.attr;
    }

    boolean isBitField() {
        return this.getName().startsWith("__bitSet");
    }

    boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    boolean isTransient() {
        return Modifier.isTransient(this.modifiers);
    }

    boolean isPersistent() {
        return !this.isStatic() && !this.isTransient();
    }

    @Override
    Node checkType() throws TypeException {
        if (this.isNotNull() && !this.getTypeDescription().hasDefaultInit()) {
            throw new CannotBeNotNullException(this, this.getName(), this.getTypeDescription());
        }
        return super.checkType();
    }

    MemberReference createReference(Node init) {
        MemberReference reference = this.createReference();
        reference.initialize(init);
        return reference;
    }

    String getDefaultValue() {
        return this.attr.getDefaultValue();
    }

    ModSet getFieldModifiers() {
        Mod result;
        Mod mod = result = Modifier.isPrivate(this.modifiers) ? Mod.PRIVATE : Mod.PUBLIC;
        if (Modifier.isStatic(this.modifiers)) {
            result = result.STATIC();
        }
        if (Modifier.isFinal(this.modifiers)) {
            result = result.FINAL();
        }
        if (Modifier.isTransient(this.modifiers)) {
            result = result.TRANSIENT();
        }
        if (Modifier.isColumn(this.modifiers)) {
            result = result.TRANSIENT();
        }
        return result;
    }

    @Override
    void generate(CodeGenerator cg) {
        cg.generate(this);
    }

    @Override
    void parse(FuegoCompiler compiler) throws CompilerException {
        String defaultValue;
        Node init = null;
        TypeDescription type = this.getTypeDescription();
        if (this.attr != null && (defaultValue = this.attr.getDefaultValue()) != null) {
            init = Const.valueOf(defaultValue, type, this);
        }
        if (init == null && (this.isNotNull() || type.isPrimitive() || type.isArray() || this.mustInit)) {
            init = Const.valueOf("", type, this);
        }
        if (init != null) {
            init.setScope(this.getScope());
            this.setFirst(init);
        }
    }

    private boolean isNotNull() {
        return Modifier.isRequired(this.modifiers);
    }
}

