/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.collections.AST;
import oracle.bpm.compiler.Arg;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.CompilerExceptionShell;
import oracle.bpm.compiler.DefaultConst;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SetElement;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Ternary;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.xobject.GroupArray;

class Extend
extends Ternary {
    Extend() {
    }

    @Override
    public void generate(SourceGenerator cg) {
        this.getOp1().generate(cg);
    }

    @Override
    Node checkType() throws TypeException {
        super.checkType();
        Invoke invoke = (Invoke)this.getOp1();
        Node array = invoke.getObject();
        TypeDescription arrayType = array.getTypeDescription();
        TypeDescription elementType = arrayType.getElementType();
        Args args = Extend.copyArgumentsFrom(invoke);
        Identifier name = new Identifier(elementType.getName());
        Invoke newInstance = new Invoke(name, new TypeSpec(elementType, this), args);
        newInstance.setExpression(true);
        newInstance.setConstructorAllowed(true);
        if (elementType.isBpmObject() && DefaultConst.isGroupArray(arrayType)) {
            newInstance.setInstanceCreator(new CreateInstance(array));
        }
        if (this.isGeneratingSource()) {
            newInstance.setParent(this);
            newInstance.initialize(this);
            newInstance.checkType();
        } else {
            SetElement addElement = new SetElement();
            addElement.setOperands(array, newInstance);
            addElement.setParent(this);
            addElement.initialize(this);
            this.setOperand(addElement.checkType());
        }
        this.setTypeDescription(TypeFactory.getVoid());
        return this;
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        return this.getOp1().run(rm);
    }

    private static Args copyArgumentsFrom(Invoke invoke) {
        Args inputArgs = invoke.getInputArgs();
        Args args = new Args(1L);
        for (Arg arg = (Arg)inputArgs.getFirst(); arg != null; arg = (Arg)arg.getNext()) {
            if (arg.isSynthetic()) continue;
            Argument argument = arg.getArgument();
            args.addInArgument(argument.getName(), arg.getValue());
        }
        return args;
    }

    static class CreateInstance
    extends Node {
        CreateInstance(Node array) {
            super((AST)CreateInstance.deepCopy(array));
            this.initialize(array);
        }

        @Override
        Object run(RunningMonitor rm) throws ExecutionException {
            try {
                GroupArray array = (GroupArray)this.getOp1().value(rm, GroupArray.class);
                return array.createNewElement();
            }
            catch (Exception e) {
                throw new CompilerExceptionShell((Node)this, (Throwable)e);
            }
        }
    }
}

