/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.Not;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.type.TypeFactory;

public class Exists
extends Node {
    private boolean negate;

    public Exists(Token t) {
        super(t);
        this.setParameter(false);
        this.setParametric(false);
    }

    @Override
    public String getText() {
        return "exists";
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this, this.getFirst(), this.negate);
    }

    @Override
    Node checkType() throws TypeException {
        if (this.getOp1() instanceof Not) {
            this.removeFirst();
            this.negate = true;
        }
        super.checkType();
        this.setTypeDescription(TypeFactory.getPrimitiveBool());
        return this;
    }

    @Override
    void generateSQLCode(StringBuffer query) {
        if (this.negate) {
            query.append(" NOT");
        }
        query.append(" EXISTS ( ");
        this.getFirst().generateSQLCode(query);
        query.append(" )");
    }
}

