/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.collections.AST;
import oracle.bpm.compiler.ArrayConst;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.ConstGenerator;
import oracle.bpm.compiler.ConversionException;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.IllegalTypeException;
import oracle.bpm.compiler.IntConst;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.Pair;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.StringConst;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.EnumTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;

public class EnumConst
extends Const {
    private AttributeTypeDescription member;
    private boolean onlyId = false;
    private String value;

    EnumConst(EnumTypeDescription type, AttributeTypeDescription attribute, Node orig) {
        this.initialize(orig);
        this.value = attribute.getDefaultValue();
        this.setTypeDescription(type);
        this.member = attribute;
        this.setPrimitive(type.isPrimitive());
    }

    public String getLabel() {
        return this.member.getName();
    }

    public String getNativeName() {
        return this.member.getNativeName();
    }

    public boolean isNativeEnum() {
        return this.getEnumTypeDescription().isNativeEnum();
    }

    public boolean isOnlyId() {
        return this.onlyId;
    }

    @Override
    public String getText() {
        StringBuilder result = new StringBuilder();
        if (this.isNativeEnum()) {
            String javaType = this.getTypeDescription().getJavaType().replace('$', '.');
            result.append(javaType).append('.');
        }
        result.append(this.value);
        return result.toString();
    }

    @Override
    public void generate(ConstGenerator cg) {
        cg.generate(this);
    }

    @Override
    public String toString() {
        return this.getTypeDescription().getName() + '.' + this.getLabel() + ' ' + this.value;
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    static Node checkEnum(Node id) {
        try {
            TypeDescription td = TypeSpec.findType(id);
            if (td.isEnum()) {
                return EnumConst.makeArray((EnumTypeDescription)td, id);
            }
        }
        catch (TypeException typeException) {
            // empty catch block
        }
        return null;
    }

    static Node makeArray(EnumTypeDescription type, Node orig) throws TypeException {
        Node result;
        if (type.isNativeEnum()) {
            result = new MemberReference(type.getText(), "VALUES");
        } else {
            Node tail = null;
            EnumConst first = null;
            for (int i = 0; i < type.getMemberCount(); ++i) {
                EnumConst node = new EnumConst(type, type.getMemberType(i).asAttribute(), orig);
                if (first == null) {
                    first = node;
                } else {
                    tail.setNext(node);
                }
                tail = node;
            }
            result = new ArrayConst(orig.getScope(), first, true);
            result.setParametric(true);
            result.setMustClone(false);
        }
        result.initialize(orig);
        result.copyParentFrom(orig);
        return result.checkType();
    }

    static ArrayConst makeEnumArray(EnumTypeDescription type, Node init) throws TypeException {
        Node prev = null;
        Pair first = null;
        for (int i = 0; i < type.getMemberCount(); ++i) {
            Pair node = new Pair((AST)new StringConst(type.getMemberName(i), -1, init), (AST)new EnumConst(type, type.getMemberType(i).asAttribute(), init));
            if (first == null) {
                first = node;
            } else {
                prev.setNext(node);
            }
            prev = node;
        }
        ArrayConst result = new ArrayConst(init.getScope(), first, true);
        result.copyParentFrom(init);
        result.setMustClone(false);
        result.initialize(init);
        result.setParametric(true);
        return (ArrayConst)result.checkType();
    }

    static ArrayConst makeLabelArray(EnumTypeDescription type, Node orig) throws TypeException {
        return EnumConst.makeLabelArray(type, orig, !type.isSequential());
    }

    static ArrayConst makeLabelArray(EnumTypeDescription type, Node init, boolean map) throws TypeException {
        Node tail = null;
        StringConst first = null;
        String[] enumLabels = type.getLabels();
        for (int i = 0; i < enumLabels.length; ++i) {
            Node node = new StringConst(enumLabels[i], init);
            if (map) {
                IntConst label = new IntConst((long)type.getValue(i), TypeFactory.getInt());
                node = new Pair((AST)label, (AST)node);
            }
            if (first == null) {
                first = node;
            } else {
                tail.setNext(node);
            }
            tail = node;
        }
        ArrayConst result = new ArrayConst(init.getScope(), first, true);
        result.copyParentFrom(init);
        result.setMustClone(false);
        result.initialize(init);
        result.setParametric(true);
        return (ArrayConst)result.checkType();
    }

    static ArrayConst makeRestrictedLabelMap(EnumTypeDescription type, Node array) throws TypeException {
        ArrayConst arr;
        switch (array.getKind()) {
            case 9: {
                arr = EnumConst.makeLabelArray(type, array, true);
                break;
            }
            case 12: {
                arr = EnumConst.makeLabelArray(type, array, true);
                break;
            }
            default: {
                throw new IllegalTypeException(array, type.getName());
            }
        }
        TypeDescription arrayType = arr.getTypeDescription();
        arrayType = TypeFactory.getSortedMap(arrayType.getElementType(), arrayType.getIndexType());
        return (ArrayConst)arr.convertTo(arrayType);
    }

    @Override
    boolean isCollectable() {
        return false;
    }

    String getValue() {
        return this.value;
    }

    @Override
    Const convertTo(TypeDescription targetType) throws TypeException {
        switch (targetType.getKind()) {
            case 2: 
            case 3: 
            case 4: {
                return EnumConst.valueOf(this.getText(), targetType, this);
            }
            case 5: {
                return new StringConst(this.getLabel(), targetType.getLength(), this);
            }
            case 17: {
                return new EnumConst((EnumTypeDescription)targetType, this.member, this);
            }
            case 10: {
                return this;
            }
        }
        throw new ConversionException((Node)this, this.getTypeDescription(), targetType);
    }

    void setOnlyId(boolean onlyId) {
        this.onlyId = onlyId;
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        return this.getEnumTypeDescription().newInstance(this.value);
    }

    private EnumTypeDescription getEnumTypeDescription() {
        return (EnumTypeDescription)this.getTypeDescription();
    }
}

