/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.bcgen.JVMCodeBuilder;
import oracle.bpm.bcgen.LocalVariable;
import oracle.bpm.bcgen.MDKit;
import oracle.bpm.bcgen.MethodD;
import oracle.bpm.bcgen.Mod;
import oracle.bpm.bcgen.ModSet;
import oracle.bpm.bcgen.TD;
import oracle.bpm.bcgen.TDKit;
import oracle.bpm.compiler.ClassConst;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.JVMByteCodeGenerator;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.Node;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

public class DynamicAdaptorGenerator {
    private JVMCodeBuilder cb;
    private JVMByteCodeGenerator codeGenerator;
    private Method method;
    private Type resultType;

    private DynamicAdaptorGenerator(Method method, JVMByteCodeGenerator codeGenerator) {
        this.method = method;
        this.codeGenerator = codeGenerator;
    }

    static void generate(JVMByteCodeGenerator codeGenerator, Method method) {
        if (method.isGenerateAdaptor()) {
            new DynamicAdaptorGenerator(method, codeGenerator).generate();
        }
    }

    void generateDynamicArgReference(int i) {
        String deflt;
        Argument arg = this.method.getMethodType().getArgument(i);
        TypeDescription argType = arg.getType();
        MethodD md = MDKit.getArgument((String)argType.getJavaType());
        this.cb.loadArgument(0);
        this.cb.loadConstant(arg.getName());
        if (md.getArgCount() == 4) {
            String invokeableClassName;
            ClassConst classConst = this.method.getArgClasses()[i];
            if (argType.isInvokeable() && (invokeableClassName = argType.asObject().getProperty("invokeableClassName")) != null) {
                classConst = new ClassConst(invokeableClassName, (Node)this.method);
            }
            classConst.gen(this.codeGenerator);
        }
        if ((deflt = arg.getDefaultValue()) != null) {
            Const.valueOf(deflt, argType, null).gen(this.codeGenerator);
        } else if (md.getArgType(2) instanceof BasicType) {
            Const.defaultValue(argType, null).gen(this.codeGenerator);
        } else {
            this.cb.loadNull();
        }
        this.cb.invoke(md);
        this.cb.convert(TD.valueOf((TypeDescription)argType));
    }

    private LocalVariable[] createArguments() {
        MethodTypeDescription methodType = this.method.getMethodType();
        LocalVariable[] args = new LocalVariable[methodType.getArgumentCount()];
        for (int i = 0; i < args.length; ++i) {
            Argument arg = methodType.getArgument(i);
            if (!arg.isOut()) {
                args[i] = this.cb.createLocalVariable(arg.getName(), TD.valueOf((TypeDescription)arg.getType()));
                this.generateDynamicArgReference(i);
                this.cb.storeLocal(args[i]);
                continue;
            }
            ObjectType holderType = TD.getObjectType((String)arg.getHolderJavaType());
            args[i] = this.cb.createLocalVariable(arg.getName(), (Type)holderType);
            this.cb.construct(holderType);
            this.cb.storeLocal(args[i]);
            this.cb.loadLocal(args[i]);
            this.generateDynamicArgReference(i);
            this.codeGenerator.storeHolder(arg.getType(), arg.getHolderJavaType());
        }
        return args;
    }

    private void createMethod() {
        this.resultType = TD.valueOf((TypeDescription)this.method.getResultType());
        Mod m = this.method.isStatic() ? Mod.PUBLIC.STATIC() : Mod.PUBLIC;
        Type[] argTypes = new Type[]{TDKit.ARGUMENT_MAP};
        String[] argNames = new String[]{"arg"};
        this.cb = this.codeGenerator.getClassCode().addMethod((ModSet)m, this.resultType, this.method.getFullName(), argTypes, argNames, null);
        this.codeGenerator.setCodeBuilder(this.cb);
    }

    private void doReturn(LocalVariable result) {
        if (result != null) {
            this.cb.loadLocal(result);
        }
        this.cb.retrn();
    }

    private void generate() {
        this.createMethod();
        LocalVariable[] args = this.createArguments();
        if (!this.method.isStatic()) {
            this.cb.loadThis();
        }
        Type[] argTypes = this.pushArguments(args);
        LocalVariable result = this.invokeInner(argTypes);
        this.loadOutputArguments(args);
        this.doReturn(result);
        this.cb.endCode();
    }

    private LocalVariable invokeInner(Type[] argTypes) {
        LocalVariable result;
        this.cb.invoke(MethodD.create((boolean)this.method.isStatic(), (Type)this.resultType, (ObjectType)this.codeGenerator.getClassCode().getType(), (String)this.method.getFullName(), (Type[])argTypes));
        LocalVariable localVariable = result = this.resultType.equals(Type.VOID) ? null : this.cb.createLocalVariable("result", this.resultType);
        if (result != null) {
            this.cb.storeLocal(result);
        }
        return result;
    }

    private void loadOutputArguments(LocalVariable[] args) {
        for (int i = 0; i < args.length; ++i) {
            Argument arg = this.method.getMethodType().getArgument(i);
            if (!arg.isOut()) continue;
            this.cb.loadArgument(0);
            this.cb.loadConstant(arg.getName());
            this.cb.loadLocal(args[i]);
            this.codeGenerator.loadHolder(arg.getType(), arg.getHolderJavaType());
            MethodD md = MDKit.setArgument((String)arg.getType().getJavaType());
            this.cb.invoke(md);
        }
    }

    private Type[] pushArguments(LocalVariable[] args) {
        Type[] argTypes = new Type[args.length];
        for (int i = 0; i < args.length; ++i) {
            LocalVariable arg = args[i];
            argTypes[i] = arg.getType();
            this.cb.loadLocal(arg);
        }
        return argTypes;
    }
}

