/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import fuego.parser.collections.AST;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.CompilerExceptionShell;
import oracle.bpm.compiler.Declaration;
import oracle.bpm.compiler.DuplicatedException;
import oracle.bpm.compiler.DuplicatedLabelException;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.ExecutionInterruptedException;
import oracle.bpm.compiler.ExitException;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.LabeledStatement;
import oracle.bpm.compiler.LocalVar;
import oracle.bpm.compiler.NameMismatchException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NodeIterator;
import oracle.bpm.compiler.NullStatement;
import oracle.bpm.compiler.On;
import oracle.bpm.compiler.OnExit;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.Scope;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;

public class DoBlock
extends Block {
    protected List<Symbol> symbols;
    private boolean wrapTypedExceptions;

    public DoBlock(Token t) {
        super(t);
    }

    DoBlock() {
    }

    DoBlock(String name) {
        this.name = name;
    }

    DoBlock(AST name, AST declarations, AST statements) {
        super(name);
        this.addChild(declarations);
        this.addChild(statements);
    }

    @Override
    public String getText() {
        return "do(" + this.getName() + ')';
    }

    public Block getDeclarations() {
        Node decl = this.getFirst();
        decl = decl instanceof Identifier ? decl.getNext() : (this.getOp3() instanceof Block ? decl : null);
        return (Block)decl;
    }

    public Block getExceptions() {
        Block statements = this.getStatements();
        return statements != null ? (Block)statements.getNext() : null;
    }

    public OnExit getOnExit() {
        OnExit onExit = null;
        Block exceptions = this.getExceptions();
        if (exceptions != null) {
            Node next = exceptions.getNext();
            if (next instanceof OnExit) {
                onExit = (OnExit)next;
            } else {
                for (Node current = exceptions.getFirst(); current != null; current = current.getNext()) {
                    if (!(current instanceof OnExit)) continue;
                    onExit = (OnExit)current;
                    onExit.removeFromParent();
                    onExit.setNext(exceptions.getNext());
                    exceptions.setNext(onExit);
                    break;
                }
            }
        }
        return onExit;
    }

    public Block getStatements() {
        Block declarations = this.getDeclarations();
        Node block = declarations != null ? declarations.getNext() : this.getFirst();
        return (Block)block;
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    protected static void popVariables(RunningMonitor rm, Node declarations, List stack) {
        Node current = declarations.getFirst();
        int i = 0;
        while (current != null) {
            Declaration decl = (Declaration)current;
            Symbol symbol = decl.getSymbol();
            if (!symbol.isSilentAutoDeclared()) {
                rm.popVariable(symbol.getName());
            }
            symbol.setValue(stack.get(i));
            current = current.getNext();
            ++i;
        }
    }

    protected static void pushVariables(Node declarations, List<Object> stack) {
        for (Node current = declarations.getFirst(); current != null; current = current.getNext()) {
            Declaration decl = (Declaration)current;
            Symbol symbol = decl.getSymbol();
            stack.add(symbol.getValue());
        }
    }

    protected static Block checkBody(Block statements) throws TypeException {
        return (Block)statements.checkType(false);
    }

    protected static Block checkDeclarations(Block declarations) throws TypeException {
        return (Block)declarations.checkType(false);
    }

    protected static Block checkExceptions(Block exceptions) throws TypeException {
        return (Block)exceptions.checkType(false);
    }

    @Override
    protected String getStatementSeparator() {
        return "\n";
    }

    static DoBlock findByName(String name, Node source) {
        return DoBlock.findByName(name, source, true);
    }

    static DoBlock findByName(String name, Node source, boolean caseSensitive) {
        DoBlock block = source.getCurrentDoBlock();
        while (block != null && !(!caseSensitive ? name.equalsIgnoreCase(block.getName()) : name.equals(block.getName()))) {
            Node parent = block.getParent();
            block = parent != null ? parent.getCurrentDoBlock() : null;
        }
        return block;
    }

    static boolean mustGenerateClientAvailable() {
        return false;
    }

    void setBody(String blockName, Node body) {
        Identifier name = new Identifier(blockName);
        Block declarations = Block.makeEmpty(this);
        Block statements = Block.ensureIsBlock(body);
        Block exceptions = Block.makeEmpty(this);
        this.setOperands(name, declarations, statements);
        statements.setNext(exceptions);
    }

    @Override
    DoBlock getCurrentDoBlock() {
        return this;
    }

    Node getId() {
        Node first = this.getFirst();
        return first instanceof Identifier ? first : null;
    }

    boolean isNamed() {
        return this.getName() != null && !this.getName().isEmpty();
    }

    @Override
    void setScope(Scope scp) {
        if (this.getScope() != null) {
            return;
        }
        Scope newscp = scp.makeSubScope();
        super.setScope(newscp);
    }

    boolean isTopLevel() {
        return false;
    }

    void setWrapTypedExceptions(boolean wrapTypedExceptions) {
        this.wrapTypedExceptions = wrapTypedExceptions;
    }

    void addDeclaration(Symbol sym) {
        assert (sym.getType().getKind() != -1) : sym + ". Context:\n" + this.dumpContext();
        if (this.symbols == null) {
            this.symbols = CollectionPool.getLinkedList();
        }
        this.symbols.add(sym);
        this.getSymbolTable().put(sym);
    }

    LocalVar autodeclareLocal(Node source, String name, TypeDescription type, boolean silent) {
        assert (source != null);
        Symbol variable = new Symbol(name, type);
        variable.setAutoDeclared(source, true, silent);
        this.addDeclaration(variable);
        return new LocalVar(variable, source);
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        Block declarations = this.getDeclarations();
        Block statements = this.getStatements();
        Block exceptions = this.getExceptions();
        OnExit onExit = this.getOnExit();
        if (declarations != null) {
            ((Node)declarations).checkFlow(context);
        }
        boolean hasExceptions = exceptions != null && exceptions.hasChildren();
        FlowContext onExcsCtx = hasExceptions ? context.split() : null;
        FlowContext onExitCtx = null;
        if (onExit != null) {
            onExitCtx = context.split();
            ((Node)statements).checkFlow(context);
        } else {
            ((Node)statements).checkFlow(context);
        }
        boolean stmsBreakFlow = context.breaksFlow();
        boolean excsBreakFlow = true;
        if (hasExceptions) {
            List<FlowContext> contexts = CollectionPool.getArrayList();
            for (Node onblock = exceptions.getFirst(); onblock != null; onblock = onblock.getNext()) {
                assert (onblock instanceof On) : "Unexpected node: " + onblock.getClassName();
                FlowContext split = onExcsCtx.split();
                contexts.add(split);
                onblock.checkFlow(split);
                excsBreakFlow = excsBreakFlow && split.breaksFlow();
            }
            FlowContext[] array = contexts.toArray(new FlowContext[contexts.size()]);
            onExcsCtx.join(array);
            CollectionPool.releaseArrayList(contexts);
            context.join(onExcsCtx);
        }
        if (onExit != null) {
            ((Node)onExit).checkFlow(onExitCtx);
            context.join(onExitCtx, false);
        }
        context.breaksFlow(stmsBreakFlow && excsBreakFlow);
        if (exceptions != null) {
            this.checkDuplicatedExceptions(exceptions);
        }
        return context;
    }

    @Override
    Node checkType() throws TypeException {
        Node id = this.getId();
        if (id != null) {
            Node parent;
            this.name = id.getText();
            Node endName = id.getLast();
            if (endName.isCompletion()) {
                endName.complete(8, id);
            }
            if (endName instanceof Identifier && !this.name.equals(endName.getText())) {
                this.reportError(new NameMismatchException(endName, this.name));
            }
            if (DoBlock.findByName(this.name, parent = this.getParent()) != null || LabeledStatement.find(this.name, parent) != null) {
                this.reportError(new DuplicatedLabelException(id));
            }
        }
        Block declarations = this.getDeclarations();
        Block statements = this.getStatements();
        Block exceptions = this.getExceptions();
        if (declarations == null) {
            declarations = Block.makeEmpty(this);
        }
        declarations = DoBlock.checkDeclarations(declarations);
        statements = DoBlock.checkBody(statements);
        if (exceptions != null) {
            exceptions = DoBlock.checkExceptions(exceptions);
        }
        Iterator<Symbol> it = this.symbolsIterator();
        while (it.hasNext()) {
            Symbol sym = it.next();
            if (!sym.isAutoDeclared() && !sym.isArgument()) continue;
            Declaration dcl = new Declaration(sym, this);
            dcl.setStatement(true);
            declarations.addChild((AST)dcl.checkType());
        }
        if (!(declarations.hasChildren() || exceptions != null || this.isNamed() || this.isTopLevel() || this.isGeneratingSource())) {
            Scope scope = this.getScope().getSuperScope();
            scope.removeSubScope(this.getScope());
            statements.setScope(scope);
            this.invalidate();
            return statements;
        }
        if (!statements.hasChildren() && !this.isGeneratingSource()) {
            if (!this.isTopLevel()) {
                return NullStatement.NODE;
            }
            if (exceptions != null) {
                exceptions.setFirst(null);
            }
        }
        if (exceptions != null) {
            DoBlock.sortOnBlocks(exceptions);
        }
        if (id != null) {
            this.setOperands(id, declarations, statements);
            statements.setNext(exceptions);
        } else {
            this.setOperands(declarations, statements, exceptions);
        }
        if (this.getTypeDescription() == TypeFactory.getNone()) {
            this.setTypeDescription(TypeFactory.getVoid());
        }
        return this;
    }

    Declaration findDeclaration(String id) {
        DoBlock doblock;
        Declaration decl;
        Block declarations = this.getDeclarations();
        Declaration declaration = decl = declarations != null ? (Declaration)declarations.getFirst() : null;
        while (decl != null && !decl.getName().equals(id)) {
            decl = (Declaration)decl.getNext();
        }
        if (decl == null && (doblock = this.getParent().getCurrentDoBlock()) != null) {
            decl = doblock.findDeclaration(id);
        }
        return decl;
    }

    @Override
    void generate(CodeGenerator cg) {
        cg.generate(this);
    }

    boolean hasOnlyStatements() {
        return !this.getDeclarations().hasChildren() && !this.getExceptions().hasChildren() && this.getOnExit() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        Block declarations = this.getDeclarations();
        Block statements = this.getStatements();
        Block exceptions = this.getExceptions();
        OnExit onExit = this.getOnExit();
        List<Object> stack = CollectionPool.getArrayList();
        DoBlock.pushVariables(declarations, stack);
        try {
            ((Node)declarations).run(rm);
        }
        catch (ExecutionException e) {
            DoBlock.popVariables(rm, declarations, stack);
            if (this.innerDeclarations != null) {
                for (Declaration innerDeclaration : this.innerDeclarations) {
                    Symbol symbol = innerDeclaration.getSymbol();
                    if (symbol.isSilentAutoDeclared()) continue;
                    rm.popVariable(symbol.getName());
                }
            }
            throw e;
        }
        ExecutionInterruptedException interrupted = null;
        try {
            ((Node)statements).run(rm);
            NodeIterator nodes = statements.getChildren();
            if (this.getScope().isStepEnabled()) {
                boolean synteticCode = true;
                while (nodes.hasNext()) {
                    Node current = nodes.next();
                    if (current.isSynthetic()) continue;
                    synteticCode = false;
                    break;
                }
                if (synteticCode) {
                    rm.stepEvent(0, 0);
                }
            }
        }
        catch (CompilerExceptionShell e) {
            Boolean caught = Boolean.FALSE;
            if (exceptions != null) {
                On onNode;
                NodeIterator it = exceptions.getChildren();
                while (it.hasNext() && !(caught = (Boolean)(onNode = (On)it.next()).run(rm, e.getThrowable())).booleanValue()) {
                }
            }
            if (!caught.booleanValue()) {
                throw e;
            }
        }
        catch (ExitException e) {
            if (e.getLabel() == null || !e.getLabel().equals(this.getName())) {
                throw e;
            }
        }
        catch (ExecutionInterruptedException e) {
            interrupted = e;
        }
        finally {
            if (interrupted != null) {
                DoBlock.popVariables(rm, declarations, stack);
                throw interrupted;
            }
            try {
                if (onExit != null) {
                    ((Node)onExit).run(rm);
                }
            }
            finally {
                DoBlock.popVariables(rm, declarations, stack);
            }
        }
        CollectionPool.releaseArrayList(stack);
        return null;
    }

    Iterator<Symbol> symbolsIterator() {
        if (this.symbols != null) {
            return this.symbols.listIterator();
        }
        return CollectionUtils.emptyIterator();
    }

    boolean wrapTypedExceptions() {
        return this.wrapTypedExceptions;
    }

    private static void sortOnBlocks(Node exceptions) {
        int count = exceptions.getNumberOfChildren();
        if (count > 1) {
            List onExceptionList = CollectionPool.getArrayList();
            for (Node current = exceptions.getFirst(); current != null; current = current.getNext()) {
                if (current instanceof On) {
                    onExceptionList.add((On)current);
                    continue;
                }
                assert (false) : "Invalid AST.";
            }
            exceptions.setFirst(null);
            if (!onExceptionList.isEmpty()) {
                Collections.sort(onExceptionList);
                exceptions.addAll(onExceptionList);
            }
            CollectionPool.releaseArrayList(onExceptionList);
        }
    }

    private void checkDuplicatedExceptions(Node exceptions) {
        Map<TypeDescription, On> exceptionsMap = CollectionPool.getHashMap();
        for (Node current = exceptions.getFirst(); current != null; current = current.getNext()) {
            if (!(current instanceof On)) continue;
            On node = (On)current;
            TypeDescription type = node.getExceptionType();
            if (exceptionsMap.containsKey(type)) {
                On other = (On)exceptionsMap.get(type);
                this.reportError(new DuplicatedException(other.getOp1(), other.getExceptionType()));
                this.reportError(new DuplicatedException(node.getOp1(), node.getExceptionType()));
            }
            exceptionsMap.put(type, node);
        }
        CollectionPool.releaseHashMap(exceptionsMap);
    }
}

