/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.Arg;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Diadic;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.NoSuchComponentException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.compiler.UndefinedVariableException;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;

public class Display
extends Diadic {
    private static final String XO_DISPLAY_CLASS = "Fuego.Internal.XObjectDisplayImpl";
    private static final String XO_DISPLAY_METHOD = "display";
    private static final String XO_DISPLAY_OBJECT = "XObjectDisplayImpl";
    private static final String[] SYNTHETIC_ARGS = new String[]{"message", "instance"};
    private static final String DISPLAY_CLASS = "Fuego.Internal.Display";
    private static final String DISPLAY_OBJECT = "CILDisplay";

    public Display(Token t) {
        super(t);
    }

    Display() {
    }

    public static Display message(Node message) {
        Display display = new Display();
        display.setFirst(message);
        return display;
    }

    @Override
    public String getText() {
        return XO_DISPLAY_METHOD;
    }

    @Override
    public void generate(SourceGenerator cg) {
        Node message;
        Args outargs;
        Args inargs;
        Invoke targetInvoke = null;
        if (this.getKind() != -1) {
            Invoke invoke = (Invoke)this.getOp1();
            inargs = invoke.getInputArgs();
            outargs = invoke.getOutputArgs();
            Arg msgArg = inargs.getArgByName("message");
            Arg instanceArg = inargs.getArgByName("instance");
            targetInvoke = invoke.getTargetInvoke();
            message = msgArg != null ? msgArg.getValue() : instanceArg.getValue();
        } else {
            message = this.getOp1();
            inargs = (Args)this.getOp2();
            outargs = inargs != null ? (Args)inargs.getNext() : null;
        }
        cg.generate(this, message, inargs, outargs, targetInvoke);
    }

    @Override
    protected String getStatementSeparator() {
        return null;
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        return this.getFirst().checkFlow(context);
    }

    @Override
    Node checkType() throws TypeException {
        Node text;
        this.setTypeDescription(TypeFactory.getVoid());
        Node op1 = this.getOp1();
        Node op2 = this.getOp2();
        UndefinedVariableException undef = null;
        Args args = (Args)op2;
        try {
            text = op1.checkType();
        }
        catch (UndefinedVariableException e) {
            text = null;
            undef = e;
        }
        if (text == null) {
            try {
                TypeDescription opType = TypeSpec.findType(op1);
                MemberAccess.defaultInstanceFor(opType, op1);
                text = op1.getAutoDeclared(opType, true);
            }
            catch (NoSuchComponentException e) {
                throw undef;
            }
        }
        TypeDescription xobjType = text.getTypeDescription();
        TypeDescription xobjBase = this.findType("Fuego.Lang.Presentable");
        if (xobjBase.isAssignableFrom(xobjType) && xobjType.getKind() != 9) {
            args = Args.ensureNotNullArgs(null, args, this.getScope());
            args.addInArgument("instance", text);
            args.setSyntheticArgs(SYNTHETIC_ARGS);
            Identifier id = new Identifier(XO_DISPLAY_OBJECT, this);
            id.getAutoDeclared(this.findType(XO_DISPLAY_CLASS), true);
            Node invoke = new Invoke(XO_DISPLAY_METHOD, XO_DISPLAY_OBJECT, args);
            invoke.setParent(this);
            invoke.initialize(this);
            invoke = ((Node)invoke).checkType();
            this.setOperand(invoke);
            return this;
        }
        TypeDescription typeDescription = text.getTypeDescription();
        if (!typeDescription.isArray() && typeDescription.isPrimitive()) {
            text = Conversion.Box.create(text);
        } else if (typeDescription.isEnum()) {
            text = Conversion.promote(text, TypeFactory.getString());
        }
        text = new Conversion.DynamicView(text);
        args = Args.ensureNotNullArgs(null, args, this.getScope());
        args.addInArgument("message", text);
        args.initialize(this);
        args.setSyntheticArgs(SYNTHETIC_ARGS);
        Invoke result = new Invoke("run", DISPLAY_OBJECT, args);
        result.initialize(this);
        result.setParent(this);
        Identifier.autodeclare(DISPLAY_OBJECT, this.findType(DISPLAY_CLASS), this, true);
        this.setFirst(((Node)result).checkType());
        return this;
    }

    @Override
    void generate(CodeGenerator cg) {
        this.getOp1().gen(cg);
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        return this.getOp1().run(rm);
    }
}

